/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import org.cojen.tupl.DirectPageOps;
import org.cojen.tupl.PageCache;
import org.cojen.tupl.Utils;
import org.cojen.tupl.util.Latch;

final class BasicPageCache
extends Latch
implements PageCache {
    private static final int PAGE_ID_FIELD = 0;
    private static final int LESS_RECENT_PTR_FIELD = 2;
    private static final int MORE_RECENT_PTR_FIELD = 3;
    private static final int CHAIN_NEXT_PTR_FIELD = 4;
    private static final int NODE_SIZE_IN_INTS = 5;
    private static final int NO_NEXT_ENTRY = -1;
    private static final int UNUSED_NODE = -2;
    private final int mPageSize;
    private final int[] mHashTable;
    private ByteBuffer mNodesByteBuffer;
    private IntBuffer mNodes;
    private ByteBuffer mData;
    private int mLeastRecentPtr;
    private int mMostRecentPtr;

    BasicPageCache(int capacity, int pageSize) {
        int ptr;
        int entryCount = BasicPageCache.entryCountFor(capacity, pageSize);
        this.mPageSize = pageSize;
        this.mHashTable = new int[entryCount];
        this.acquireExclusive();
        this.mNodesByteBuffer = ByteBuffer.allocateDirect(entryCount * 20).order(ByteOrder.nativeOrder());
        this.mNodes = this.mNodesByteBuffer.asIntBuffer();
        this.mData = ByteBuffer.allocateDirect(entryCount * pageSize);
        for (ptr = 0; ptr < entryCount * 5; ptr += 5) {
            this.mNodes.put(ptr + 2, ptr - 5);
            this.mNodes.put(ptr + 3, ptr + 5);
            this.mNodes.put(ptr + 4, -2);
        }
        this.mLeastRecentPtr = 0;
        this.mMostRecentPtr = ptr - 5;
        for (int i = 0; i < this.mHashTable.length; ++i) {
            this.mHashTable[i] = -1;
        }
        this.releaseExclusive();
    }

    static int entryCountFor(int capacity, int pageSize) {
        return Math.max(2, capacity / (20 + pageSize));
    }

    static int capacityFor(int entryCount, int pageSize) {
        return entryCount * 20 + entryCount * pageSize;
    }

    @Override
    public boolean add(long pageId, byte[] page, int offset, boolean canEvict) {
        return this.add(pageId, canEvict, (dst, pageSize) -> dst.put(page, offset, pageSize));
    }

    @Override
    public boolean add(long pageId, long pagePtr, int offset, boolean canEvict) {
        return this.add(pageId, canEvict, (dst, pageSize) -> DirectPageOps.p_copyToBB(pagePtr, offset, dst, pageSize));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean add(long pageId, boolean canEvict, CopyToBB copier) {
        this.acquireExclusive();
        try {
            int n;
            IntBuffer nodes = this.mNodes;
            if (nodes == null) {
                boolean bl = false;
                return bl;
            }
            int[] hashTable = this.mHashTable;
            int index = BasicPageCache.hash(pageId) % hashTable.length;
            int n2 = hashTable[index];
            if (n2 >= 0) {
                while (true) {
                    int n3;
                    int bl = nodes.get((int)(n3 + 4));
                    if (BasicPageCache.getPageId(nodes, n3) == pageId) {
                        this.mData.position((int)(n3 / 5 * this.mPageSize));
                        copier.copyToBB(this.mData, this.mPageSize);
                        if (n3 != this.mMostRecentPtr) {
                            int morePtr = nodes.get(n3 + 3);
                            if (n3 == this.mLeastRecentPtr) {
                                this.mLeastRecentPtr = morePtr;
                            } else {
                                int lessPtr = nodes.get(n3 + 2);
                                nodes.put(morePtr + 2, lessPtr);
                                nodes.put(lessPtr + 3, morePtr);
                            }
                            nodes.put(this.mMostRecentPtr + 3, n3);
                            nodes.put(n3 + 2, this.mMostRecentPtr);
                            this.mMostRecentPtr = n3;
                        }
                        boolean bl2 = true;
                        return bl2;
                    }
                    if (bl < 0) break;
                    n3 = bl;
                }
            }
            if (nodes.get((n = this.mLeastRecentPtr) + 4) != -2) {
                if (!canEvict) {
                    boolean bl = false;
                    return bl;
                }
                long l = BasicPageCache.getPageId(nodes, n);
                int evictedIndex = BasicPageCache.hash(l) % hashTable.length;
                int entryPtr = hashTable[evictedIndex];
                if (entryPtr >= 0) {
                    int prevPtr = -1;
                    while (true) {
                        int chainNextPtr2 = nodes.get(entryPtr + 4);
                        if (BasicPageCache.getPageId(nodes, entryPtr) == l) {
                            if (prevPtr < 0) {
                                hashTable[evictedIndex] = chainNextPtr2;
                                break;
                            }
                            nodes.put(prevPtr + 4, chainNextPtr2);
                            break;
                        }
                        if (chainNextPtr2 < 0) break;
                        prevPtr = entryPtr;
                        entryPtr = chainNextPtr2;
                    }
                }
            }
            this.mLeastRecentPtr = nodes.get(n + 3);
            nodes.put(this.mMostRecentPtr + 3, n);
            nodes.put(n + 2, this.mMostRecentPtr);
            this.mMostRecentPtr = n;
            this.mData.position(n / 5 * this.mPageSize);
            copier.copyToBB(this.mData, this.mPageSize);
            nodes.put(n + 4, hashTable[index]);
            hashTable[index] = n;
            BasicPageCache.setPageId(nodes, n, pageId);
            boolean bl = true;
            return bl;
        }
        finally {
            this.releaseExclusive();
        }
    }

    @Override
    public boolean copy(long pageId, int start, byte[] page, int offset) {
        return this.copy(pageId, start, (src, pageSize) -> src.get(page, offset, pageSize));
    }

    @Override
    public boolean copy(long pageId, int start, long pagePtr, int offset) {
        return this.copy(pageId, start, (src, pageSize) -> DirectPageOps.p_copyFromBB(src, pagePtr, offset, pageSize));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean copy(long pageId, int start, CopyFromBB copier) {
        this.acquireShared();
        try {
            IntBuffer nodes = this.mNodes;
            if (nodes == null) {
                boolean bl = false;
                return bl;
            }
            int[] hashTable = this.mHashTable;
            int index = BasicPageCache.hash(pageId) % hashTable.length;
            int ptr = hashTable[index];
            if (ptr >= 0) {
                while (true) {
                    int chainNextPtr = nodes.get(ptr + 4);
                    if (BasicPageCache.getPageId(nodes, ptr) == pageId) {
                        this.mData.position(ptr / 5 * this.mPageSize + start);
                        copier.copyFromBB(this.mData, this.mPageSize);
                        boolean bl = true;
                        return bl;
                    }
                    if (chainNextPtr < 0) break;
                    ptr = chainNextPtr;
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.releaseShared();
        }
    }

    @Override
    public boolean remove(long pageId, byte[] page, int offset, int length) {
        return this.remove(pageId, page == null ? null : (src, pageSize) -> src.get(page, offset, length));
    }

    @Override
    public boolean remove(long pageId, long pagePtr, int offset, int length) {
        return this.remove(pageId, pagePtr == DirectPageOps.p_null() ? null : (src, pageSize) -> DirectPageOps.p_copyFromBB(src, pagePtr, offset, length));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean remove(long pageId, CopyFromBB copier) {
        this.acquireExclusive();
        try {
            IntBuffer nodes = this.mNodes;
            if (nodes == null) {
                boolean bl = false;
                return bl;
            }
            int[] hashTable = this.mHashTable;
            int index = BasicPageCache.hash(pageId) % hashTable.length;
            int ptr = hashTable[index];
            if (ptr >= 0) {
                int prevPtr = -1;
                while (true) {
                    int chainNextPtr = nodes.get(ptr + 4);
                    if (BasicPageCache.getPageId(nodes, ptr) == pageId) {
                        if (copier != null) {
                            this.mData.position(ptr / 5 * this.mPageSize);
                            copier.copyFromBB(this.mData, this.mPageSize);
                        }
                        if (ptr != this.mLeastRecentPtr) {
                            int lessPtr = nodes.get(ptr + 2);
                            if (ptr == this.mMostRecentPtr) {
                                this.mMostRecentPtr = lessPtr;
                            } else {
                                int morePtr = nodes.get(ptr + 3);
                                nodes.put(lessPtr + 3, morePtr);
                                nodes.put(morePtr + 2, lessPtr);
                            }
                            nodes.put(this.mLeastRecentPtr + 2, ptr);
                            nodes.put(ptr + 3, this.mLeastRecentPtr);
                            this.mLeastRecentPtr = ptr;
                        }
                        if (prevPtr < 0) {
                            hashTable[index] = chainNextPtr;
                        } else {
                            nodes.put(prevPtr + 4, chainNextPtr);
                        }
                        nodes.put(ptr + 4, -2);
                        boolean bl = true;
                        return bl;
                    }
                    if (chainNextPtr < 0) break;
                    prevPtr = ptr;
                    ptr = chainNextPtr;
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.releaseExclusive();
        }
    }

    @Override
    public long capacity() {
        return this.mNodesByteBuffer.capacity() + this.mData.capacity();
    }

    @Override
    public long maxEntryCount() {
        return this.mHashTable.length;
    }

    @Override
    public void close() {
        block6: {
            this.acquireExclusive();
            try {
                if (this.mNodes == null) break block6;
                try {
                    Utils.delete(this.mNodesByteBuffer);
                    Utils.delete(this.mData);
                }
                finally {
                    this.mNodes = null;
                    this.mData = null;
                }
            }
            finally {
                this.releaseExclusive();
            }
        }
    }

    private static long getPageId(IntBuffer nodes, int ptr) {
        return (long)nodes.get(ptr + 0) & 0xFFFFFFFFL | (long)nodes.get(ptr + 1) << 32;
    }

    private static void setPageId(IntBuffer nodes, int ptr, long pageId) {
        nodes.put(ptr + 0, (int)pageId);
        nodes.put(ptr + 1, (int)(pageId >>> 32));
    }

    private static int hash(long pageId) {
        return Long.hashCode(pageId) & Integer.MAX_VALUE;
    }

    @FunctionalInterface
    static interface CopyFromBB {
        public void copyFromBB(ByteBuffer var1, int var2);
    }

    @FunctionalInterface
    static interface CopyToBB {
        public void copyToBB(ByteBuffer var1, int var2);
    }
}

