/*
 * Decompiled with CFR 0.152.
 */
package com.codekidlabs.storagechooser.utils;

import android.os.StatFs;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;

public class MemoryUtil {
    private static final String ERROR = "error";
    public static final String SELF_DIR_NAME = "self";
    public static final String EMULATED_DIR_NAME = "emulated";
    public static final String SDCARD0_DIR_NAME = "sdcard0";

    public static boolean isExternalStoragePresent() {
        return MemoryUtil.getStorageListSize() == 0;
    }

    public static int getStorageListSize() {
        File storageDir = new File("/storage");
        ArrayList volumeList = new ArrayList();
        Collections.addAll(volumeList, storageDir.listFiles());
        for (int i = 0; i < volumeList.size(); ++i) {
            if (((File)volumeList.get(i)).getName().equals(SELF_DIR_NAME)) {
                volumeList.remove(i);
            }
            if (((File)volumeList.get(i)).getName().equals(EMULATED_DIR_NAME)) {
                volumeList.remove(i);
            }
            if (!((File)volumeList.get(i)).getName().equals(SDCARD0_DIR_NAME)) continue;
            volumeList.remove(i);
        }
        return volumeList.size();
    }

    public static String getAvailableMemorySize(File file) {
        StatFs stat = new StatFs(file.getPath());
        long blockSize = stat.getBlockSize();
        long availableBlocks = stat.getAvailableBlocks();
        return MemoryUtil.formatSize(availableBlocks * blockSize);
    }

    public static String getTotalMemorySize(File file) {
        StatFs stat = new StatFs(file.getPath());
        long blockSize = stat.getBlockSize();
        long totalBlocks = stat.getBlockCount();
        return MemoryUtil.formatSize(totalBlocks * blockSize);
    }

    public static String formatSize(long size) {
        String suffix = null;
        if (size >= 1024L) {
            suffix = "KB";
            if ((size /= 1024L) >= 1024L) {
                suffix = "MB";
                if ((size /= 1024L) >= 1024L) {
                    suffix = "GiB";
                    size /= 1024L;
                }
            }
        }
        StringBuilder resultBuffer = new StringBuilder(Long.toString(size));
        for (int commaOffset = resultBuffer.length() - 3; commaOffset > 0; commaOffset -= 3) {
            resultBuffer.insert(commaOffset, ',');
        }
        if (suffix != null) {
            resultBuffer.append(suffix);
        }
        return resultBuffer.toString();
    }
}

