/*
 * Decompiled with CFR 0.152.
 */
package com.codekidlabs.storagechooser.fragments;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.DialogFragment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ListAdapter;
import android.widget.ListView;
import com.codekidlabs.storagechooser.ExternalStoragePathFinder;
import com.codekidlabs.storagechooser.R;
import com.codekidlabs.storagechooser.adapters.PathFinderListAdapter;
import com.codekidlabs.storagechooser.utils.DiskUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class PathFinderDialogFragment
extends DialogFragment {
    private View mLayout;
    private ViewGroup mContainer;
    private static List<String> storagesList;
    private static String mPath;
    private static PathFinderDialogFragment sPathFinder;

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        sPathFinder = this;
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        this.mContainer = container;
        if (this.getShowsDialog()) {
            return super.onCreateView(inflater, container, savedInstanceState);
        }
        return this.getLayout(inflater, container);
    }

    private View getLayout(LayoutInflater inflater, ViewGroup container) {
        this.mLayout = inflater.inflate(R.layout.path_finder_list, container, false);
        PathFinderDialogFragment.initListView(this.getContext(), this.mLayout);
        return this.mLayout;
    }

    private static void initListView(Context context, View view) {
        ListView listView = (ListView)view.findViewById(R.id.storage_list_view);
        PathFinderDialogFragment.populateList();
        listView.setAdapter((ListAdapter)new PathFinderListAdapter(context, storagesList));
        listView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> adapterView, View view, int i, long l) {
                mPath = (String)storagesList.get(i);
                sPathFinder.dismiss();
            }
        });
    }

    private static void populateList() {
        File[] storageDirs;
        storagesList = new ArrayList<String>();
        File rootStorageDir = new File("/storage");
        for (File f : storageDirs = rootStorageDir.listFiles()) {
            storagesList.add(f.getName());
        }
    }

    public Dialog onCreateDialog(Bundle savedInstanceState) {
        Dialog d = ExternalStoragePathFinder.dialog;
        d.setContentView(this.getLayout(LayoutInflater.from((Context)this.getContext()), this.mContainer));
        return d;
    }

    public void onDismiss(DialogInterface dialog) {
        ExternalStoragePathFinder.STORAGE_EXTERNAL_PATH = mPath;
        if (ExternalStoragePathFinder.getUserSharedPreference() != null) {
            DiskUtil.saveFinderPathPreference(ExternalStoragePathFinder.getUserSharedPreference(), ExternalStoragePathFinder.EXTERNAL_STORAGE_PATH_KEY);
        }
        super.onDismiss(dialog);
    }
}

