/*
 * Decompiled with CFR 0.152.
 */
package com.codekidlabs.storagechooser.fragments;

import android.annotation.SuppressLint;
import android.app.Dialog;
import android.app.DialogFragment;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.ColorStateList;
import android.graphics.drawable.Animatable;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.view.inputmethod.InputMethodManager;
import android.widget.AdapterView;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;
import at.markushi.ui.CircleButton;
import com.codekidlabs.storagechooser.Content;
import com.codekidlabs.storagechooser.R;
import com.codekidlabs.storagechooser.StorageChooser;
import com.codekidlabs.storagechooser.adapters.SecondaryChooserAdapter;
import com.codekidlabs.storagechooser.filters.UniversalFileFilter;
import com.codekidlabs.storagechooser.fragments.ChooserDialogFragment;
import com.codekidlabs.storagechooser.models.Config;
import com.codekidlabs.storagechooser.utils.DiskUtil;
import com.codekidlabs.storagechooser.utils.FileUtil;
import com.codekidlabs.storagechooser.utils.ResourceUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class SecondaryChooserFragment
extends DialogFragment {
    private static final String INTERNAL_STORAGE_TITLE = "Internal Storage";
    private static final String EXTERNAL_STORAGE_TITLE = "ExtSD";
    private static final int FLAG_DISSMISS_NORMAL = 0;
    private static final int FLAG_DISSMISS_INIT_DIALOG = 1;
    private static boolean MODE_MULTIPLE = false;
    private static String theSelectedPath = "";
    private static String mAddressClippedPath = "";
    private View mLayout;
    private View mInactiveGradient;
    private ViewGroup mContainer;
    private TextView mPathChosen;
    private ImageButton mBackButton;
    private Button mSelectButton;
    private Button mCreateButton;
    private ImageView mNewFolderImageView;
    private EditText mFolderNameEditText;
    private CircleButton mMultipleOnSelectButton;
    private RelativeLayout mNewFolderView;
    private ProgressBar mFilesProgress;
    private String mBundlePath;
    private ListView listView;
    private boolean isOpen;
    private List<String> customStoragesList;
    private SecondaryChooserAdapter secondaryChooserAdapter;
    private FileUtil fileUtil;
    private int[] scheme;
    private Config mConfig;
    private Content mContent;
    private Context mContext;
    private Handler mHandler;
    private ResourceUtil mResourceUtil;
    private ArrayList<String> mMultipleModeList = new ArrayList();
    private View.OnClickListener mSelectButtonClickListener = new View.OnClickListener(){

        public void onClick(View view) {
            if (SecondaryChooserFragment.this.mConfig.isActionSave()) {
                DiskUtil.saveChooserPathPreference(SecondaryChooserFragment.this.mConfig.getPreference(), theSelectedPath);
            } else {
                Log.d((String)"StorageChooser", (String)("Chosen path: " + theSelectedPath));
            }
            StorageChooser.onSelectListener.onSelect(theSelectedPath);
            SecondaryChooserFragment.this.dissmissDialog(0);
        }
    };
    private View.OnClickListener mNewFolderButtonCloseListener = new View.OnClickListener(){

        public void onClick(View view) {
            SecondaryChooserFragment.this.hideAddFolderView();
            SecondaryChooserFragment.this.hideKeyboard();
        }
    };
    private View.OnClickListener mNewFolderButtonClickListener = new View.OnClickListener(){

        public void onClick(View view) {
            SecondaryChooserFragment.this.showAddFolderView();
        }
    };
    private boolean keyboardToggle;
    private final String TAG = "StorageChooser";
    private boolean isFilePicker;
    private View.OnClickListener mCreateButtonClickListener = new View.OnClickListener(){

        public void onClick(View view) {
            if (SecondaryChooserFragment.this.validateFolderName()) {
                boolean success = FileUtil.createDirectory(SecondaryChooserFragment.this.mFolderNameEditText.getText().toString().trim(), theSelectedPath);
                if (success) {
                    Toast.makeText((Context)SecondaryChooserFragment.this.mContext, (CharSequence)SecondaryChooserFragment.this.mContent.getFolderCreatedToastText(), (int)0).show();
                    SecondaryChooserFragment.this.trimPopulate(theSelectedPath);
                    SecondaryChooserFragment.this.hideKeyboard();
                    SecondaryChooserFragment.this.hideAddFolderView();
                } else {
                    Toast.makeText((Context)SecondaryChooserFragment.this.mContext, (CharSequence)SecondaryChooserFragment.this.mContent.getFolderErrorToastText(), (int)0).show();
                }
            }
        }
    };
    private AdapterView.OnItemClickListener mSingleModeClickListener = new AdapterView.OnItemClickListener(){

        public void onItemClick(AdapterView<?> adapterView, View view, final int i, long l) {
            SecondaryChooserFragment.this.mHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    String jointPath = theSelectedPath + "/" + (String)SecondaryChooserFragment.this.customStoragesList.get(i);
                    if (FileUtil.isDir(jointPath)) {
                        SecondaryChooserFragment.this.populateList("/" + (String)SecondaryChooserFragment.this.customStoragesList.get(i));
                    } else {
                        StorageChooser.onSelectListener.onSelect(jointPath);
                        SecondaryChooserFragment.this.dissmissDialog(0);
                    }
                }
            }, 300L);
        }
    };
    private AdapterView.OnItemLongClickListener mLongClickListener = new AdapterView.OnItemLongClickListener(){

        public boolean onItemLongClick(AdapterView<?> adapterView, View view, int i, long l) {
            String jointPath = theSelectedPath + "/" + (String)SecondaryChooserFragment.this.customStoragesList.get(i);
            if (!FileUtil.isDir(jointPath)) {
                MODE_MULTIPLE = true;
                SecondaryChooserFragment.this.listView.setOnItemClickListener(SecondaryChooserFragment.this.mMultipleModeClickListener);
                SecondaryChooserFragment.this.handleListMultipleAction(i, view);
            } else {
                SecondaryChooserFragment.this.populateList("/" + (String)SecondaryChooserFragment.this.customStoragesList.get(i));
            }
            return true;
        }
    };
    private View.OnClickListener mBackButtonClickListener = new View.OnClickListener(){

        public void onClick(View view) {
            SecondaryChooserFragment.this.performBackAction();
        }
    };
    private View.OnClickListener mMultipleModeDoneButtonClickListener = new View.OnClickListener(){

        public void onClick(View view) {
            StorageChooser.onMultipleSelectListener.onDone(SecondaryChooserFragment.this.mMultipleModeList);
            SecondaryChooserFragment.this.bringBackSingleMode();
            SecondaryChooserFragment.this.dissmissDialog(0);
        }
    };
    private AdapterView.OnItemClickListener mMultipleModeClickListener = new AdapterView.OnItemClickListener(){

        public void onItemClick(AdapterView<?> adapterView, View view, int i, long l) {
            String jointPath = theSelectedPath + "/" + (String)SecondaryChooserFragment.this.customStoragesList.get(i);
            if (!FileUtil.isDir(jointPath)) {
                SecondaryChooserFragment.this.handleListMultipleAction(i, view);
            } else {
                SecondaryChooserFragment.this.bringBackSingleMode();
                SecondaryChooserFragment.this.populateList("/" + (String)SecondaryChooserFragment.this.customStoragesList.get(i));
            }
        }
    };

    private void showAddFolderView() {
        this.mNewFolderView.setVisibility(0);
        Animation anim2 = AnimationUtils.loadAnimation((Context)this.mContext, (int)R.anim.anim_new_folder_view);
        this.mNewFolderView.startAnimation(anim2);
        this.mInactiveGradient.startAnimation(anim2);
        if (DiskUtil.isLollipopAndAbove()) {
            this.mNewFolderImageView.setImageDrawable(ContextCompat.getDrawable((Context)this.mContext, (int)R.drawable.drawable_plus_to_close));
            Animatable animatable = (Animatable)this.mNewFolderImageView.getDrawable();
            animatable.start();
        }
        this.mNewFolderImageView.setOnClickListener(this.mNewFolderButtonCloseListener);
        SecondaryChooserAdapter.shouldEnable = false;
    }

    private void hideAddFolderView() {
        Animation anim2 = AnimationUtils.loadAnimation((Context)this.mContext, (int)R.anim.anim_close_folder_view);
        this.mNewFolderView.startAnimation(anim2);
        this.mNewFolderView.setVisibility(4);
        if (DiskUtil.isLollipopAndAbove()) {
            this.mNewFolderImageView.setImageDrawable(ContextCompat.getDrawable((Context)this.mContext, (int)R.drawable.drawable_close_to_plus));
            Animatable animatable = (Animatable)this.mNewFolderImageView.getDrawable();
            animatable.start();
        }
        this.mNewFolderImageView.setOnClickListener(this.mNewFolderButtonClickListener);
        SecondaryChooserAdapter.shouldEnable = true;
        this.mInactiveGradient.startAnimation(anim2);
        this.mInactiveGradient.setVisibility(4);
    }

    private boolean isFolderViewVisible() {
        return this.mNewFolderView.getVisibility() == 0;
    }

    public void hideKeyboard() {
        InputMethodManager imm = (InputMethodManager)this.getActivity().getSystemService("input_method");
        imm.hideSoftInputFromWindow(this.mFolderNameEditText.getWindowToken(), 0);
    }

    private void performBackAction() {
        int slashIndex = theSelectedPath.lastIndexOf("/");
        if (slashIndex != -1) {
            if (MODE_MULTIPLE) {
                this.bringBackSingleMode();
                this.secondaryChooserAdapter.notifyDataSetChanged();
            } else if (!this.mConfig.isSkipOverview()) {
                if (theSelectedPath.equals(this.mBundlePath)) {
                    this.dismiss();
                    this.mHandler.postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            SecondaryChooserFragment.this.dissmissDialog(1);
                        }
                    }, 200L);
                } else {
                    StorageChooser.LAST_SESSION_PATH = theSelectedPath = theSelectedPath.substring(0, slashIndex);
                    this.populateList("");
                }
            } else {
                this.dissmissDialog(0);
            }
        } else {
            StorageChooser.LAST_SESSION_PATH = theSelectedPath = this.mBundlePath;
            this.populateList("");
        }
    }

    private void dissmissDialog(int flag) {
        switch (flag) {
            case 1: {
                ChooserDialogFragment c = new ChooserDialogFragment();
                c.show(this.mConfig.getFragmentManager(), "storagechooser_dialog");
                break;
            }
            case 0: {
                StorageChooser.LAST_SESSION_PATH = theSelectedPath;
                this.dismiss();
            }
        }
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        this.mContainer = container;
        if (this.getShowsDialog()) {
            return super.onCreateView(inflater, container, savedInstanceState);
        }
        return this.getLayout(inflater, container);
    }

    private View getLayout(LayoutInflater inflater, ViewGroup container) {
        this.mConfig = StorageChooser.sConfig;
        this.scheme = this.mConfig.getScheme();
        this.mHandler = new Handler();
        this.mContent = this.mConfig.getContent() == null ? new Content() : this.mConfig.getContent();
        this.mContext = this.getActivity().getApplicationContext();
        this.mResourceUtil = new ResourceUtil(this.mContext);
        this.mLayout = inflater.inflate(R.layout.custom_storage_list, container, false);
        this.initListView(this.mContext, this.mLayout, this.mConfig.isShowMemoryBar());
        this.initUI();
        this.initNewFolderView();
        this.updateUI();
        return this.mLayout;
    }

    private void initUI() {
        this.mBackButton = (ImageButton)this.mLayout.findViewById(R.id.back_button);
        this.mSelectButton = (Button)this.mLayout.findViewById(R.id.select_button);
        this.mMultipleOnSelectButton = (CircleButton)this.mLayout.findViewById(R.id.multiple_selection_done_fab);
        this.mCreateButton = (Button)this.mLayout.findViewById(R.id.create_folder_button);
        this.mNewFolderView = (RelativeLayout)this.mLayout.findViewById(R.id.new_folder_view);
        this.mNewFolderView.setBackgroundColor(this.scheme[12]);
        this.mFolderNameEditText = (EditText)this.mLayout.findViewById(R.id.et_folder_name);
        this.mInactiveGradient = this.mLayout.findViewById(R.id.inactive_gradient);
        this.mLayout.findViewById(R.id.secondary_container).setBackgroundColor(this.scheme[7]);
    }

    private void updateUI() {
        this.mNewFolderView.setVisibility(4);
        this.mInactiveGradient.setVisibility(4);
        this.mFolderNameEditText.setHint((CharSequence)this.mContent.getTextfieldHintText());
        if (Build.VERSION.SDK_INT >= 21) {
            this.mFolderNameEditText.setHintTextColor(this.scheme[10]);
        }
        this.mSelectButton.setText((CharSequence)this.mContent.getSelectLabel());
        this.mCreateButton.setText((CharSequence)this.mContent.getCreateLabel());
        this.mSelectButton.setTextColor(this.scheme[11]);
        this.mPathChosen.setTextColor(this.scheme[9]);
        if (this.mConfig.getHeadingFont() != null) {
            this.mPathChosen.setTypeface(ChooserDialogFragment.getSCTypeface(this.mContext, this.mConfig.getHeadingFont(), this.mConfig.isHeadingFromAssets()));
        }
        if (Build.VERSION.SDK_INT >= 21) {
            this.mNewFolderImageView.setImageTintList(ColorStateList.valueOf((int)this.scheme[9]));
            this.mBackButton.setImageTintList(ColorStateList.valueOf((int)this.scheme[9]));
        }
        this.mMultipleOnSelectButton.setColor(this.scheme[13]);
        this.mLayout.findViewById(R.id.custom_path_header).setBackgroundColor(this.scheme[14]);
        this.mBackButton.setOnClickListener(this.mBackButtonClickListener);
        this.mSelectButton.setOnClickListener(this.mSelectButtonClickListener);
        this.mCreateButton.setOnClickListener(this.mCreateButtonClickListener);
        this.mMultipleOnSelectButton.setOnClickListener(this.mMultipleModeDoneButtonClickListener);
        if (this.mConfig.getSecondaryAction().equals("file")) {
            this.mSelectButton.setVisibility(8);
            this.setBottomNewFolderView();
        }
    }

    private void setBottomNewFolderView() {
        int height = (int)TypedValue.applyDimension((int)1, (float)80.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
        RelativeLayout.LayoutParams lp = new RelativeLayout.LayoutParams(-1, height);
        lp.addRule(12);
        this.mNewFolderView.setLayoutParams((ViewGroup.LayoutParams)lp);
    }

    private void initNewFolderView() {
        RelativeLayout mNewFolderButtonHolder = (RelativeLayout)this.mLayout.findViewById(R.id.new_folder_button_holder);
        this.mNewFolderImageView = (ImageView)this.mLayout.findViewById(R.id.new_folder_iv);
        this.mNewFolderImageView.setOnClickListener(this.mNewFolderButtonClickListener);
        if (!this.mConfig.isAllowAddFolder()) {
            mNewFolderButtonHolder.setVisibility(8);
        }
    }

    private void initListView(Context context, View view, boolean shouldShowMemoryBar) {
        this.listView = (ListView)view.findViewById(R.id.storage_list_view);
        this.mPathChosen = (TextView)view.findViewById(R.id.path_chosen);
        this.mFilesProgress = (ProgressBar)this.mLayout.findViewById(R.id.files_loader);
        this.mFilesProgress.setIndeterminate(true);
        if (Build.VERSION.SDK_INT >= 21) {
            this.mFilesProgress.setIndeterminateTintList(ColorStateList.valueOf((int)this.scheme[5]));
        }
        this.mBundlePath = this.getArguments().getString("storage_chooser_path");
        this.isFilePicker = this.getArguments().getBoolean(DiskUtil.SC_CHOOSER_FLAG, false);
        this.populateList(this.mBundlePath);
        this.secondaryChooserAdapter = new SecondaryChooserAdapter(this.customStoragesList, context, this.scheme, this.mConfig.getListFont(), this.mConfig.isListFromAssets());
        this.secondaryChooserAdapter.setPrefixPath(theSelectedPath);
        this.listView.setAdapter((ListAdapter)this.secondaryChooserAdapter);
        SecondaryChooserAdapter.shouldEnable = true;
        this.listView.setOnItemClickListener(this.mSingleModeClickListener);
        if (this.isFilePicker && this.mConfig.isMultiSelect()) {
            this.listView.setOnItemLongClickListener(this.mLongClickListener);
        }
    }

    private void handleListMultipleAction(int i, View view) {
        String jointPath = theSelectedPath + "/" + this.customStoragesList.get(i);
        if (!this.secondaryChooserAdapter.selectedPaths.contains(i)) {
            view.setBackgroundColor(this.mResourceUtil.getPrimaryColorWithAlpha());
            this.secondaryChooserAdapter.selectedPaths.add(i);
            this.mMultipleModeList.add(jointPath);
        } else {
            this.secondaryChooserAdapter.selectedPaths.remove(this.secondaryChooserAdapter.selectedPaths.indexOf(i));
            view.setBackgroundColor(this.scheme[7]);
            this.mMultipleModeList.remove(this.mMultipleModeList.indexOf(jointPath));
        }
        if (this.mMultipleOnSelectButton.getVisibility() != 0 && MODE_MULTIPLE) {
            this.playTheMultipleButtonAnimation();
        }
        if (this.listView.getOnItemLongClickListener() != null && MODE_MULTIPLE) {
            this.listView.setOnItemLongClickListener(null);
        }
        if (this.mMultipleModeList.size() == 0) {
            this.bringBackSingleMode();
        }
    }

    private void bringBackSingleMode() {
        MODE_MULTIPLE = false;
        this.listView.setOnItemClickListener(this.mSingleModeClickListener);
        this.mMultipleModeList.clear();
        this.secondaryChooserAdapter.selectedPaths.clear();
        this.playTheMultipleButtonEndAnimation();
        this.listView.setOnItemLongClickListener(this.mLongClickListener);
    }

    private void evaluateAction(int i) {
        String preDefPath = this.mConfig.getPredefinedPath();
        boolean isCustom = this.mConfig.isAllowCustomPath();
        if (preDefPath == null) {
            Log.w((String)"StorageChooser", (String)"No predefined path set");
        } else if (isCustom) {
            this.populateList("/" + this.customStoragesList.get(i));
        }
    }

    private boolean doesPassMemoryThreshold(long threshold, String memorySuffix, long availableSpace) {
        return true;
    }

    private void populateList(String path) {
        int pathLength;
        if (this.customStoragesList == null) {
            this.customStoragesList = new ArrayList<String>();
        } else {
            this.customStoragesList.clear();
        }
        this.fileUtil = new FileUtil();
        theSelectedPath = theSelectedPath + path;
        if (this.secondaryChooserAdapter != null && this.secondaryChooserAdapter.getPrefixPath() != null) {
            this.secondaryChooserAdapter.setPrefixPath(theSelectedPath);
        }
        if ((pathLength = theSelectedPath.length()) >= 25) {
            int slashCount = this.getSlashCount(theSelectedPath);
            if (slashCount > 2) {
                mAddressClippedPath = theSelectedPath.substring(theSelectedPath.indexOf("/", theSelectedPath.indexOf("/") + 2), pathLength);
            } else if (slashCount <= 2) {
                mAddressClippedPath = theSelectedPath.substring(theSelectedPath.indexOf("/", theSelectedPath.indexOf("/") + 2), pathLength);
            }
        } else {
            mAddressClippedPath = theSelectedPath;
        }
        if (this.isFilePicker) {
            if (this.mConfig.isCustomFilter()) {
                new FileFilterTask(this.mConfig, true).execute(new Void[0]);
            } else if (this.mConfig.getSingleFilter() != null) {
                new FileFilterTask(this.mConfig, false).execute(new Void[0]);
            } else {
                File[] volumeList = this.fileUtil.listFilesInDir(theSelectedPath);
                this.setAdapterList(volumeList);
                this.refreshList();
                this.setBundlePathOnUpdate();
            }
        } else {
            File[] volumeList = this.fileUtil.listFilesAsDir(theSelectedPath);
            this.setAdapterList(volumeList);
            this.refreshList();
            this.setBundlePathOnUpdate();
        }
        this.playTheAddressBarAnimation();
    }

    public void setBundlePathOnUpdate() {
        if (this.mConfig.isResumeSession() && StorageChooser.LAST_SESSION_PATH != null) {
            this.mBundlePath = StorageChooser.LAST_SESSION_PATH.startsWith(Environment.getExternalStorageDirectory().getAbsolutePath()) ? Environment.getExternalStorageDirectory().getAbsolutePath() : StorageChooser.LAST_SESSION_PATH.substring(StorageChooser.LAST_SESSION_PATH.indexOf("/", 16), StorageChooser.LAST_SESSION_PATH.length());
        }
    }

    public void refreshList() {
        if (this.secondaryChooserAdapter != null) {
            this.secondaryChooserAdapter.notifyDataSetChanged();
        }
    }

    public void setAdapterList(File[] volumeList) {
        if (volumeList != null) {
            for (File f : volumeList) {
                if (this.mConfig.isShowHidden()) {
                    this.customStoragesList.add(f.getName());
                    continue;
                }
                if (f.getName().startsWith(".")) continue;
                this.customStoragesList.add(f.getName());
            }
            Collections.sort(this.customStoragesList, new Comparator<String>(){

                @Override
                public int compare(String s1, String s2) {
                    return s1.compareToIgnoreCase(s2);
                }
            });
        } else {
            this.customStoragesList.clear();
        }
    }

    private void trimPopulate(String s) {
        if (this.customStoragesList == null) {
            this.customStoragesList = new ArrayList<String>();
        } else {
            this.customStoragesList.clear();
        }
        File[] volumeList = this.isFilePicker ? this.fileUtil.listFilesInDir(theSelectedPath) : this.fileUtil.listFilesAsDir(theSelectedPath);
        Log.e((String)"SCLib", (String)theSelectedPath);
        if (volumeList != null) {
            for (File f : volumeList) {
                if (f.getName().startsWith(".")) continue;
                this.customStoragesList.add(f.getName());
            }
            Collections.sort(this.customStoragesList, new Comparator<String>(){

                @Override
                public int compare(String s1, String s2) {
                    return s1.compareToIgnoreCase(s2);
                }
            });
        } else {
            this.customStoragesList.clear();
        }
        if (this.secondaryChooserAdapter != null) {
            this.secondaryChooserAdapter.setPrefixPath(s);
            this.secondaryChooserAdapter.notifyDataSetChanged();
        }
    }

    private void playTheAddressBarAnimation() {
        this.mPathChosen.setText((CharSequence)mAddressClippedPath);
        Animation animation = AnimationUtils.loadAnimation((Context)this.mContext, (int)R.anim.anim_address_bar);
        this.mPathChosen.startAnimation(animation);
    }

    private void playTheMultipleButtonAnimation() {
        Animation animation = AnimationUtils.loadAnimation((Context)this.mContext, (int)R.anim.anim_multiple_button);
        this.mMultipleOnSelectButton.setVisibility(0);
        this.mMultipleOnSelectButton.startAnimation(animation);
    }

    private void playTheMultipleButtonEndAnimation() {
        Animation animation = AnimationUtils.loadAnimation((Context)this.mContext, (int)R.anim.anim_multiple_button_end);
        this.mMultipleOnSelectButton.startAnimation(animation);
        this.mMultipleOnSelectButton.setVisibility(4);
    }

    @NonNull
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        Dialog d = StorageChooser.dialog;
        if (this.getActivity() != null) {
            d.setContentView(this.getLayout(LayoutInflater.from((Context)this.getActivity().getApplicationContext()), this.mContainer));
        }
        WindowManager.LayoutParams lp = new WindowManager.LayoutParams();
        lp.copyFrom(d.getWindow().getAttributes());
        lp.width = -1;
        lp.height = -1;
        d.getWindow().setAttributes(lp);
        return d;
    }

    public void onDismiss(DialogInterface dialog) {
        super.onDismiss(dialog);
        theSelectedPath = "";
        mAddressClippedPath = "";
    }

    public void onCancel(DialogInterface dialog) {
        super.onCancel(dialog);
        StorageChooser.LAST_SESSION_PATH = theSelectedPath;
        theSelectedPath = "";
        mAddressClippedPath = "";
        StorageChooser.onCancelListener.onCancel();
    }

    private int getSlashCount(String path) {
        int count = 0;
        for (char s : path.toCharArray()) {
            if (s != '/') continue;
            ++count;
        }
        return count;
    }

    private boolean validateFolderName() {
        if (this.mFolderNameEditText.getText().toString().trim().isEmpty()) {
            this.mFolderNameEditText.setError((CharSequence)this.mContent.getTextfieldErrorText());
            return false;
        }
        return true;
    }

    @SuppressLint(value={"StaticFieldLeak"})
    class FileFilterTask
    extends AsyncTask<Void, String, Boolean> {
        private Config mConfig;
        private boolean isMultiple;
        private File[] fileList;

        FileFilterTask(Config mConfig, boolean isMultiple) {
            this.mConfig = mConfig;
            this.isMultiple = isMultiple;
        }

        protected void onPreExecute() {
            super.onPreExecute();
            SecondaryChooserFragment.this.mFilesProgress.setVisibility(0);
        }

        protected Boolean doInBackground(Void ... voids) {
            if (this.isMultiple) {
                UniversalFileFilter universalFileFilter = new UniversalFileFilter(this.mConfig.isCustomFilter(), this.mConfig.getCustomEnum());
                this.fileList = new File(theSelectedPath).listFiles(universalFileFilter);
            } else {
                this.fileList = new File(theSelectedPath).listFiles(new UniversalFileFilter(this.mConfig.getSingleFilter()));
            }
            return true;
        }

        protected void onPostExecute(Boolean aBoolean) {
            super.onPostExecute((Object)aBoolean);
            SecondaryChooserFragment.this.mFilesProgress.setVisibility(4);
            SecondaryChooserFragment.this.setAdapterList(this.fileList);
            SecondaryChooserFragment.this.refreshList();
            SecondaryChooserFragment.this.setBundlePathOnUpdate();
        }
    }
}

