/*
 * Decompiled with CFR 0.152.
 */
package com.codekidlabs.storagechooser.fragments;

import android.app.Dialog;
import android.app.DialogFragment;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.AssetManager;
import android.graphics.Typeface;
import android.os.Bundle;
import android.os.Environment;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.AdapterView;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import android.widget.Toast;
import com.codekidlabs.storagechooser.Content;
import com.codekidlabs.storagechooser.R;
import com.codekidlabs.storagechooser.StorageChooser;
import com.codekidlabs.storagechooser.adapters.StorageChooserListAdapter;
import com.codekidlabs.storagechooser.models.Config;
import com.codekidlabs.storagechooser.models.Storages;
import com.codekidlabs.storagechooser.utils.DiskUtil;
import com.codekidlabs.storagechooser.utils.FileUtil;
import com.codekidlabs.storagechooser.utils.MemoryUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class ChooserDialogFragment
extends DialogFragment {
    private static final boolean BUILD_DEBUG = true;
    private View mLayout;
    private ViewGroup mContainer;
    private List<Storages> storagesList;
    private List<String> customStoragesList;
    private String TAG = "StorageChooser";
    private MemoryUtil memoryUtil = new MemoryUtil();
    private FileUtil fileUtil = new FileUtil();
    private Config mConfig;
    private Content mContent;
    private int mChooserMode;
    private Handler mHandler;

    @Nullable
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        this.mContainer = container;
        if (this.getShowsDialog()) {
            return super.onCreateView(inflater, container, savedInstanceState);
        }
        return this.getLayout(inflater, container);
    }

    private View getLayout(LayoutInflater inflater, ViewGroup container) {
        this.mConfig = StorageChooser.sConfig;
        this.mHandler = new Handler();
        this.mContent = this.mConfig.getContent() == null ? new Content() : this.mConfig.getContent();
        this.mLayout = inflater.inflate(R.layout.storage_list, container, false);
        this.initListView(this.getActivity().getApplicationContext(), this.mLayout, this.mConfig.isShowMemoryBar());
        if (this.mContent.getOverviewHeading() != null) {
            TextView dialogTitle = (TextView)this.mLayout.findViewById(R.id.dialog_title);
            dialogTitle.setTextColor(this.mConfig.getScheme()[1]);
            dialogTitle.setText((CharSequence)this.mContent.getOverviewHeading());
            if (this.mConfig.getHeadingFont() != null) {
                dialogTitle.setTypeface(ChooserDialogFragment.getSCTypeface(this.getActivity().getApplicationContext(), this.mConfig.getHeadingFont(), this.mConfig.isHeadingFromAssets()));
            }
        }
        this.mLayout.findViewById(R.id.header_container).setBackgroundColor(this.mConfig.getScheme()[0]);
        this.mLayout.findViewById(R.id.overview_container).setBackgroundColor(this.mConfig.getScheme()[2]);
        return this.mLayout;
    }

    private void initListView(Context context, View view, boolean shouldShowMemoryBar) {
        ListView listView = (ListView)view.findViewById(R.id.storage_list_view);
        this.populateList();
        listView.setAdapter((ListAdapter)new StorageChooserListAdapter(this.storagesList, context, shouldShowMemoryBar, this.mConfig.isHideFreeSpaceLabel(), this.mConfig.getScheme(), this.mConfig.getMemorybarHeight(), this.mConfig.getListFont(), this.mConfig.isListFromAssets(), this.mContent));
        listView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> adapterView, View view, int i, long l) {
                final String dirPath = ChooserDialogFragment.this.evaluatePath(i);
                if (new File(dirPath).canRead()) {
                    if (ChooserDialogFragment.this.mConfig.isAllowCustomPath()) {
                        if (ChooserDialogFragment.this.mConfig.isApplyThreshold()) {
                            ChooserDialogFragment.this.startThresholdTest(i);
                        } else {
                            ChooserDialogFragment.this.mHandler.postDelayed(new Runnable(){

                                @Override
                                public void run() {
                                    DiskUtil.showSecondaryChooser(dirPath, ChooserDialogFragment.this.mConfig);
                                }
                            }, 250L);
                        }
                    } else if (ChooserDialogFragment.this.mConfig.isActionSave()) {
                        String preDef = ChooserDialogFragment.this.mConfig.getPredefinedPath();
                        String preDirPath = null;
                        if (preDef != null) {
                            if (!preDef.startsWith("/")) {
                                preDef = "/" + preDef;
                            }
                            preDirPath = dirPath + preDef;
                            DiskUtil.saveChooserPathPreference(ChooserDialogFragment.this.mConfig.getPreference(), preDirPath);
                        } else {
                            Log.w((String)ChooserDialogFragment.this.TAG, (String)"Predefined path is null set it by .withPredefinedPath() to builder. Saving root directory");
                            DiskUtil.saveChooserPathPreference(ChooserDialogFragment.this.mConfig.getPreference(), preDirPath);
                        }
                    } else if (ChooserDialogFragment.this.mConfig.isApplyThreshold()) {
                        ChooserDialogFragment.this.startThresholdTest(i);
                    } else if (StorageChooser.onSelectListener != null) {
                        StorageChooser.onSelectListener.onSelect(dirPath);
                    }
                    ChooserDialogFragment.this.dismiss();
                } else {
                    Toast.makeText((Context)ChooserDialogFragment.this.getActivity(), (int)R.string.toast_not_readable, (int)0).show();
                }
            }
        });
    }

    private void startThresholdTest(int position) {
        String thresholdSuffix = this.mConfig.getThresholdSuffix();
        if (thresholdSuffix != null) {
            long availableMem = this.memoryUtil.getAvailableMemorySize(this.evaluatePath(position));
            if (this.doesPassThresholdTest(this.mConfig.getMemoryThreshold(), thresholdSuffix, availableMem)) {
                String dirPath = this.evaluatePath(position);
                DiskUtil.showSecondaryChooser(dirPath, this.mConfig);
            } else {
                String suffixedAvailableMem = String.valueOf(this.memoryUtil.suffixedSize(availableMem, thresholdSuffix)) + " " + thresholdSuffix;
                Toast.makeText((Context)this.getActivity().getApplicationContext(), (CharSequence)this.getString(R.string.toast_threshold_breached, new Object[]{suffixedAvailableMem}), (int)0).show();
            }
        } else {
            Log.e((String)this.TAG, (String)"add .withThreshold(int size, String suffix) to your StorageChooser.Builder instance");
        }
    }

    private String evaluatePath(int i) {
        if (i == 0) {
            return Environment.getExternalStorageDirectory().getAbsolutePath();
        }
        return "/storage/" + this.storagesList.get(i).getStorageTitle();
    }

    private boolean doesPassThresholdTest(long threshold, String memorySuffix, long availableSpace) {
        return this.memoryUtil.suffixedSize(availableSpace, memorySuffix) > threshold;
    }

    private void populateList() {
        this.storagesList = new ArrayList<Storages>();
        File storageDir = new File("/storage");
        String internalStoragePath = Environment.getExternalStorageDirectory().getAbsolutePath();
        File[] volumeList = storageDir.listFiles();
        Storages storages = new Storages();
        storages.setStorageTitle(this.mContent.getInternalStorageText());
        storages.setStoragePath(internalStoragePath);
        storages.setMemoryTotalSize(this.memoryUtil.formatSize(this.memoryUtil.getTotalMemorySize(internalStoragePath)));
        storages.setMemoryAvailableSize(this.memoryUtil.formatSize(this.memoryUtil.getAvailableMemorySize(internalStoragePath)));
        this.storagesList.add(storages);
        for (File f : volumeList) {
            if (f.getName().equals("self") || f.getName().equals("knox-emulated") || f.getName().equals("emulated") || f.getName().equals("sdcard0") || f.getName().equals("container")) continue;
            Storages sharedStorage = new Storages();
            String fPath = f.getAbsolutePath();
            sharedStorage.setStorageTitle(f.getName());
            sharedStorage.setMemoryTotalSize(this.memoryUtil.formatSize(this.memoryUtil.getTotalMemorySize(fPath)));
            sharedStorage.setMemoryAvailableSize(this.memoryUtil.formatSize(this.memoryUtil.getAvailableMemorySize(fPath)));
            sharedStorage.setStoragePath(fPath);
            this.storagesList.add(sharedStorage);
        }
    }

    public static Typeface getSCTypeface(Context context, String path, boolean assets) {
        if (assets) {
            return Typeface.createFromAsset((AssetManager)context.getAssets(), (String)path);
        }
        return Typeface.createFromFile((String)path);
    }

    public void onCancel(DialogInterface dialog) {
        super.onCancel(dialog);
        StorageChooser.onCancelListener.onCancel();
    }

    @NonNull
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        Dialog d = StorageChooser.dialog;
        d.setContentView(this.getLayout(LayoutInflater.from((Context)this.getActivity().getApplicationContext()), this.mContainer));
        WindowManager.LayoutParams lp = new WindowManager.LayoutParams();
        lp.copyFrom(d.getWindow().getAttributes());
        lp.width = -2;
        lp.height = -2;
        d.getWindow().setAttributes(lp);
        return d;
    }
}

