/*
 * Decompiled with CFR 0.152.
 */
package com.codekidlabs.storagechooser.adapters;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.support.v4.graphics.drawable.DrawableCompat;
import android.text.SpannableStringBuilder;
import android.text.style.StyleSpan;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.Animation;
import android.view.animation.Interpolator;
import android.widget.BaseAdapter;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.codekidlabs.storagechooser.R;
import com.codekidlabs.storagechooser.animators.MemorybarAnimation;
import com.codekidlabs.storagechooser.exceptions.MemoryNotAccessibleException;
import com.codekidlabs.storagechooser.models.Storages;
import com.codekidlabs.storagechooser.utils.MemoryUtil;
import java.util.List;

public class StorageChooserListAdapter
extends BaseAdapter {
    private List<Storages> storagesList;
    private Context mContext;
    private boolean shouldShowMemoryBar;
    private ProgressBar memoryBar;
    private static int memoryPercentile;
    private int[] scheme;

    public StorageChooserListAdapter(List<Storages> storagesList, Context mContext, boolean shouldShowMemoryBar, int[] scheme) {
        this.storagesList = storagesList;
        this.mContext = mContext;
        this.shouldShowMemoryBar = shouldShowMemoryBar;
        this.scheme = scheme;
    }

    public int getCount() {
        return this.storagesList.size();
    }

    public Object getItem(int i) {
        return this.storagesList.get(i);
    }

    public long getItemId(int i) {
        return i;
    }

    public View getView(int i, View view, ViewGroup viewGroup) {
        memoryPercentile = -1;
        LayoutInflater inflater = (LayoutInflater)this.mContext.getSystemService("layout_inflater");
        View rootView = inflater.inflate(R.layout.row_storage, viewGroup, false);
        TextView storageName = (TextView)rootView.findViewById(R.id.storage_name);
        TextView memoryStatus = (TextView)rootView.findViewById(R.id.memory_status);
        this.memoryBar = (ProgressBar)rootView.findViewById(R.id.memory_bar);
        this.memoryBar.setScaleY(2.0f);
        Storages storages = this.storagesList.get(i);
        SpannableStringBuilder str = new SpannableStringBuilder((CharSequence)(storages.getStorageTitle() + " (" + storages.getMemoryTotalSize() + ")"));
        str.setSpan((Object)new StyleSpan(2), this.getSpannableIndex(str), str.length(), 33);
        String availableText = this.mContext.getString(R.string.text_freespace, new Object[]{storages.getMemoryAvailableSize()});
        storageName.setText((CharSequence)str);
        storageName.setTextColor(this.scheme[3]);
        memoryStatus.setText((CharSequence)availableText);
        memoryStatus.setTextColor(this.scheme[4]);
        DrawableCompat.setTint((Drawable)this.memoryBar.getProgressDrawable(), (int)this.scheme[5]);
        try {
            memoryPercentile = this.getPercentile(storages.getStoragePath());
        }
        catch (MemoryNotAccessibleException e) {
            e.printStackTrace();
        }
        if (this.shouldShowMemoryBar && memoryPercentile != -1) {
            this.memoryBar.setMax(100);
            this.memoryBar.setProgress(memoryPercentile);
            this.runMemorybarAnimation(i);
        } else {
            this.memoryBar.setVisibility(8);
        }
        return rootView;
    }

    private void runMemorybarAnimation(int pos) {
        MemorybarAnimation animation = new MemorybarAnimation(this.memoryBar, 0, memoryPercentile);
        animation.setDuration(500L);
        animation.setInterpolator((Interpolator)new AccelerateDecelerateInterpolator());
        if (pos > 0) {
            animation.setStartOffset(300L);
        }
        this.memoryBar.startAnimation((Animation)animation);
    }

    private int getSpannableIndex(SpannableStringBuilder str) {
        return str.toString().indexOf("(") + 1;
    }

    private int getPercentile(String path) throws MemoryNotAccessibleException {
        MemoryUtil memoryUtil = new MemoryUtil();
        long availableMem = memoryUtil.getAvailableMemorySize(path);
        long totalMem = memoryUtil.getTotalMemorySize(path);
        if (totalMem <= 0L) {
            throw new MemoryNotAccessibleException("Cannot compute memory for " + path);
        }
        int percent = (int)(100L - availableMem * 100L / totalMem);
        return percent;
    }

    private long getMemoryFromString(String size) {
        long mem = size.contains("MiB") ? (long)Integer.parseInt(size.replace(",", "").replace("MiB", "")) : (size.contains("GiB") ? (long)Integer.parseInt(size.replace(",", "").replace("GiB", "")) : (long)Integer.parseInt(size.replace(",", "").replace("KiB", "")));
        Log.d((String)"TAG", (String)("Memory:" + mem));
        return mem;
    }
}

