/*
 * Decompiled with CFR 0.152.
 */
package com.codekidlabs.storagechooser;

import android.app.Activity;
import android.app.Dialog;
import android.app.FragmentManager;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.Environment;
import com.codekidlabs.storagechooser.Content;
import com.codekidlabs.storagechooser.R;
import com.codekidlabs.storagechooser.fragments.ChooserDialogFragment;
import com.codekidlabs.storagechooser.models.Config;
import com.codekidlabs.storagechooser.utils.DiskUtil;
import java.util.ArrayList;

public class StorageChooser {
    public static Dialog dialog;
    public static Config sConfig;
    private Activity chooserActivity;
    public static OnSelectListener onSelectListener;
    public static final String NONE = "none";
    public static final String DIRECTORY_CHOOSER = "dir";
    public static final String FILE_PICKER = "file";

    StorageChooser(Activity activity, Config config) {
        StorageChooser.setsConfig(config);
        this.setChooserActivity(activity);
    }

    public StorageChooser() {
    }

    public void show() {
        this.init();
    }

    private void init() {
        dialog = StorageChooser.getStorageChooserDialog(this.getChooserActivity());
        if (sConfig.isSkipOverview()) {
            if (sConfig.getPrimaryPath() == null) {
                String dirPath = Environment.getExternalStorageDirectory().getAbsolutePath();
                DiskUtil.showSecondaryChooser(dirPath, sConfig);
            } else {
                DiskUtil.showSecondaryChooser(sConfig.getPrimaryPath(), sConfig);
            }
        } else {
            ChooserDialogFragment chooserDialogFragment = new ChooserDialogFragment();
            chooserDialogFragment.show(sConfig.getFragmentManager(), "storagechooser_dialog");
        }
    }

    public void setOnSelectListener(OnSelectListener onSelectListener) {
        StorageChooser.onSelectListener = onSelectListener;
    }

    public OnSelectListener getOnSelectListener() {
        return onSelectListener;
    }

    public static Config getsConfig() {
        return sConfig;
    }

    public static void setsConfig(Config sConfig) {
        StorageChooser.sConfig = sConfig;
    }

    private Activity getChooserActivity() {
        return this.chooserActivity;
    }

    private void setChooserActivity(Activity chooserActivity) {
        this.chooserActivity = chooserActivity;
    }

    private static Dialog getStorageChooserDialog(Activity activity) {
        return new Dialog((Context)activity, R.style.DialogTheme);
    }

    public static enum FileType {
        MP3,
        MP4,
        TXT,
        TTF;

    }

    public static class Builder {
        private Activity mActivity;
        private boolean mActionSave = false;
        private boolean mShowMemoryBar = false;
        private boolean mAllowCustomPath = false;
        private boolean mAllowAddFolder = false;
        private boolean mShowHidden = false;
        private boolean mSkipOverview = false;
        private boolean mApplyMemoryThreshold = false;
        private String type;
        private Content content;
        private FileType filter;
        private ArrayList<FileType> multipleFilter;
        Config devConfig = new Config();

        public Builder withActivity(Activity activity) {
            this.mActivity = activity;
            return this;
        }

        public Builder withFragmentManager(FragmentManager fragmentManager) {
            this.devConfig.setFragmentManager(fragmentManager);
            return this;
        }

        public Builder withMemoryBar(boolean memoryBarBoolean) {
            this.mShowMemoryBar = memoryBarBoolean;
            return this;
        }

        public Builder withPredefinedPath(String path) {
            this.devConfig.setPredefinedPath(path);
            return this;
        }

        public Builder applyMemoryThreshold(boolean applyThreshold) {
            this.mApplyMemoryThreshold = applyThreshold;
            return this;
        }

        public Builder withThreshold(int size, String suffix) {
            this.devConfig.setMemoryThreshold(size);
            this.devConfig.setThresholdSuffix(suffix);
            return this;
        }

        public Builder withPreference(SharedPreferences sharedPreferences) {
            this.devConfig.setPreference(sharedPreferences);
            return this;
        }

        public Builder actionSave(boolean save) {
            this.mActionSave = save;
            return this;
        }

        public Builder setDialogTitle(String title) {
            this.devConfig.setDialogTitle(title);
            return this;
        }

        public Builder setInternalStorageText(String storageNameText) {
            this.devConfig.setInternalStorageText(storageNameText);
            return this;
        }

        public Builder allowCustomPath(boolean allowCustomPath) {
            this.mAllowCustomPath = allowCustomPath;
            return this;
        }

        public Builder allowAddFolder(boolean addFolder) {
            this.mAllowAddFolder = addFolder;
            return this;
        }

        public Builder showHidden(boolean showHiddenFolders) {
            this.mShowHidden = showHiddenFolders;
            return this;
        }

        public Builder setType(String action) {
            this.type = action;
            return this;
        }

        public Builder skipOverview(boolean skip, String primaryPath) {
            this.mSkipOverview = skip;
            this.devConfig.setPrimaryPath(primaryPath);
            return this;
        }

        public Builder skipOverview(boolean skip) {
            this.mSkipOverview = skip;
            return this;
        }

        public Builder withContent(Content content) {
            this.content = content;
            return this;
        }

        public Builder withSingleFilter(FileType filter) {
            this.filter = filter;
            return this;
        }

        public Builder withMultipleFilter(ArrayList<FileType> multipleFilter) {
            this.multipleFilter = multipleFilter;
            return this;
        }

        public StorageChooser build() {
            this.devConfig.setActionSave(this.mActionSave);
            this.devConfig.setShowMemoryBar(this.mShowMemoryBar);
            this.devConfig.setAllowCustomPath(this.mAllowCustomPath);
            this.devConfig.setAllowAddFolder(this.mAllowAddFolder);
            this.devConfig.setShowHidden(this.mShowHidden);
            this.devConfig.setSkipOverview(this.mSkipOverview);
            this.devConfig.setApplyThreshold(this.mApplyMemoryThreshold);
            this.devConfig.setContent(this.content);
            this.devConfig.setSingleFilter(this.filter);
            this.devConfig.setMultipleFilter(this.multipleFilter);
            if (this.type == null) {
                this.devConfig.setSecondaryAction(StorageChooser.NONE);
            } else {
                this.devConfig.setSecondaryAction(this.type);
            }
            return new StorageChooser(this.mActivity, this.devConfig);
        }
    }

    public static interface OnSelectListener {
        public void onSelect(String var1);
    }
}

