/*
 * Decompiled with CFR 0.152.
 */
package com.codekidlabs.storagechooser.fragments;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.drawable.Animatable;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.design.widget.TextInputLayout;
import android.support.v4.app.DialogFragment;
import android.support.v4.content.ContextCompat;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.view.inputmethod.InputMethodManager;
import android.widget.AdapterView;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;
import com.codekidlabs.storagechooser.R;
import com.codekidlabs.storagechooser.StorageChooser;
import com.codekidlabs.storagechooser.StorageChooserView;
import com.codekidlabs.storagechooser.adapters.FilePickerAdapter;
import com.codekidlabs.storagechooser.adapters.StorageChooserCustomListAdapter;
import com.codekidlabs.storagechooser.fragments.ChooserDialogFragment;
import com.codekidlabs.storagechooser.models.Config;
import com.codekidlabs.storagechooser.utils.DiskUtil;
import com.codekidlabs.storagechooser.utils.FileUtil;
import com.codekidlabs.storagechooser.utils.ResourceUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class FilePickerFragment
extends DialogFragment {
    private View mLayout;
    private View mInactiveGradient;
    private ViewGroup mContainer;
    private TextView mPathChosen;
    private ImageButton mBackButton;
    private Button mSelectButton;
    private Button mCreateButton;
    private ImageView mNewFolderImageView;
    private Button mNewFolderButton;
    private EditText mFolderNameEditText;
    private TextInputLayout mFolderNameETLayout;
    private RelativeLayout mNewFolderView;
    private String mBundlePath;
    private ListView listView;
    private static final String INTERNAL_STORAGE_TITLE = "Internal Storage";
    private static final String EXTERNAL_STORAGE_TITLE = "ExtSD";
    private static final int FLAG_DISSMISS_NORMAL = 0;
    private static final int FLAG_DISSMISS_INIT_DIALOG = 1;
    private boolean isOpen;
    private static String theSelectedPath = "";
    private static String mAddressClippedPath = "";
    private List<String> customStoragesList;
    private FilePickerAdapter filePickerAdapter;
    private FileUtil fileUtil;
    private Config mConfig;
    private Context mContext;
    private ResourceUtil mResourceUtil;
    private View.OnClickListener mSelectButtonClickListener = new View.OnClickListener(){

        public void onClick(View view) {
            if (FilePickerFragment.this.mConfig.isActionSave()) {
                DiskUtil.saveChooserPathPreference(FilePickerFragment.this.mConfig.getPreference(), theSelectedPath);
            } else {
                Log.d((String)"StorageChooser", (String)("Chosen path: " + theSelectedPath));
            }
            StorageChooser.onSelectListener.onSelect(theSelectedPath);
            FilePickerFragment.this.dissmissDialog(0);
        }
    };
    private View.OnClickListener mBackButtonClickListener = new View.OnClickListener(){

        public void onClick(View view) {
            FilePickerFragment.this.performBackAction();
        }
    };
    private View.OnClickListener mNewFolderButtonClickListener = new View.OnClickListener(){

        public void onClick(View view) {
            FilePickerFragment.this.showAddFolderView();
        }
    };
    private View.OnClickListener mNewFolderButtonCloseListener = new View.OnClickListener(){

        public void onClick(View view) {
            FilePickerFragment.this.hideAddFolderView();
            FilePickerFragment.this.hideKeyboard();
        }
    };
    private View.OnClickListener mCreateButtonClickListener = new View.OnClickListener(){

        public void onClick(View view) {
            if (FilePickerFragment.this.validateFolderName()) {
                boolean success = FileUtil.createDirectory(FilePickerFragment.this.mFolderNameEditText.getText().toString().trim(), theSelectedPath);
                if (success) {
                    Toast.makeText((Context)FilePickerFragment.this.mContext, (CharSequence)StorageChooserView.TOAST_FOLDER_CREATED, (int)0).show();
                    FilePickerFragment.this.trimPopulate(theSelectedPath);
                    FilePickerFragment.this.hideKeyboard();
                    FilePickerFragment.this.hideAddFolderView();
                } else {
                    Toast.makeText((Context)FilePickerFragment.this.mContext, (CharSequence)StorageChooserView.TOAST_FOLDER_ERROR, (int)0).show();
                }
            }
        }
    };
    private boolean keyboardToggle;
    private String TAG = "StorageChooser";

    private void showAddFolderView() {
        this.mNewFolderView.setVisibility(0);
        Animation anim2 = AnimationUtils.loadAnimation((Context)this.mContext, (int)R.anim.anim_new_folder_view);
        this.mNewFolderView.startAnimation(anim2);
        this.mInactiveGradient.startAnimation(anim2);
        if (this.isSleekView()) {
            if (DiskUtil.isLollipopAndAbove()) {
                this.mNewFolderImageView.setImageDrawable(ContextCompat.getDrawable((Context)this.mContext, (int)R.drawable.drawable_plus_to_close));
                Animatable animatable = (Animatable)this.mNewFolderImageView.getDrawable();
                animatable.start();
            }
            this.mNewFolderImageView.setOnClickListener(this.mNewFolderButtonCloseListener);
        } else {
            this.mNewFolderButton.setOnClickListener(this.mNewFolderButtonCloseListener);
            this.mNewFolderButton.setText((CharSequence)StorageChooserView.LABEL_CANCEL);
            this.mNewFolderButton.setTextColor(this.mResourceUtil.getColor(R.color.cancel_color));
        }
        StorageChooserCustomListAdapter.shouldEnable = false;
    }

    private void hideAddFolderView() {
        Animation anim2 = AnimationUtils.loadAnimation((Context)this.mContext, (int)R.anim.anim_close_folder_view);
        this.mNewFolderView.startAnimation(anim2);
        this.mNewFolderView.setVisibility(4);
        if (this.isSleekView()) {
            if (DiskUtil.isLollipopAndAbove()) {
                this.mNewFolderImageView.setImageDrawable(ContextCompat.getDrawable((Context)this.mContext, (int)R.drawable.drawable_close_to_plus));
                Animatable animatable = (Animatable)this.mNewFolderImageView.getDrawable();
                animatable.start();
            }
            this.mNewFolderImageView.setOnClickListener(this.mNewFolderButtonClickListener);
        } else {
            this.mNewFolderButton.setOnClickListener(this.mNewFolderButtonClickListener);
            this.mNewFolderButton.setText((CharSequence)StorageChooserView.LABEL_NEW_FOLDER);
            this.mNewFolderButton.setTextColor(this.mResourceUtil.getColor(R.color.new_folder_color));
        }
        StorageChooserCustomListAdapter.shouldEnable = true;
        this.mInactiveGradient.startAnimation(anim2);
        this.mInactiveGradient.setVisibility(4);
    }

    private boolean isFolderViewVisible() {
        return this.mNewFolderView.getVisibility() == 0;
    }

    public void hideKeyboard() {
        InputMethodManager imm = (InputMethodManager)this.getActivity().getSystemService("input_method");
        imm.hideSoftInputFromWindow(this.mFolderNameEditText.getWindowToken(), 0);
    }

    private void performBackAction() {
        int slashIndex = theSelectedPath.lastIndexOf("/");
        if (theSelectedPath.equals(this.mBundlePath)) {
            this.dissmissDialog(1);
        } else {
            theSelectedPath = theSelectedPath.substring(0, slashIndex);
            Log.e((String)"SCLib", (String)("Performing back action: " + theSelectedPath));
            this.populateList("");
        }
    }

    private void dissmissDialog(int flag) {
        theSelectedPath = "";
        mAddressClippedPath = "";
        switch (flag) {
            case 1: {
                ChooserDialogFragment c = new ChooserDialogFragment();
                c.show(this.mConfig.getFragmentManager(), "storagechooser_dialog");
                this.dismiss();
                break;
            }
            case 0: {
                this.dismiss();
            }
        }
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        this.mContainer = container;
        if (this.getShowsDialog()) {
            return super.onCreateView(inflater, container, savedInstanceState);
        }
        return this.getLayout(inflater, container);
    }

    private View getLayout(LayoutInflater inflater, ViewGroup container) {
        this.mConfig = StorageChooser.sConfig;
        this.mContext = this.getContext();
        this.mResourceUtil = new ResourceUtil(this.mContext);
        this.mLayout = inflater.inflate(StorageChooserView.VIEW_SC, container, false);
        this.initListView(this.mContext, this.mLayout, this.mConfig.isShowMemoryBar());
        this.initUI();
        this.initNewFolderView();
        this.updateUI();
        return this.mLayout;
    }

    private boolean isSleekView() {
        return StorageChooserView.VIEW_SC == StorageChooserView.SC_LAYOUT_SLEEK;
    }

    private void initUI() {
        this.mBackButton = (ImageButton)this.mLayout.findViewById(R.id.back_button);
        this.mSelectButton = (Button)this.mLayout.findViewById(R.id.select_button);
        this.mCreateButton = (Button)this.mLayout.findViewById(R.id.create_folder_button);
        this.mNewFolderView = (RelativeLayout)this.mLayout.findViewById(R.id.new_folder_view);
        this.mFolderNameEditText = (EditText)this.mLayout.findViewById(R.id.et_folder_name);
        this.mFolderNameETLayout = (TextInputLayout)this.mLayout.findViewById(R.id.et_folder_name_layout);
        this.mInactiveGradient = this.mLayout.findViewById(R.id.inactive_gradient);
    }

    private void updateUI() {
        this.mNewFolderView.setVisibility(4);
        this.mInactiveGradient.setVisibility(4);
        this.mFolderNameETLayout.setHint((CharSequence)StorageChooserView.TEXTFIELD_HINT);
        if (Build.VERSION.SDK_INT >= 21) {
            this.mFolderNameEditText.setHintTextColor(this.mResourceUtil.getColor(StorageChooserView.SC_TEXTFIELD_HINT_COLOR));
        }
        this.mSelectButton.setText((CharSequence)StorageChooserView.LABEL_SELECT);
        this.mCreateButton.setText((CharSequence)StorageChooserView.LABEL_CREATE);
        this.mSelectButton.setTextColor(this.mResourceUtil.getColor(R.color.select_color));
        this.mBackButton.setOnClickListener(this.mBackButtonClickListener);
        this.mSelectButton.setOnClickListener(this.mSelectButtonClickListener);
        this.mCreateButton.setOnClickListener(this.mCreateButtonClickListener);
        if (this.mConfig.getSecondaryAction() == "file") {
            this.mSelectButton.setVisibility(8);
        }
    }

    private void initNewFolderView() {
        RelativeLayout mNewFolderButtonHolder = (RelativeLayout)this.mLayout.findViewById(R.id.new_folder_button_holder);
        if (this.isSleekView()) {
            this.mNewFolderImageView = (ImageView)this.mLayout.findViewById(R.id.new_folder_iv);
            this.mNewFolderImageView.setOnClickListener(this.mNewFolderButtonClickListener);
        } else {
            this.mNewFolderButton = (Button)this.mLayout.findViewById(R.id.new_folder_button);
            this.mNewFolderButton.setText((CharSequence)StorageChooserView.LABEL_NEW_FOLDER);
            this.mNewFolderButton.setOnClickListener(this.mNewFolderButtonClickListener);
            this.mNewFolderButton.setTextColor(this.mResourceUtil.getColor(R.color.new_folder_color));
        }
        if (!this.mConfig.isAllowAddFolder()) {
            mNewFolderButtonHolder.setVisibility(8);
        }
    }

    private void initListView(Context context, View view, boolean shouldShowMemoryBar) {
        this.listView = (ListView)view.findViewById(R.id.storage_list_view);
        this.mPathChosen = (TextView)view.findViewById(R.id.path_chosen);
        this.mBundlePath = this.getArguments().getString("storage_chooser_path");
        this.populateList(this.mBundlePath);
        this.filePickerAdapter = new FilePickerAdapter(this.customStoragesList, context, shouldShowMemoryBar, this.mBundlePath);
        this.listView.setAdapter((ListAdapter)this.filePickerAdapter);
        StorageChooserCustomListAdapter.shouldEnable = true;
        this.listView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> adapterView, View view, int i, long l) {
                String jointPath = theSelectedPath + "/" + (String)FilePickerFragment.this.customStoragesList.get(i);
                if (FileUtil.isDir(jointPath)) {
                    FilePickerFragment.this.populateList("/" + (String)FilePickerFragment.this.customStoragesList.get(i));
                } else {
                    StorageChooser.onSelectListener.onSelect(jointPath);
                    FilePickerFragment.this.dissmissDialog(0);
                }
            }
        });
    }

    private void evaluateAction(int i) {
        String preDefPath = this.mConfig.getPredefinedPath();
        boolean isCustom = this.mConfig.isAllowCustomPath();
        if (preDefPath == null) {
            Log.w((String)this.TAG, (String)"No predefined path set");
        } else if (isCustom) {
            this.populateList("/" + this.customStoragesList.get(i));
        }
    }

    private boolean doesPassMemoryThreshold(long threshold, String memorySuffix, long availableSpace) {
        return true;
    }

    private void populateList(String path) {
        if (this.customStoragesList == null) {
            this.customStoragesList = new ArrayList<String>();
        } else {
            this.customStoragesList.clear();
        }
        this.fileUtil = new FileUtil();
        theSelectedPath = theSelectedPath + path;
        int pathLength = theSelectedPath.length();
        if (pathLength >= 25) {
            int slashCount = this.getSlashCount(theSelectedPath);
            if (slashCount > 2) {
                mAddressClippedPath = theSelectedPath.substring(theSelectedPath.indexOf("/", theSelectedPath.indexOf("/") + 2), pathLength);
            } else if (slashCount <= 2) {
                mAddressClippedPath = theSelectedPath.substring(theSelectedPath.indexOf("/", theSelectedPath.indexOf("/") + 2), pathLength);
            }
        } else {
            mAddressClippedPath = theSelectedPath;
        }
        File[] volumeList = this.fileUtil.listFilesInDir(theSelectedPath);
        Log.e((String)"SCLib", (String)theSelectedPath);
        if (volumeList != null) {
            for (File f : volumeList) {
                if (this.mConfig.isShowHidden()) {
                    this.customStoragesList.add(f.getName());
                    continue;
                }
                if (f.getName().startsWith(".")) continue;
                this.customStoragesList.add(f.getName());
            }
            Collections.sort(this.customStoragesList, new Comparator<String>(){

                @Override
                public int compare(String s1, String s2) {
                    return s1.compareToIgnoreCase(s2);
                }
            });
        } else {
            this.customStoragesList.clear();
        }
        if (this.filePickerAdapter != null) {
            this.filePickerAdapter.notifyDataSetChanged();
        }
        this.playTheAddressBarAnimation();
    }

    private void trimPopulate(String s) {
        if (this.customStoragesList == null) {
            this.customStoragesList = new ArrayList<String>();
        } else {
            this.customStoragesList.clear();
        }
        File[] volumeList = this.fileUtil.listFilesInDir(theSelectedPath);
        Log.e((String)"SCLib", (String)theSelectedPath);
        if (volumeList != null) {
            for (File f : volumeList) {
                if (f.getName().startsWith(".")) continue;
                this.customStoragesList.add(f.getName());
            }
            Collections.sort(this.customStoragesList, new Comparator<String>(){

                @Override
                public int compare(String s1, String s2) {
                    return s1.compareToIgnoreCase(s2);
                }
            });
        } else {
            this.customStoragesList.clear();
        }
        if (this.filePickerAdapter != null) {
            this.filePickerAdapter.notifyDataSetChanged();
        }
    }

    private void playTheAddressBarAnimation() {
        this.mPathChosen.setText((CharSequence)mAddressClippedPath);
        Animation animation = AnimationUtils.loadAnimation((Context)this.mContext, (int)R.anim.anim_address_bar);
        this.mPathChosen.startAnimation(animation);
    }

    @NonNull
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        Dialog d = StorageChooser.dialog;
        d.setContentView(this.getLayout(LayoutInflater.from((Context)this.getContext()), this.mContainer));
        WindowManager.LayoutParams lp = new WindowManager.LayoutParams();
        lp.copyFrom(d.getWindow().getAttributes());
        lp.width = -1;
        lp.height = -1;
        d.getWindow().setAttributes(lp);
        return d;
    }

    public void onCancel(DialogInterface dialog) {
        super.onCancel(dialog);
        theSelectedPath = "";
        mAddressClippedPath = "";
    }

    private int getSlashCount(String path) {
        int count = 0;
        for (char s : path.toCharArray()) {
            if (s != '/') continue;
            ++count;
        }
        return count;
    }

    private boolean validateFolderName() {
        if (this.mFolderNameEditText.getText().toString().trim().isEmpty()) {
            this.mFolderNameEditText.setError((CharSequence)StorageChooserView.TEXTFIELD_ERROR);
            return false;
        }
        this.mFolderNameETLayout.setErrorEnabled(false);
        return true;
    }
}

