/*
 * Decompiled with CFR 0.152.
 */
package com.example.dynamikseekbar;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import com.example.dynamikseekbar.CreateFieldsAndBords;
import com.example.dynamikseekbar.DrawFields;
import com.example.dynamikseekbar.R;

public class DrawFieldsAndBords
extends DrawFields {
    private boolean dVisibleBordBackground;
    private boolean dVisibleBordButtons;
    private boolean dVisibleBordMark;
    private float dWidthBord;
    private int dColorBordBackground;
    private int dColorBordMark;

    public DrawFieldsAndBords(CreateFieldsAndBords fields) {
        super(fields);
        this.dWidthBord = this.dFields.getBord();
        this.dColorBordBackground = 0;
        this.dColorBordMark = 0;
    }

    @Override
    public void drawMark(Canvas canvas, long location) {
        if (this.dVisibleBordBackground) {
            this.dPaintSeek.setStyle(Paint.Style.FILL);
            this.dPaintSeek.setColor(this.dColorMark);
            if (this.dRoundMark.equals("circle")) {
                canvas.drawRoundRect(this.correctInBord(this.dFields.mark(location)), this.dFields.getRound(), this.dFields.getRound(), this.dPaintSeek);
            } else if (this.dRoundMark.equals("rect")) {
                canvas.drawRect(this.correctInBord(this.dFields.mark(location)), this.dPaintSeek);
            }
        } else {
            super.drawMark(canvas, location);
        }
    }

    @Override
    public void drawButtons(Canvas canvas) {
        if (this.dVisibleBordBackground) {
            if (!this.dFields.isVisibleButtons()) {
                return;
            }
            this.dPaintSeek.setStyle(Paint.Style.FILL);
            this.dPaintSeek.setColor(this.dColorMark);
            if (this.dRoundMark.equals("circle")) {
                canvas.drawRoundRect(this.correctInBord(this.dFields.getButton1()), this.dFields.getRound(), this.dFields.getRound(), this.dPaintSeek);
                canvas.drawRoundRect(this.correctInBord(this.dFields.getButton2()), this.dFields.getRound(), this.dFields.getRound(), this.dPaintSeek);
            } else if (this.dRoundMark.equals("rect")) {
                canvas.drawRect(this.correctInBord(this.dFields.getButton1()), this.dPaintSeek);
                canvas.drawRect(this.correctInBord(this.dFields.getButton2()), this.dPaintSeek);
            }
        } else {
            super.drawButtons(canvas);
        }
    }

    public void initDefColors(Context c) {
        this.dColorBordBackground = c.getResources().getColor(R.color.colorBackground);
        this.dColorMark = c.getResources().getColor(R.color.colorWay);
        this.dColorProgress = c.getResources().getColor(R.color.colorMark);
        this.dColorWay = c.getResources().getColor(R.color.colorWay);
        this.dColorBordMark = c.getResources().getColor(R.color.colorMark);
    }

    public void width(float width) {
        this.dWidthBord = width;
    }

    public void setVisibleBordBackground(boolean dVisibleBordBackground) {
        this.dVisibleBordBackground = dVisibleBordBackground;
    }

    public void setVisibleBordButtons(boolean dVisibleBordButtons) {
        this.dVisibleBordButtons = dVisibleBordButtons;
    }

    public void setVisibleBordMark(boolean dVisibleBordMark) {
        this.dVisibleBordMark = dVisibleBordMark;
    }

    public void setColorBordBackground(int dColorBordBackground) {
        this.dColorBordBackground = dColorBordBackground;
    }

    public void setColorBordMark(int dColorBordMark) {
        this.dColorBordMark = dColorBordMark;
    }

    public void bordMark(Canvas canvas) {
        if (this.dVisibleBordMark && this.dColorBordMark != 0 && this.dWidthBord > 0.0f) {
            this.dPaintSeek.setColor(this.dColorBordMark);
            this.dPaintSeek.setStyle(Paint.Style.STROKE);
            this.dPaintSeek.setStrokeWidth(this.dWidthBord);
            this.drawRect(canvas, this.correctInBord(this.fields().getMark()));
        }
    }

    public void bordButtons(Canvas canvas) {
        if (this.fields().isVisibleButtons() && this.dVisibleBordButtons && this.dColorBordMark != 0 && this.dWidthBord > 0.0f) {
            this.dPaintSeek.setColor(this.dColorBordMark);
            this.dPaintSeek.setStyle(Paint.Style.STROKE);
            this.dPaintSeek.setStrokeWidth(this.dWidthBord);
            this.drawRect(canvas, this.correctInBord(this.fields().getButton1()));
            this.drawRect(canvas, this.correctInBord(this.fields().getButton2()));
        }
    }

    public void bordBackground(Canvas canvas) {
        if (this.dVisibleBordBackground && this.dColorBordBackground != 0 && this.dWidthBord > 0.0f) {
            this.dPaintSeek.setColor(this.dColorBordBackground);
            this.dPaintSeek.setStyle(Paint.Style.STROKE);
            this.dPaintSeek.setStrokeWidth(this.dWidthBord);
            this.drawRect(canvas, this.fields().getBackground());
        }
    }

    private RectF correctInBord(RectF r) {
        if (this.dVisibleBordBackground) {
            return new RectF(r.left + this.dWidthBord, r.top + this.dWidthBord, r.right - this.dWidthBord, r.bottom - this.dWidthBord);
        }
        return r;
    }

    private void drawRect(Canvas canvas, RectF r) {
        if (this.round().equals("rect")) {
            canvas.drawRect(this.shiftRect(r), this.dPaintSeek);
        } else {
            canvas.drawRoundRect(this.shiftRect(r), this.shiftRound(), this.shiftRound(), this.dPaintSeek);
        }
    }

    private float shiftRound() {
        return this.fields().getRound() - this.correct();
    }

    private RectF shiftRect(RectF r) {
        return new RectF(r.left + this.correct(), r.top + this.correct(), r.right - this.correct(), r.bottom - this.correct());
    }

    private float correct() {
        return this.dWidthBord / 2.0f;
    }
}

