/*
 * Decompiled with CFR 0.152.
 */
package com.example.dynamikseekbar;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import androidx.annotation.NonNull;
import com.example.dynamikseekbar.CreateFields;
import com.example.dynamikseekbar.CreateFieldsAndBords;

public class DrawFields {
    protected Paint dPaintSeek = new Paint(1);
    private Path dClipWay = new Path();
    private RectF dWayProgress = new RectF();
    protected String dRoundMark = "circle";
    protected CreateFieldsAndBords dFields;
    private boolean dVisibleBackground;
    protected int dColorMark = -256;
    protected int dColorBackground = -3355444;
    protected int dColorWay = -16711936;
    protected int dColorProgress = -256;

    public DrawFields(@NonNull CreateFieldsAndBords fields) {
        this.dFields = fields;
    }

    public DrawFields visibilityBackground(boolean visible) {
        this.dVisibleBackground = visible;
        return this;
    }

    public DrawFields rounded(String round) {
        this.dRoundMark = round;
        return this;
    }

    public void setColorMark(int dColorMark) {
        this.dColorMark = dColorMark;
    }

    public void setColorBackground(int dColorBackground) {
        this.dColorBackground = dColorBackground;
    }

    public void setColorWay(int dColorWay) {
        this.dColorWay = dColorWay;
    }

    public void setColorProgress(int dColorProgress) {
        this.dColorProgress = dColorProgress;
    }

    public int getColorMark() {
        return this.dColorMark;
    }

    public int getColorBackground() {
        return this.dColorBackground;
    }

    public int getColorWay() {
        return this.dColorWay;
    }

    public int getColorProgress() {
        return this.dColorProgress;
    }

    public boolean isVisibleBackground() {
        return this.dVisibleBackground;
    }

    public void drawMark(Canvas canvas, long location) {
        this.dPaintSeek.setStyle(Paint.Style.FILL);
        this.dPaintSeek.setColor(this.dColorMark);
        if (this.dRoundMark.equals("circle")) {
            canvas.drawRoundRect(this.dFields.mark(location), this.dFields.getRound(), this.dFields.getRound(), this.dPaintSeek);
        } else if (this.dRoundMark.equals("rect")) {
            canvas.drawRect(this.dFields.mark(location), this.dPaintSeek);
        }
    }

    public void drawWay(Canvas canvas) {
        this.dPaintSeek.setStyle(Paint.Style.FILL);
        this.dPaintSeek.setColor(this.dColorWay);
        if (this.dRoundMark.equals("circle")) {
            canvas.drawRoundRect(this.correctRect(this.dFields.getWay()), this.dFields.getRadiusWay(), this.dFields.getRadiusWay(), this.dPaintSeek);
        } else if (this.dRoundMark.equals("rect")) {
            canvas.drawRect(this.correctRect(this.dFields.getWay()), this.dPaintSeek);
        }
    }

    public void drawProgress(Canvas canvas, float location) {
        this.dPaintSeek.setStyle(Paint.Style.FILL);
        this.dPaintSeek.setColor(this.dColorProgress);
        canvas.save();
        canvas.clipPath(this.clipWay());
        if (this.dRoundMark.equals("circle")) {
            canvas.drawRoundRect(this.correctRect(this.dFields.progress(location)), this.dFields.getRadiusWay(), this.dFields.getRadiusWay(), this.dPaintSeek);
        } else if (this.dRoundMark.equals("rect")) {
            canvas.drawRect(this.correctRect(this.dFields.progress(location)), this.dPaintSeek);
        }
        canvas.restore();
    }

    public void drawError(Canvas canvas) {
        canvas.drawColor(-65536);
    }

    public void drawBackground(Canvas canvas) {
        if (this.dVisibleBackground) {
            this.dPaintSeek.setStyle(Paint.Style.FILL);
            this.dPaintSeek.setColor(this.dColorBackground);
        } else {
            this.dPaintSeek.setColor(0);
        }
        this.drawRect(canvas, this.dFields.getBackground());
    }

    public void drawButtons(Canvas canvas) {
        if (!this.dFields.isVisibleButtons()) {
            return;
        }
        this.dPaintSeek.setStyle(Paint.Style.FILL);
        this.dPaintSeek.setColor(this.dColorMark);
        if (this.dRoundMark.equals("circle")) {
            canvas.drawRoundRect(this.dFields.getButton1(), this.dFields.getRound(), this.dFields.getRound(), this.dPaintSeek);
            canvas.drawRoundRect(this.dFields.getButton2(), this.dFields.getRound(), this.dFields.getRound(), this.dPaintSeek);
        } else if (this.dRoundMark.equals("rect")) {
            canvas.drawRect(this.dFields.getButton1(), this.dPaintSeek);
            canvas.drawRect(this.dFields.getButton2(), this.dPaintSeek);
        }
    }

    protected String round() {
        return this.dRoundMark;
    }

    protected CreateFields fields() {
        return this.dFields;
    }

    protected RectF correctRect(RectF r) {
        float radius = this.dFields.getRadiusWay() / 2.0f;
        if (this.dFields.getOrientation().equals("vertical")) {
            this.dWayProgress.set(r.left, r.top - radius, r.right, r.bottom + radius);
        } else {
            this.dWayProgress.set(r.left - radius, r.top, r.right + radius, r.bottom);
        }
        return this.dWayProgress;
    }

    private void drawRect(Canvas canvas, RectF rect) {
        if (this.dRoundMark.equals("circle")) {
            canvas.drawRoundRect(rect, this.dFields.getRound(), this.dFields.getRound(), this.dPaintSeek);
        } else {
            canvas.drawRect(rect, this.dPaintSeek);
        }
    }

    private Path clipWay() {
        this.dClipWay.reset();
        RectF r = this.correctRect(this.dFields.getWay());
        if (this.dFields.getOrientation().equals("vertical")) {
            if (this.dRoundMark.equals("circle")) {
                this.dClipWay.addRoundRect(r, r.height() / 2.0f, r.height() / 2.0f, Path.Direction.CCW);
            } else {
                this.dClipWay.addRect(r, Path.Direction.CCW);
            }
        } else if (this.dRoundMark.equals("circle")) {
            this.dClipWay.addRoundRect(r, r.width() / 2.0f, r.width() / 2.0f, Path.Direction.CCW);
        } else {
            this.dClipWay.addRect(r, Path.Direction.CCW);
        }
        return this.dClipWay;
    }
}

