/*
 * Decompiled with CFR 0.152.
 */
package com.example.dynamikseekbar;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.util.Log;
import com.example.dynamikseekbar.CreateFields;

public class DrawContent {
    private CreateFields dFields;
    private Drawable dButton1;
    private Drawable dButton2;
    private Drawable dMark;
    private boolean dVectorButton1;
    private boolean dVectorButton2;
    private boolean dVectorMark;
    private Paint dPaint;
    private String dGravity;
    private String dRounded;
    private float dTextSize;
    private int dColorContent;
    private boolean dVisibleText;
    private boolean dReversText;
    private Path dClip;
    private Path dText;

    public DrawContent(CreateFields fields) {
        this.dFields = fields;
        this.dColorContent = -1;
        this.dTextSize = 50.0f;
        this.dPaint = new Paint(1);
        this.dPaint.setTextAlign(Paint.Align.CENTER);
        this.dPaint.setColor(this.dColorContent);
        this.dPaint.setTextSize(this.dTextSize);
        this.dGravity = "bottom";
        this.dVisibleText = false;
        this.dClip = new Path();
        this.dText = new Path();
        this.dRounded = "circle";
        this.dRounded = "circle";
    }

    public DrawContent rounded(String round) {
        this.dRounded = round;
        return this;
    }

    public DrawContent textSize(float size) {
        this.dTextSize = size;
        this.dPaint.setTextSize(this.dTextSize);
        return this;
    }

    public DrawContent visibleText(boolean visible) {
        this.dVisibleText = visible;
        return this;
    }

    public DrawContent gravityText(String gravity) {
        this.dGravity = gravity;
        return this;
    }

    public DrawContent colorContent(int color) {
        this.dColorContent = color;
        this.dPaint.setColor(this.dColorContent);
        return this;
    }

    public DrawContent srcMark(Drawable d) {
        this.dMark = d;
        return this;
    }

    public DrawContent srcButtons(Drawable d1, Drawable d2) {
        this.dButton1 = d1;
        this.dButton2 = d2;
        return this;
    }

    public DrawContent srcButton1(Drawable d) {
        this.dButton1 = d;
        this.applyColor(this.dButton1);
        return this;
    }

    public DrawContent srcButton2(Drawable d) {
        this.dButton2 = d;
        this.applyColor(this.dButton2);
        return this;
    }

    public DrawContent reversText(boolean revers) {
        this.dReversText = revers;
        return this;
    }

    public void resetSrc() {
        this.dMark = null;
        this.dButton2 = null;
        this.dButton1 = null;
    }

    public void drawContentMark(int content, Canvas canvas) {
        this.drawDrawable(this.dMark, canvas, this.dFields.getMark());
        this.drawText(content, canvas, this.dFields.getMark());
    }

    public void drawContentButtons(int content, Canvas canvas) {
        if (this.dFields.isVisibleButtons()) {
            if (this.dReversText && this.dVisibleText) {
                this.drawText(content, canvas, this.dFields.getButton1());
                this.drawText(content, canvas, this.dFields.getButton2());
            } else {
                this.drawDrawable(this.dButton1, canvas, this.dFields.getButton1());
                this.drawDrawable(this.dButton2, canvas, this.dFields.getButton2());
            }
        }
    }

    public int getColorContent() {
        return this.dColorContent;
    }

    public String getGravity() {
        return this.dGravity;
    }

    public float getTextSize() {
        return this.dTextSize;
    }

    public boolean isVisibleText() {
        return this.dVisibleText;
    }

    public Drawable getMark() {
        return this.dMark;
    }

    public Drawable getButton1() {
        return this.dButton1;
    }

    public Drawable getButton2() {
        return this.dButton2;
    }

    private void applyColor(Drawable d) {
        if (d != null) {
            d.setTint(this.dColorContent);
        }
    }

    private void drawDrawable(Drawable d, Canvas canvas, RectF r) {
        if (d != null) {
            canvas.save();
            canvas.clipPath(this.clipField(r));
            d.setBounds(this.rect(r));
            d.draw(canvas);
            canvas.restore();
        }
    }

    private void drawText(int content, Canvas canvas, RectF r) {
        if (this.dVisibleText) {
            String text = Integer.toString(content);
            canvas.save();
            canvas.clipPath(this.clipField(r));
            canvas.restore();
            this.pathText(r);
            canvas.drawTextOnPath(text, this.dText, 0.0f, this.dTextSize / 3.0f, this.dPaint);
        }
    }

    private void pathText(RectF r) {
        this.dText.reset();
        if (this.dGravity.equals("bottom")) {
            this.dText.moveTo(r.left, r.centerY());
            this.dText.lineTo(r.right, r.centerY());
        } else if (this.dGravity.equals("top")) {
            this.dText.moveTo(r.right, r.centerY());
            this.dText.lineTo(r.left, r.centerY());
        } else if (this.dGravity.equals("left")) {
            this.dText.moveTo(r.centerX(), r.top);
            this.dText.lineTo(r.centerX(), r.bottom);
        } else if (this.dGravity.equals("right")) {
            this.dText.moveTo(r.centerX(), r.bottom);
            this.dText.lineTo(r.centerX(), r.top);
        } else {
            this.dText.moveTo(r.left, r.centerY());
            this.dText.lineTo(r.right, r.centerY());
        }
    }

    protected Path clipField(RectF r) {
        float radius;
        this.dClip.reset();
        float f = radius = r.width() < r.height() ? r.width() / 2.0f : r.height() / 2.0f;
        if (this.dRounded.equals("circle")) {
            this.dClip.addRoundRect(r, radius, radius, Path.Direction.CCW);
        } else {
            this.dClip.addRect(r, Path.Direction.CCW);
        }
        return this.dClip;
    }

    private Rect rect(RectF r) {
        return new Rect((int)r.left, (int)r.top, (int)r.right, (int)r.bottom);
    }

    private void MASSAGE(String t) {
        Log.e((String)"____________CONTENT", (String)t);
    }
}

