/*
 * Decompiled with CFR 0.152.
 */
package io.changock.runner.spring.util;

import io.changock.runner.core.DependencyContext;
import io.changock.runner.core.DependencyNotFound;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;

public class SpringDependencyContext
implements DependencyContext {
    private final ApplicationContext springContext;

    public SpringDependencyContext(ApplicationContext springContext) {
        this.springContext = springContext;
    }

    public <T> T getBean(Class<T> type) {
        try {
            return (T)this.springContext.getBean(type);
        }
        catch (BeansException ex) {
            throw new DependencyNotFound((Exception)((Object)ex));
        }
    }

    public Object getBean(String name) {
        try {
            return this.springContext.getBean(name);
        }
        catch (BeansException ex) {
            throw new DependencyNotFound((Exception)((Object)ex));
        }
    }
}

