/*
 * Decompiled with CFR 0.152.
 */
package org.json.simple;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.json.simple.Jsonable;
import org.json.simple.Jsoner;

public class JsonArray
extends ArrayList<Object>
implements Jsonable {
    private static final long serialVersionUID = 1L;

    public JsonArray() {
    }

    public JsonArray(Collection<?> collection) {
        super(collection);
    }

    public <T> void asCollection(Collection<T> destination) {
        for (Object o : this) {
            destination.add(o);
        }
    }

    public BigDecimal getBigDecimal(int index) {
        Object returnable = this.get(index);
        if (!(returnable instanceof BigDecimal)) {
            if (returnable instanceof Number) {
                returnable = new BigDecimal(returnable.toString());
            } else if (returnable instanceof String) {
                returnable = new BigDecimal((String)returnable);
            }
        }
        return (BigDecimal)returnable;
    }

    public boolean getBoolean(int index) {
        return (Boolean)this.get(index);
    }

    public byte getByte(int index) {
        return ((Number)this.get(index)).byteValue();
    }

    public double getDouble(int index) {
        return ((Number)this.get(index)).doubleValue();
    }

    public <T extends Enum<T>> T getEnum(int index) throws ClassNotFoundException {
        String element = this.getString(index);
        String[] splitValues = element.split("\\.");
        int numberOfValues = splitValues.length;
        StringBuilder returnTypeName = new StringBuilder();
        StringBuilder enumName = new StringBuilder();
        for (int i = 0; i < numberOfValues; ++i) {
            if (i == numberOfValues - 1) {
                enumName.append(splitValues[i]);
                continue;
            }
            if (i == numberOfValues - 2) {
                returnTypeName.append(splitValues[i]);
                continue;
            }
            returnTypeName.append(splitValues[i]);
            returnTypeName.append(".");
        }
        Class<?> returnType = Class.forName(returnTypeName.toString());
        Object returnable = Enum.valueOf(returnType, enumName.toString());
        return (T)returnable;
    }

    public float getFloat(int index) {
        return ((Number)this.get(index)).floatValue();
    }

    public int getInteger(int index) {
        return ((Number)this.get(index)).intValue();
    }

    public <T extends Collection<?>> T getCollection(int index) {
        return (T)((Collection)this.get(index));
    }

    public <T extends Map<?, ?>> T getMap(int index) {
        return (T)((Map)this.get(index));
    }

    public long getLong(int index) {
        return ((Number)this.get(index)).longValue();
    }

    public short getShort(int index) {
        return ((Number)this.get(index)).shortValue();
    }

    public String getString(int index) {
        return (String)this.get(index);
    }

    @Override
    public String toJson() {
        StringWriter writable = new StringWriter();
        try {
            this.toJson(writable);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return writable.toString();
    }

    @Override
    public void toJson(Writer writable) throws IOException {
        boolean isFirstElement = true;
        Iterator elements = this.iterator();
        writable.write(91);
        while (elements.hasNext()) {
            if (isFirstElement) {
                isFirstElement = false;
            } else {
                writable.write(44);
            }
            writable.write(Jsoner.serialize(elements.next()));
        }
        writable.write(93);
    }
}

