/*
 * Decompiled with CFR 0.152.
 */
package com.claudiodegio.msv;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Parcelable;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.util.Log;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import android.widget.TextView;
import com.claudiodegio.msv.AnimationUtil;
import com.claudiodegio.msv.OnSearchViewListener;
import com.claudiodegio.msv.R;

public abstract class BaseMaterialSearchView
extends FrameLayout
implements View.OnClickListener,
View.OnFocusChangeListener,
TextView.OnEditorActionListener,
TextWatcher {
    static final String TAG = "BMSV";
    protected EditText mETSearchText;
    protected ImageButton mBtBack;
    protected ImageButton mBtClear;
    protected ViewGroup mSearchTopBar;
    protected OnSearchViewListener mListener;
    private boolean mIsOpen = false;
    protected boolean mIgnoreNextTextChange = false;

    public BaseMaterialSearchView(Context context) {
        this(context, null);
    }

    public BaseMaterialSearchView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public BaseMaterialSearchView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView();
        this.initStyle(attrs, defStyleAttr);
    }

    private void initStyle(AttributeSet attrs, int defStyleAttr) {
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.Msv, defStyleAttr, 0);
        if (a != null) {
            if (a.hasValue(R.styleable.Msv_msvSearchBackgroud)) {
                this.setBackground(a.getDrawable(R.styleable.Msv_msvSearchBackgroud));
            }
            if (a.hasValue(R.styleable.Msv_msvHint)) {
                this.mETSearchText.setHint((CharSequence)a.getString(R.styleable.Msv_msvHint));
            }
            if (a.hasValue(R.styleable.Msv_msvTextColor)) {
                this.mETSearchText.setTextColor(a.getColor(R.styleable.Msv_msvTextColor, defStyleAttr));
            }
            if (a.hasValue(R.styleable.Msv_msvTextColorHint)) {
                this.mETSearchText.setHintTextColor(a.getColor(R.styleable.Msv_msvTextColorHint, defStyleAttr));
            }
            a.recycle();
        }
    }

    public void setMenuItem(MenuItem menuItem) {
        menuItem.setOnMenuItemClickListener(new MenuItem.OnMenuItemClickListener(){

            public boolean onMenuItemClick(MenuItem item) {
                BaseMaterialSearchView.this.showSearch(true);
                return true;
            }
        });
    }

    public void showSearch() {
        this.showSearch(false);
    }

    public void showSearch(boolean animate) {
        if (this.mIsOpen) {
            return;
        }
        if (animate) {
            this.setVisibleWithAnimation();
        } else {
            this.mIsOpen = true;
            this.setVisibility(0);
            if (this.mListener != null) {
                this.mListener.onSearchViewShown();
            }
            this.mETSearchText.requestFocus();
        }
    }

    public void closeSearch() {
        this.setVisibility(8);
        this.hideKeyboard((View)this.mETSearchText);
        this.mETSearchText.getEditableText().clear();
        this.mIsOpen = false;
        if (this.mListener != null) {
            this.mListener.onSearchViewClosed();
        }
    }

    public boolean isOpen() {
        return this.mIsOpen;
    }

    public void setQuery(String query, boolean submit) {
        this.mETSearchText.setText((CharSequence)query);
        if (submit) {
            this.handleSubmitQuery();
        }
    }

    private void setVisibleWithAnimation() {
        AnimationUtil.AnimationListener animationListener = new AnimationUtil.AnimationListener(){

            @Override
            public boolean onAnimationStart(View view) {
                return false;
            }

            @Override
            public boolean onAnimationEnd(View view) {
                BaseMaterialSearchView.this.mIsOpen = true;
                BaseMaterialSearchView.this.mETSearchText.requestFocus();
                if (BaseMaterialSearchView.this.mListener != null) {
                    BaseMaterialSearchView.this.mListener.onSearchViewShown();
                }
                return false;
            }

            @Override
            public boolean onAnimationCancel(View view) {
                return false;
            }
        };
        if (Build.VERSION.SDK_INT >= 21) {
            this.setVisibility(0);
            AnimationUtil.reveal((View)this, animationListener);
        } else {
            AnimationUtil.fadeInView((View)this, 1000, animationListener);
        }
    }

    private void initView() {
        Log.v((String)TAG, (String)"initView: ");
        LayoutInflater.from((Context)this.getContext()).inflate(this.getLayoutId(), (ViewGroup)this, true);
        this.mETSearchText = (EditText)this.findViewById(R.id.ed_search_text);
        this.mBtBack = (ImageButton)this.findViewById(R.id.bt_back);
        this.mBtClear = (ImageButton)this.findViewById(R.id.bt_clear);
        this.mSearchTopBar = (ViewGroup)this.findViewById(R.id.search_top_bar);
        this.setVisibility(8);
        this.mBtBack.setOnClickListener((View.OnClickListener)this);
        this.mBtClear.setOnClickListener((View.OnClickListener)this);
        this.mETSearchText.setOnClickListener((View.OnClickListener)this);
        this.mETSearchText.setOnFocusChangeListener((View.OnFocusChangeListener)this);
        this.mETSearchText.setOnEditorActionListener((TextView.OnEditorActionListener)this);
        this.mETSearchText.addTextChangedListener((TextWatcher)this);
    }

    protected abstract int getLayoutId();

    public void onClick(View view) {
        Log.d((String)TAG, (String)"onClick: ");
        if (view.getId() == R.id.bt_back) {
            this.closeSearch();
        } else if (view.getId() == R.id.bt_clear) {
            this.setQuery("", false);
        }
    }

    public void onFocusChange(View view, boolean b) {
    }

    public boolean onEditorAction(TextView textView, int actionId, KeyEvent keyEvent) {
        Log.d((String)TAG, (String)("onEditorAction: " + actionId));
        if (actionId == 3) {
            this.handleSubmitQuery();
            return true;
        }
        return false;
    }

    public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {
    }

    public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
        if (this.mIgnoreNextTextChange) {
            Log.d((String)TAG, (String)("onTextChanged: " + charSequence + " ignored"));
            return;
        }
        Log.d((String)TAG, (String)("onTextChanged: " + charSequence));
        if (this.mListener != null) {
            this.mListener.onQueryTextChange(charSequence.toString());
        }
        if (charSequence.length() > 0) {
            this.mBtClear.setVisibility(0);
        } else {
            this.mBtClear.setVisibility(4);
        }
    }

    public void afterTextChanged(Editable editable) {
    }

    private void handleSubmitQuery() {
        boolean submitHandled = false;
        if (this.mListener != null) {
            submitHandled = this.mListener.onQueryTextSubmit(this.mETSearchText.getText().toString());
        }
        if (!submitHandled) {
            this.closeSearch();
        } else {
            this.hideKeyboard((View)this.mETSearchText);
        }
    }

    public void hideKeyboard(View view) {
        InputMethodManager imm = (InputMethodManager)view.getContext().getSystemService("input_method");
        imm.hideSoftInputFromWindow(view.getWindowToken(), 0);
    }

    public void showKeyboard(View view) {
        if (Build.VERSION.SDK_INT <= 10 && view.hasFocus()) {
            view.clearFocus();
        }
        view.requestFocus();
        InputMethodManager imm = (InputMethodManager)view.getContext().getSystemService("input_method");
        imm.showSoftInput(view, 0);
    }

    public void setOnSearchViewListener(OnSearchViewListener mListener) {
        this.mListener = mListener;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        if (!(state instanceof BaseMSVSavedState)) {
            super.onRestoreInstanceState(state);
            return;
        }
        BaseMSVSavedState mSavedState = (BaseMSVSavedState)state;
        if (mSavedState.isOpen) {
            this.showSearch(false);
        }
        super.onRestoreInstanceState(mSavedState.getSuperState());
    }

    protected Parcelable onSaveInstanceState() {
        BaseMSVSavedState savedState = new BaseMSVSavedState(super.onSaveInstanceState());
        savedState.isOpen = this.mIsOpen;
        return savedState;
    }

    public void setBackground(Drawable background) {
        if (Build.VERSION.SDK_INT >= 16) {
            this.mSearchTopBar.setBackground(background);
        } else {
            this.mSearchTopBar.setBackgroundDrawable(background);
        }
    }

    class BaseMSVSavedState
    extends View.BaseSavedState {
        public boolean isOpen;

        public BaseMSVSavedState(Parcelable superState) {
            super(superState);
        }
    }
}

