/*
 * Decompiled with CFR 0.152.
 */
package com.chuckerteam.chucker.internal.support;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okio.Buffer;
import okio.Sink;
import okio.Source;
import okio.Timeout;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\fH\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\fH\u0002J\b\u0010\u0012\u001a\u00020\u0010H\u0016J\b\u0010\u0013\u001a\u00020\u0010H\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/chuckerteam/chucker/internal/support/TeeSource;", "Lokio/Source;", "upstream", "sideStream", "Lokio/Sink;", "<init>", "(Lokio/Source;Lokio/Sink;)V", "tempBuffer", "Lokio/Buffer;", "isFailure", "", "read", "", "sink", "byteCount", "copyBytesToSideStream", "", "bytesRead", "close", "safeCloseSideStream", "timeout", "Lokio/Timeout;", "com.github.ChuckerTeam.Chucker.library"})
public final class TeeSource
implements Source {
    @NotNull
    private final Source upstream;
    @NotNull
    private final Sink sideStream;
    @NotNull
    private final Buffer tempBuffer;
    private boolean isFailure;

    public TeeSource(@NotNull Source upstream, @NotNull Sink sideStream) {
        Intrinsics.checkNotNullParameter((Object)upstream, (String)"upstream");
        Intrinsics.checkNotNullParameter((Object)sideStream, (String)"sideStream");
        this.upstream = upstream;
        this.sideStream = sideStream;
        this.tempBuffer = new Buffer();
    }

    public long read(@NotNull Buffer sink, long byteCount) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        long bytesRead = this.upstream.read(sink, byteCount);
        if (bytesRead == -1L) {
            this.safeCloseSideStream();
            return -1L;
        }
        if (!this.isFailure) {
            this.copyBytesToSideStream(sink, bytesRead);
        }
        return bytesRead;
    }

    private final void copyBytesToSideStream(Buffer sink, long bytesRead) {
        long offset = sink.size() - bytesRead;
        sink.copyTo(this.tempBuffer, offset, bytesRead);
        try {
            this.sideStream.write(this.tempBuffer, bytesRead);
        }
        catch (IOException iOException) {
            this.isFailure = true;
            this.safeCloseSideStream();
        }
    }

    public void close() {
        this.safeCloseSideStream();
        this.upstream.close();
    }

    private final void safeCloseSideStream() {
        try {
            this.sideStream.close();
        }
        catch (IOException iOException) {
            this.isFailure = true;
        }
    }

    @NotNull
    public Timeout timeout() {
        return this.upstream.timeout();
    }
}

