/*
 * Decompiled with CFR 0.152.
 */
package com.chuckerteam.chucker.internal.support;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Shader;
import android.graphics.drawable.Drawable;
import androidx.annotation.ColorInt;
import androidx.annotation.ColorRes;
import androidx.annotation.DimenRes;
import androidx.annotation.Px;
import androidx.core.content.ContextCompat;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B%\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0003H\u0016J\b\u0010\u0010\u001a\u00020\u0003H\u0016J\u0012\u0010\u0011\u001a\u00020\u000b2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/chuckerteam/chucker/internal/support/ChessboardDrawable;", "Landroid/graphics/drawable/Drawable;", "evenColor", "", "oddColor", "squareSize", "<init>", "(III)V", "chessboardPaint", "Landroid/graphics/Paint;", "draw", "", "canvas", "Landroid/graphics/Canvas;", "setAlpha", "alpha", "getOpacity", "setColorFilter", "colorFilter", "Landroid/graphics/ColorFilter;", "Companion", "com.github.ChuckerTeam.Chucker.library"})
public final class ChessboardDrawable
extends Drawable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Paint chessboardPaint;

    /*
     * WARNING - void declaration
     */
    public ChessboardDrawable(@ColorInt int evenColor, @ColorInt int oddColor, @Px int squareSize) {
        void $this$chessboardPaint_u24lambda_u240;
        Paint paint;
        Paint paint2 = paint = new Paint();
        ChessboardDrawable chessboardDrawable = this;
        boolean bl = false;
        Bitmap bitmap = Bitmap.createBitmap((int)(squareSize * 2), (int)(squareSize * 2), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"createBitmap(...)");
        Bitmap patternBitmap = bitmap;
        patternBitmap.eraseColor(evenColor);
        $this$chessboardPaint_u24lambda_u240.setColor(oddColor);
        $this$chessboardPaint_u24lambda_u240.setStyle(Paint.Style.FILL);
        Canvas patternCanvas = new Canvas(patternBitmap);
        Rect squareRect = new Rect(squareSize, 0, 2 * squareSize, squareSize);
        patternCanvas.drawRect(squareRect, (Paint)$this$chessboardPaint_u24lambda_u240);
        squareRect.offsetTo(0, squareSize);
        patternCanvas.drawRect(squareRect, (Paint)$this$chessboardPaint_u24lambda_u240);
        $this$chessboardPaint_u24lambda_u240.reset();
        $this$chessboardPaint_u24lambda_u240.setShader((Shader)new BitmapShader(patternBitmap, Shader.TileMode.REPEAT, Shader.TileMode.REPEAT));
        chessboardDrawable.chessboardPaint = paint;
    }

    public void draw(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        canvas.drawPaint(this.chessboardPaint);
    }

    public void setAlpha(int alpha) {
        this.chessboardPaint.setAlpha(alpha);
    }

    public int getOpacity() {
        return this.chessboardPaint.getColorFilter() == null ? -1 : -3;
    }

    public void setColorFilter(@Nullable ColorFilter colorFilter) {
        this.chessboardPaint.setColorFilter(colorFilter);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0001\u0010\b\u001a\u00020\t2\b\b\u0001\u0010\n\u001a\u00020\t2\b\b\u0001\u0010\u000b\u001a\u00020\t\u00a8\u0006\f"}, d2={"Lcom/chuckerteam/chucker/internal/support/ChessboardDrawable$Companion;", "", "<init>", "()V", "createPattern", "Lcom/chuckerteam/chucker/internal/support/ChessboardDrawable;", "context", "Landroid/content/Context;", "evenColorId", "", "oddColorId", "sizeId", "com.github.ChuckerTeam.Chucker.library"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ChessboardDrawable createPattern(@NotNull Context context, @ColorRes int evenColorId, @ColorRes int oddColorId, @DimenRes int sizeId) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            int evenColor = ContextCompat.getColor((Context)context, (int)evenColorId);
            int oddColor = ContextCompat.getColor((Context)context, (int)oddColorId);
            int size = context.getResources().getDimensionPixelSize(sizeId);
            return new ChessboardDrawable(evenColor, oddColor, size);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

