/*
 * Decompiled with CFR 0.152.
 */
package com.chuckerteam.chucker.api.internal.ui.error;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.chuckerteam.chucker.R;
import com.chuckerteam.chucker.api.internal.data.entity.RecordedThrowableTuple;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.List;

public class ErrorAdapter
extends RecyclerView.Adapter<ErrorViewHolder> {
    @NonNull
    private final ErrorClickListListener listener;
    @NonNull
    private final Context context;
    @NonNull
    private List<RecordedThrowableTuple> recordedThrowables = new ArrayList<RecordedThrowableTuple>();

    ErrorAdapter(@NonNull Context context, @NonNull ErrorClickListListener listener) {
        this.context = context;
        this.listener = listener;
    }

    @NonNull
    public ErrorViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View view = LayoutInflater.from((Context)this.context).inflate(R.layout.chucker_list_item_error, parent, false);
        return new ErrorViewHolder(view);
    }

    public void onBindViewHolder(@NonNull ErrorViewHolder holder, int position) {
        RecordedThrowableTuple throwable = this.recordedThrowables.get(position);
        holder.bind(throwable);
    }

    public int getItemCount() {
        return this.recordedThrowables.size();
    }

    public void setData(List<RecordedThrowableTuple> recordedThrowables) {
        this.recordedThrowables = recordedThrowables;
        this.notifyDataSetChanged();
    }

    public static interface ErrorClickListListener {
        public void onErrorClick(long var1, int var3);
    }

    public class ErrorViewHolder
    extends RecyclerView.ViewHolder
    implements View.OnClickListener {
        private final TextView tag;
        private final TextView clazz;
        private final TextView message;
        private final TextView date;
        private RecordedThrowableTuple throwable;

        ErrorViewHolder(View itemView) {
            super(itemView);
            this.tag = (TextView)itemView.findViewById(R.id.tag);
            this.clazz = (TextView)itemView.findViewById(R.id.clazz);
            this.message = (TextView)itemView.findViewById(R.id.message);
            this.date = (TextView)itemView.findViewById(R.id.date);
            itemView.setOnClickListener((View.OnClickListener)this);
        }

        void bind(RecordedThrowableTuple throwable) {
            this.throwable = throwable;
            this.tag.setText((CharSequence)throwable.getTag());
            this.clazz.setText((CharSequence)throwable.getClazz());
            this.message.setText((CharSequence)throwable.getMessage());
            this.date.setText((CharSequence)DateFormat.getDateTimeInstance(3, 2).format(throwable.getDate()));
        }

        public void onClick(View v) {
            if (this.throwable != null) {
                ErrorAdapter.this.listener.onErrorClick(this.throwable.getId(), this.getAdapterPosition());
            }
        }
    }
}

