/*
 * Decompiled with CFR 0.152.
 */
package uk.co.senab.bitmapcache;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.drawable.BitmapDrawable;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import uk.co.senab.bitmapcache.BitmapLruCache;
import uk.co.senab.bitmapcache.Constants;
import uk.co.senab.bitmapcache.WeakReferenceRunnable;

public class CacheableBitmapDrawable
extends BitmapDrawable {
    public static final int SOURCE_UNKNOWN = -1;
    public static final int SOURCE_NEW = 0;
    public static final int SOURCE_INBITMAP = 1;
    static final String LOG_TAG = "CacheableBitmapDrawable";
    private final String mUrl;
    private BitmapLruCache.RecyclePolicy mRecyclePolicy;
    private int mDisplayingCount;
    private boolean mHasBeenDisplayed;
    private int mCacheCount;
    private Runnable mCheckStateRunnable;
    private Throwable mStackTraceWhenRecycled;
    private static final Handler sHandler = new Handler(Looper.getMainLooper());
    private final int mMemorySize;
    private final int mSource;

    CacheableBitmapDrawable(String url, Resources resources, Bitmap bitmap, BitmapLruCache.RecyclePolicy recyclePolicy, int source) {
        super(resources, bitmap);
        this.mMemorySize = null != bitmap ? bitmap.getRowBytes() * bitmap.getHeight() : 0;
        this.mUrl = url;
        this.mRecyclePolicy = recyclePolicy;
        this.mDisplayingCount = 0;
        this.mCacheCount = 0;
        this.mSource = source;
    }

    public void draw(Canvas canvas) {
        try {
            super.draw(canvas);
        }
        catch (RuntimeException re) {
            if (null != this.mStackTraceWhenRecycled) {
                this.mStackTraceWhenRecycled.printStackTrace();
            }
            throw re;
        }
    }

    int getMemorySize() {
        return this.mMemorySize;
    }

    public String getUrl() {
        return this.mUrl;
    }

    public int getSource() {
        return this.mSource;
    }

    public synchronized boolean isBitmapValid() {
        Bitmap bitmap = this.getBitmap();
        return null != bitmap && !bitmap.isRecycled();
    }

    public synchronized boolean isBitmapMutable() {
        Bitmap bitmap = this.getBitmap();
        return null != bitmap && bitmap.isMutable();
    }

    public synchronized boolean isBeingDisplayed() {
        return this.mDisplayingCount > 0;
    }

    public synchronized boolean isReferencedByCache() {
        return this.mCacheCount > 0;
    }

    public synchronized void setBeingUsed(boolean beingUsed) {
        if (beingUsed) {
            ++this.mDisplayingCount;
            this.mHasBeenDisplayed = true;
        } else {
            --this.mDisplayingCount;
        }
        this.checkState();
    }

    synchronized void setCached(boolean added) {
        this.mCacheCount = added ? ++this.mCacheCount : --this.mCacheCount;
        this.checkState();
    }

    private void cancelCheckStateCallback() {
        if (null != this.mCheckStateRunnable) {
            if (Constants.DEBUG) {
                Log.d((String)LOG_TAG, (String)("Cancelling checkState() callback for: " + this.mUrl));
            }
            sHandler.removeCallbacks(this.mCheckStateRunnable);
            this.mCheckStateRunnable = null;
        }
    }

    private void checkState() {
        this.checkState(false);
    }

    private synchronized void checkState(boolean ignoreBeenDisplayed) {
        if (Constants.DEBUG) {
            Log.d((String)LOG_TAG, (String)String.format("checkState(). Been Displayed: %b, Displaying: %d, Caching: %d, URL: %s", this.mHasBeenDisplayed, this.mDisplayingCount, this.mCacheCount, this.mUrl));
        }
        if (!this.mRecyclePolicy.canRecycle()) {
            return;
        }
        this.cancelCheckStateCallback();
        if (this.mCacheCount <= 0 && this.mDisplayingCount <= 0 && this.isBitmapValid()) {
            if (this.mHasBeenDisplayed || ignoreBeenDisplayed) {
                if (Constants.DEBUG) {
                    Log.d((String)LOG_TAG, (String)("Recycling bitmap with url: " + this.mUrl));
                }
                this.mStackTraceWhenRecycled = new Throwable("Recycled Bitmap Method Stack");
                this.getBitmap().recycle();
            } else {
                if (Constants.DEBUG) {
                    Log.d((String)LOG_TAG, (String)("Unused Bitmap which hasn't been displayed, delaying recycle(): " + this.mUrl));
                }
                this.mCheckStateRunnable = new CheckStateRunnable(this);
                sHandler.postDelayed(this.mCheckStateRunnable, 2000L);
            }
        }
    }

    private static final class CheckStateRunnable
    extends WeakReferenceRunnable<CacheableBitmapDrawable> {
        public CheckStateRunnable(CacheableBitmapDrawable object) {
            super(object);
        }

        @Override
        public void run(CacheableBitmapDrawable object) {
            object.checkState(true);
        }
    }
}

