/*
 * Decompiled with CFR 0.152.
 */
package uk.co.senab.bitmapcache;

import android.graphics.Bitmap;
import android.support.v4.util.LruCache;
import java.lang.ref.SoftReference;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import uk.co.senab.bitmapcache.BitmapLruCache;
import uk.co.senab.bitmapcache.CacheableBitmapDrawable;

final class BitmapMemoryLruCache
extends LruCache<String, CacheableBitmapDrawable> {
    private final Set<SoftReference<CacheableBitmapDrawable>> mRemovedEntries;
    private final BitmapLruCache.RecyclePolicy mRecyclePolicy;

    BitmapMemoryLruCache(int maxSize, BitmapLruCache.RecyclePolicy policy) {
        super(maxSize);
        this.mRecyclePolicy = policy;
        this.mRemovedEntries = policy.canInBitmap() ? Collections.synchronizedSet(new HashSet()) : null;
    }

    CacheableBitmapDrawable put(CacheableBitmapDrawable value) {
        if (null != value) {
            value.setCached(true);
            return (CacheableBitmapDrawable)((Object)this.put(value.getUrl(), (Object)value));
        }
        return null;
    }

    BitmapLruCache.RecyclePolicy getRecyclePolicy() {
        return this.mRecyclePolicy;
    }

    protected int sizeOf(String key, CacheableBitmapDrawable value) {
        return value.getMemorySize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void entryRemoved(boolean evicted, String key, CacheableBitmapDrawable oldValue, CacheableBitmapDrawable newValue) {
        oldValue.setCached(false);
        if (this.mRemovedEntries != null && oldValue.isBitmapValid() && oldValue.isBitmapMutable()) {
            Set<SoftReference<CacheableBitmapDrawable>> set = this.mRemovedEntries;
            synchronized (set) {
                this.mRemovedEntries.add(new SoftReference<CacheableBitmapDrawable>(oldValue));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Bitmap getBitmapFromRemoved(int width, int height) {
        if (this.mRemovedEntries == null) {
            return null;
        }
        Bitmap result = null;
        Set<SoftReference<CacheableBitmapDrawable>> set = this.mRemovedEntries;
        synchronized (set) {
            Iterator<SoftReference<CacheableBitmapDrawable>> it = this.mRemovedEntries.iterator();
            while (it.hasNext()) {
                CacheableBitmapDrawable value = it.next().get();
                if (value != null && value.isBitmapValid() && value.isBitmapMutable()) {
                    if (value.getIntrinsicWidth() != width || value.getIntrinsicHeight() != height) continue;
                    it.remove();
                    result = value.getBitmap();
                    break;
                }
                it.remove();
            }
        }
        return result;
    }

    void trimMemory() {
        Set values = this.snapshot().entrySet();
        for (Map.Entry entry : values) {
            CacheableBitmapDrawable value = (CacheableBitmapDrawable)((Object)entry.getValue());
            if (null != value && value.isBeingDisplayed()) continue;
            this.remove(entry.getKey());
        }
    }
}

