/*
 * Decompiled with CFR 0.152.
 */
package com.jiangdg.ausbc.utils;

import android.app.Activity;
import android.app.ActivityManager;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.location.Location;
import android.location.LocationManager;
import android.net.Uri;
import android.os.Build;
import android.os.PowerManager;
import android.provider.Settings;
import androidx.annotation.RawRes;
import androidx.core.content.ContextCompat;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bJ\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\n\u001a\u00020\u000bJ\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\n\u001a\u0004\u0018\u00010\u000bJ\u000e\u0010\u0014\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\u0015\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\u0016\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bJ\u001a\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0001\u0010\u0019\u001a\u00020\rJ\u0016\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\rJ\u0012\u0010\u001f\u001a\u00060 R\u00020!2\u0006\u0010\n\u001a\u00020\u000bJ\u0014\u0010\"\u001a\u00020\u001b2\f\u0010\u001f\u001a\b\u0018\u00010 R\u00020!R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006#"}, d2={"Lcom/jiangdg/ausbc/utils/Utils;", "", "()V", "debugCamera", "", "getDebugCamera", "()Z", "setDebugCamera", "(Z)V", "canDrawOverlays", "context", "Landroid/content/Context;", "dp2px", "", "dpValue", "", "getGLESVersion", "", "getGpsLocation", "Landroid/location/Location;", "getScreenHeight", "getScreenWidth", "isTargetSdkOverP", "loadBitmapFromRawResource", "Landroid/graphics/Bitmap;", "id", "requestOverlaysPermission", "", "activity", "Landroid/app/Activity;", "requestCode", "wakeLock", "Landroid/os/PowerManager$WakeLock;", "Landroid/os/PowerManager;", "wakeUnLock", "libausbc_release"})
public final class Utils {
    @NotNull
    public static final Utils INSTANCE = new Utils();
    private static boolean debugCamera = true;

    private Utils() {
    }

    public final boolean getDebugCamera() {
        return debugCamera;
    }

    public final void setDebugCamera(boolean bl) {
        debugCamera = bl;
    }

    public final boolean isTargetSdkOverP(@NotNull Context context) {
        int n;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        try {
            ApplicationInfo aInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(), 0);
            n = aInfo.targetSdkVersion;
        }
        catch (PackageManager.NameNotFoundException e) {
            return false;
        }
        int targetSdkVersion = n;
        return targetSdkVersion >= 28;
    }

    @Nullable
    public final Location getGpsLocation(@Nullable Context context) {
        Context context2 = context;
        if (context2 != null) {
            Context context3 = context2;
            boolean bl = false;
            boolean bl2 = false;
            Context ctx = context3;
            boolean bl3 = false;
            Object object = ctx.getSystemService("location");
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type android.location.LocationManager");
            }
            LocationManager locationManager = (LocationManager)object;
            int locPermission = ContextCompat.checkSelfPermission((Context)ctx, (String)"android.permission.ACCESS_FINE_LOCATION");
            if (locPermission == 0) {
                return locationManager.getLastKnownLocation("passive");
            }
        }
        return null;
    }

    public final int dp2px(@NotNull Context context, float dpValue) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(dpValue * scale + 0.5f);
    }

    @NotNull
    public final PowerManager.WakeLock wakeLock(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = context.getSystemService("power");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.os.PowerManager");
        }
        PowerManager pm = (PowerManager)object;
        PowerManager.WakeLock wakeLock = pm.newWakeLock(10, "jj:camera");
        Intrinsics.checkNotNullExpressionValue((Object)wakeLock, (String)"pm.newWakeLock(PowerManager.SCREEN_BRIGHT_WAKE_LOCK, \"jj:camera\")");
        PowerManager.WakeLock mWakeLock = wakeLock;
        mWakeLock.setReferenceCounted(false);
        mWakeLock.acquire(600000L);
        return mWakeLock;
    }

    public final void wakeUnLock(@Nullable PowerManager.WakeLock wakeLock) {
        PowerManager.WakeLock wakeLock2 = wakeLock;
        if (wakeLock2 != null) {
            wakeLock2.release();
        }
    }

    @Nullable
    public final String getGLESVersion(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = context.getSystemService("activity");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.app.ActivityManager");
        }
        object = (ActivityManager)object;
        boolean bl = false;
        boolean bl2 = false;
        Object $this$getGLESVersion_u24lambda_u2d1 = object;
        boolean bl3 = false;
        return $this$getGLESVersion_u24lambda_u2d1.getDeviceConfigurationInfo().getGlEsVersion();
    }

    public final int getScreenWidth(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return context.getResources().getDisplayMetrics().widthPixels;
    }

    public final int getScreenHeight(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return context.getResources().getDisplayMetrics().heightPixels;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final Bitmap loadBitmapFromRawResource(@NotNull Context context, @RawRes int id2) {
        Resources resources;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        InputStream inputStream = null;
        try {
            resources = context.getResources();
            inputStream = resources == null ? null : resources.openRawResource(id2);
            resources = BitmapFactory.decodeStream((InputStream)inputStream);
        }
        catch (Exception e) {
            e.printStackTrace();
            resources = null;
        }
        finally {
            try {
                InputStream e = inputStream;
                if (e != null) {
                    e.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return resources;
    }

    public final boolean canDrawOverlays(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return Build.VERSION.SDK_INT < 23 ? true : Settings.canDrawOverlays((Context)context);
    }

    public final void requestOverlaysPermission(@NotNull Activity activity, int requestCode) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        if (Build.VERSION.SDK_INT < 23) {
            return;
        }
        Uri uri = Uri.parse((String)Intrinsics.stringPlus((String)"package:", (Object)activity.getPackageName()));
        Intent intent = new Intent("android.settings.action.MANAGE_OVERLAY_PERMISSION", uri);
        activity.startActivityForResult(intent, requestCode);
    }
}

