/*
 * Decompiled with CFR 0.152.
 */
package com.jiangdg.ausbc.utils;

import android.app.ActivityManager;
import android.content.Context;
import android.opengl.GLES20;
import com.jiangdg.ausbc.utils.Logger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004J\u000e\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rH\u0002J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/jiangdg/ausbc/utils/OpenGLUtils;", "", "()V", "TAG", "", "checkGlError", "", "op", "glGenTextures", "textures", "", "glGetErrorStr", "err", "", "isGlEsSupported", "", "context", "Landroid/content/Context;", "libausbc_release"})
public final class OpenGLUtils {
    @NotNull
    public static final OpenGLUtils INSTANCE = new OpenGLUtils();
    @NotNull
    private static final String TAG = "OpenGLUtils";

    private OpenGLUtils() {
    }

    public final void glGenTextures(@NotNull int[] textures) {
        Intrinsics.checkNotNullParameter((Object)textures, (String)"textures");
        GLES20.glGenTextures((int)1, (int[])textures, (int)0);
        GLES20.glBindTexture((int)3553, (int)textures[0]);
        GLES20.glTexParameteri((int)3553, (int)10241, (int)9728);
        GLES20.glTexParameteri((int)3553, (int)10240, (int)9729);
        GLES20.glTexParameteri((int)3553, (int)10242, (int)33071);
        GLES20.glTexParameteri((int)3553, (int)10243, (int)33071);
        Logger.INSTANCE.i(TAG, Intrinsics.stringPlus((String)"create texture, id = ", (Object)textures[0]));
    }

    public final boolean isGlEsSupported(@NotNull Context context) {
        boolean bl;
        ActivityManager activityManager;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = context.getSystemService("activity");
        ActivityManager activityManager2 = activityManager = object instanceof ActivityManager ? (ActivityManager)object : null;
        if (activityManager == null) {
            bl = false;
        } else {
            boolean bl2;
            boolean bl3;
            ActivityManager activityManager3 = activityManager;
            boolean bl4 = false;
            boolean bl5 = false;
            ActivityManager it = activityManager3;
            boolean bl6 = false;
            try {
                String string = it.getDeviceConfigurationInfo().getGlEsVersion();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.deviceConfigurationInfo.glEsVersion");
                boolean bl7 = false;
                bl3 = Float.parseFloat(string) >= 2.0f;
            }
            catch (Exception e) {
                bl3 = false;
            }
            bl = bl2 = bl3;
        }
        return bl;
    }

    private final String glGetErrorStr(int err) {
        String string;
        int n = err;
        switch (n) {
            case 1283: {
                string = "stack overflow";
                break;
            }
            case 1284: {
                string = "stack underflow";
                break;
            }
            case 0: {
                string = "GL_NO_ERROR";
                break;
            }
            case 1280: {
                string = "GL_INVALID_ENUM";
                break;
            }
            case 1281: {
                string = "GL_INVALID_VALUE";
                break;
            }
            case 1282: {
                string = "GL_INVALID_OPERATION";
                break;
            }
            case 1285: {
                string = "GL_OUT_OF_MEMORY";
                break;
            }
            case 1286: {
                string = "GL_INVALID_FRAMEBUFFER_OPERATION";
                break;
            }
            default: {
                string = "unknown";
            }
        }
        return string;
    }

    public final void checkGlError(@NotNull String op) {
        Intrinsics.checkNotNullParameter((Object)op, (String)"op");
        int error = GLES20.glGetError();
        if (error != 0) {
            String msg = op + ": glError 0x" + Integer.toHexString(error) + ':' + this.glGetErrorStr(error);
            Logger.INSTANCE.e(TAG, msg);
        }
    }
}

