/*
 * Decompiled with CFR 0.152.
 */
package com.jiangdg.ausbc.encode.audio;

import android.media.AudioRecord;
import android.os.Process;
import com.jiangdg.ausbc.encode.audio.AudioStrategySystem;
import com.jiangdg.ausbc.encode.audio.IAudioStrategy;
import com.jiangdg.ausbc.encode.bean.RawData;
import com.jiangdg.ausbc.utils.Logger;
import com.jiangdg.ausbc.utils.Utils;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000b\u001a\u00020\u0006H\u0016J\b\u0010\f\u001a\u00020\u0006H\u0016J\b\u0010\r\u001a\u00020\u0006H\u0016J\b\u0010\u000e\u001a\u00020\u0006H\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\n\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0010H\u0016J\b\u0010\u0016\u001a\u00020\u0010H\u0016J\b\u0010\u0017\u001a\u00020\u0010H\u0016R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0005\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0019"}, d2={"Lcom/jiangdg/ausbc/encode/audio/AudioStrategySystem;", "Lcom/jiangdg/ausbc/encode/audio/IAudioStrategy;", "()V", "mAudioRecord", "Landroid/media/AudioRecord;", "mBufferSize", "", "getMBufferSize", "()I", "mBufferSize$delegate", "Lkotlin/Lazy;", "getAudioFormat", "getChannelConfig", "getChannelCount", "getSampleRate", "initAudioRecord", "", "isRecording", "", "read", "Lcom/jiangdg/ausbc/encode/bean/RawData;", "releaseAudioRecord", "startRecording", "stopRecording", "Companion", "libausbc_release"})
public final class AudioStrategySystem
implements IAudioStrategy {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy mBufferSize$delegate = LazyKt.lazy((Function0)mBufferSize.2.INSTANCE);
    @Nullable
    private AudioRecord mAudioRecord;
    @NotNull
    private static final String TAG = "AudioSystem";
    private static final int SAMPLE_RATE = 8000;
    private static final int CHANNEL_COUNT = 1;
    private static final int CHANNEL_IN_CONFIG = 16;
    private static final int AUDIO_FORMAT_16BIT = 2;
    private static final int AUDIO_RECORD_SOURCE = 1;

    private final int getMBufferSize() {
        Lazy lazy = this.mBufferSize$delegate;
        boolean bl = false;
        return ((Number)lazy.getValue()).intValue();
    }

    @Override
    public void initAudioRecord() {
        try {
            Process.setThreadPriority((int)-16);
            this.mAudioRecord = new AudioRecord(1, 8000, 16, 2, this.getMBufferSize());
            if (Utils.INSTANCE.getDebugCamera()) {
                Logger.INSTANCE.i(TAG, "initAudioRecord success");
            }
        }
        catch (Exception e) {
            Logger.INSTANCE.e(TAG, Intrinsics.stringPlus((String)"initAudioRecord failed, err = ", (Object)e.getLocalizedMessage()), e);
        }
    }

    @Override
    public void startRecording() {
        try {
            AudioRecord audioRecord = this.mAudioRecord;
            if (audioRecord != null) {
                audioRecord.startRecording();
            }
            if (Utils.INSTANCE.getDebugCamera()) {
                audioRecord = this.mAudioRecord;
                Logger.INSTANCE.i(TAG, Intrinsics.stringPlus((String)"startRecording success-->", audioRecord == null ? null : Integer.valueOf(audioRecord.getRecordingState())));
            }
        }
        catch (Exception e) {
            Logger.INSTANCE.e(TAG, Intrinsics.stringPlus((String)"startRecording failed, err = ", (Object)e.getLocalizedMessage()), e);
        }
    }

    @Override
    public void stopRecording() {
        try {
            AudioRecord audioRecord = this.mAudioRecord;
            if (audioRecord != null) {
                audioRecord.stop();
            }
            if (Utils.INSTANCE.getDebugCamera()) {
                Logger.INSTANCE.i(TAG, "stopRecording success");
            }
        }
        catch (Exception e) {
            Logger.INSTANCE.e(TAG, Intrinsics.stringPlus((String)"startRecording failed, err = ", (Object)e.getLocalizedMessage()), e);
        }
    }

    @Override
    public void releaseAudioRecord() {
        try {
            AudioRecord audioRecord = this.mAudioRecord;
            if (audioRecord != null) {
                audioRecord.release();
            }
            this.mAudioRecord = null;
            if (Utils.INSTANCE.getDebugCamera()) {
                Logger.INSTANCE.i(TAG, "releaseAudioRecord success.");
            }
        }
        catch (Exception e) {
            Logger.INSTANCE.e(TAG, Intrinsics.stringPlus((String)"releaseAudioRecord failed, err = ", (Object)e.getLocalizedMessage()), e);
        }
    }

    @Override
    @Nullable
    public RawData read() {
        RawData rawData;
        if (!this.isRecording()) {
            rawData = null;
        } else {
            int n;
            byte[] data = new byte[this.getMBufferSize()];
            AudioRecord audioRecord = this.mAudioRecord;
            int readBytes = audioRecord == null ? 0 : (n = audioRecord.read(data, 0, this.getMBufferSize()));
            rawData = new RawData(data, readBytes);
        }
        return rawData;
    }

    @Override
    public boolean isRecording() {
        AudioRecord audioRecord = this.mAudioRecord;
        return audioRecord == null ? false : audioRecord.getRecordingState() == 3;
    }

    @Override
    public int getSampleRate() {
        return 8000;
    }

    @Override
    public int getAudioFormat() {
        return 2;
    }

    @Override
    public int getChannelCount() {
        return 1;
    }

    @Override
    public int getChannelConfig() {
        return 16;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/jiangdg/ausbc/encode/audio/AudioStrategySystem$Companion;", "", "()V", "AUDIO_FORMAT_16BIT", "", "AUDIO_RECORD_SOURCE", "CHANNEL_COUNT", "CHANNEL_IN_CONFIG", "SAMPLE_RATE", "TAG", "", "libausbc_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

