/*
 * Decompiled with CFR 0.152.
 */
package com.jiangdg.ausbc.encode;

import android.media.MediaCodec;
import android.media.MediaFormat;
import android.view.Surface;
import com.jiangdg.ausbc.callback.IEncodeDataCallBack;
import com.jiangdg.ausbc.encode.AbstractProcessor;
import com.jiangdg.ausbc.utils.Logger;
import com.jiangdg.natives.YUVUtils;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 &2\u00020\u0001:\u0002&'B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0002J\u0006\u0010\u000f\u001a\u00020\u0003J\u0006\u0010\u0010\u001a\u00020\u0003J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0003H\u0014J\b\u0010\u0014\u001a\u00020\u0003H\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0014J\b\u0010\u0017\u001a\u00020\u0018H\u0014J\b\u0010\u0019\u001a\u00020\u0018H\u0014J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001bH\u0014J$\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020 0\u001e2\u0006\u0010!\u001a\u00020 2\u0006\u0010\"\u001a\u00020#H\u0014J\u000e\u0010$\u001a\u00020\u00182\u0006\u0010%\u001a\u00020\fR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\n\u00a8\u0006("}, d2={"Lcom/jiangdg/ausbc/encode/H264EncodeProcessor;", "Lcom/jiangdg/ausbc/encode/AbstractProcessor;", "width", "", "height", "gLESRender", "", "isPortrait", "(IIZZ)V", "getHeight", "()I", "mReadyListener", "Lcom/jiangdg/ausbc/encode/H264EncodeProcessor$OnEncodeReadyListener;", "getWidth", "getEncodeBitrate", "getEncodeHeight", "getEncodeWidth", "getPTSUs", "", "bufferSize", "getSupportColorFormat", "getThreadName", "", "handleStartEncode", "", "handleStopEncode", "processInputData", "", "data", "processOutputData", "Lkotlin/Pair;", "Lcom/jiangdg/ausbc/callback/IEncodeDataCallBack$DataType;", "Ljava/nio/ByteBuffer;", "encodeData", "bufferInfo", "Landroid/media/MediaCodec$BufferInfo;", "setOnEncodeReadyListener", "listener", "Companion", "OnEncodeReadyListener", "libausbc_release"})
public final class H264EncodeProcessor
extends AbstractProcessor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int width;
    private final int height;
    private final boolean gLESRender;
    private final boolean isPortrait;
    @Nullable
    private OnEncodeReadyListener mReadyListener;
    @NotNull
    private static final String TAG = "H264EncodeProcessor";
    @NotNull
    private static final String MIME = "video/avc";
    private static final int FRAME_RATE = 30;
    private static final int KEY_FRAME_INTERVAL = 1;

    public H264EncodeProcessor(int width, int height, boolean gLESRender, boolean isPortrait) {
        super(true);
        this.width = width;
        this.height = height;
        this.gLESRender = gLESRender;
        this.isPortrait = isPortrait;
    }

    public /* synthetic */ H264EncodeProcessor(int n, int n2, boolean bl, boolean bl2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 4) != 0) {
            bl = false;
        }
        if ((n3 & 8) != 0) {
            bl2 = true;
        }
        this(n, n2, bl, bl2);
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    @Override
    @NotNull
    protected String getThreadName() {
        return TAG;
    }

    @Override
    protected void handleStartEncode() {
        try {
            MediaFormat mediaFormat = MediaFormat.createVideoFormat((String)MIME, (int)this.width, (int)this.height);
            mediaFormat.setInteger("frame-rate", 30);
            Object object = this.getMBitRate();
            mediaFormat.setInteger("bitrate", object == null ? this.getEncodeBitrate(this.width, this.height) : ((Integer)object).intValue());
            mediaFormat.setInteger("i-frame-interval", 1);
            mediaFormat.setInteger("color-format", this.getSupportColorFormat());
            this.setMMediaCodec(MediaCodec.createEncoderByType((String)MIME));
            object = this.getMMediaCodec();
            if (object != null) {
                object.configure(mediaFormat, null, null, 1);
            }
            if (this.gLESRender && (object = this.mReadyListener) != null) {
                MediaCodec mediaCodec = this.getMMediaCodec();
                object.onReady(mediaCodec == null ? null : mediaCodec.createInputSurface());
            }
            if ((object = this.getMMediaCodec()) != null) {
                object.start();
            }
            this.getMEncodeState().set(true);
            this.doEncodeData();
            Logger.INSTANCE.i(TAG, "init h264 media codec success, bit = ");
        }
        catch (Exception e) {
            Logger.INSTANCE.e(TAG, Intrinsics.stringPlus((String)"start h264 media codec failed, err = ", (Object)e.getLocalizedMessage()), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleStopEncode() {
        try {
            this.getMEncodeState().set(false);
            MediaCodec mediaCodec = this.getMMediaCodec();
            if (mediaCodec != null) {
                mediaCodec.stop();
            }
            mediaCodec = this.getMMediaCodec();
            if (mediaCodec != null) {
                mediaCodec.release();
            }
            Logger.INSTANCE.i(TAG, "release h264 media codec success.");
        }
        catch (Exception e) {
            Logger.INSTANCE.e(TAG, Intrinsics.stringPlus((String)"Stop mediaCodec failed, err = ", (Object)e.getLocalizedMessage()), e);
        }
        finally {
            this.getMRawDataQueue().clear();
            this.setMMediaCodec(null);
        }
    }

    @Override
    protected long getPTSUs(int bufferSize) {
        return System.nanoTime() / 1000L;
    }

    @Override
    @NotNull
    protected Pair<IEncodeDataCallBack.DataType, ByteBuffer> processOutputData(@NotNull ByteBuffer encodeData, @NotNull MediaCodec.BufferInfo bufferInfo) {
        IEncodeDataCallBack.DataType dataType;
        Intrinsics.checkNotNullParameter((Object)encodeData, (String)"encodeData");
        Intrinsics.checkNotNullParameter((Object)bufferInfo, (String)"bufferInfo");
        int n = bufferInfo.flags;
        switch (n) {
            case 2: {
                dataType = IEncodeDataCallBack.DataType.H264_SPS;
                break;
            }
            case 1: {
                dataType = IEncodeDataCallBack.DataType.H264_KEY;
                break;
            }
            default: {
                dataType = IEncodeDataCallBack.DataType.H264;
            }
        }
        IEncodeDataCallBack.DataType type = dataType;
        return new Pair((Object)type, (Object)encodeData);
    }

    @Override
    @Nullable
    protected byte[] processInputData(@NotNull byte[] data) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (this.gLESRender) {
            byArray = null;
        } else {
            byte[] byArray2 = data;
            boolean bl = false;
            boolean bl2 = false;
            byte[] $this$processInputData_u24lambda_u2d0 = byArray2;
            boolean bl3 = false;
            if ($this$processInputData_u24lambda_u2d0.length != this.getWidth() * this.getHeight() * 3 / 2) {
                return null;
            }
            if (this.isPortrait) {
                YUVUtils.INSTANCE.nativeRotateNV21(data, this.getWidth(), this.getHeight(), 90);
            }
            YUVUtils.INSTANCE.nv21ToYuv420sp(data, this.getWidth(), this.getHeight());
            byArray = byArray2;
        }
        return byArray;
    }

    public final void setOnEncodeReadyListener(@NotNull OnEncodeReadyListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.mReadyListener = listener2;
    }

    private final int getSupportColorFormat() {
        if (this.gLESRender) {
            return 2130708361;
        }
        return 21;
    }

    private final int getEncodeBitrate(int width, int height) {
        float bitRate = (float)(width * height * 20 * 3) * 0.07f;
        if (width >= 1920 || height >= 1920) {
            bitRate *= 0.75f;
        } else if (width >= 1280 || height >= 1280) {
            bitRate *= 1.2f;
        } else if (width >= 640 || height >= 640) {
            bitRate *= 1.4f;
        }
        return (int)bitRate;
    }

    public final int getEncodeWidth() {
        return this.width;
    }

    public final int getEncodeHeight() {
        return this.height;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0012\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/jiangdg/ausbc/encode/H264EncodeProcessor$OnEncodeReadyListener;", "", "onReady", "", "surface", "Landroid/view/Surface;", "libausbc_release"})
    public static interface OnEncodeReadyListener {
        public void onReady(@Nullable Surface var1);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/jiangdg/ausbc/encode/H264EncodeProcessor$Companion;", "", "()V", "FRAME_RATE", "", "KEY_FRAME_INTERVAL", "MIME", "", "TAG", "libausbc_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

