/*
 * Decompiled with CFR 0.152.
 */
package org.jaxws.wsdl2bytecodes.service;

import com.sun.tools.ws.wscompile.WsimportTool;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.RandomUtils;
import org.jaxws.util.lang.RandomStringUtils;
import org.jaxws.wsdl2bytecodes.model.ByteCodePackage;
import org.jaxws.wsdl2bytecodes.service.WsdlImportException;

public class Wsdl2ByteCodes {
    public static ByteCodePackage generate(String byteCodesDirParent, String wsdlUrl, boolean isDebug) throws WsdlImportException {
        String currentTime = Wsdl2ByteCodes.formatDate(new Date(), "yyyyMMddHHmmssSSS");
        File byteCodeDir = Wsdl2ByteCodes.createByteCodesDir(byteCodesDirParent, currentTime);
        String packageName = Wsdl2ByteCodes.generatePakcageName(currentTime);
        byteCodeDir.mkdirs();
        Wsdl2ByteCodes.doWsImport(byteCodeDir.getAbsolutePath(), wsdlUrl, packageName, isDebug);
        Wsdl2ByteCodes.doCompile(byteCodeDir);
        System.out.println("Java files generated at: " + byteCodeDir);
        return new ByteCodePackage(byteCodeDir, packageName);
    }

    private static void doCompile(File sourceDir) throws WsdlImportException {
        System.out.println("Compiling stubs");
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        DiagnosticCollector diagnostics = new DiagnosticCollector();
        StandardJavaFileManager fileManager = compiler.getStandardFileManager(diagnostics, null, null);
        Collection files = FileUtils.listFiles((File)sourceDir, (String[])new String[]{"java"}, (boolean)true);
        Wsdl2ByteCodes.removeWebServiceClientFile(files);
        Iterable<? extends JavaFileObject> compilationUnits = fileManager.getJavaFileObjectsFromFiles(files);
        List<String> compilerOptions = Arrays.asList("-source", "1.8", "-target", "1.8");
        JavaCompiler.CompilationTask task = compiler.getTask(null, fileManager, diagnostics, compilerOptions, null, compilationUnits);
        boolean success = task.call();
        try {
            fileManager.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (!success) {
            StringBuffer errors = new StringBuffer();
            for (Diagnostic diagnostic : diagnostics.getDiagnostics()) {
                errors.append(String.format("Compilation Error on line %d in %s", diagnostic.getLineNumber(), diagnostic)).append("\n");
            }
            throw new WsdlImportException(errors.toString());
        }
    }

    private static void removeWebServiceClientFile(Collection<File> files) {
        File theFile = null;
        for (File file : files) {
            String content = null;
            try {
                content = FileUtils.readFileToString((File)file);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
            if (!content.contains("@WebServiceClient")) continue;
            theFile = file;
            break;
        }
        if (theFile != null) {
            files.remove(theFile);
        }
    }

    private static File createByteCodesDir(String byteCodeDirParent, String currentTime) {
        String nextDir = RandomStringUtils.getRandomLetters(10);
        return new File(byteCodeDirParent + "/" + currentTime + "/" + nextDir);
    }

    static String generatePakcageName(String currentTime) {
        ArrayList<String> fragments = new ArrayList<String>();
        fragments.add("wsdl2bytecodes" + currentTime);
        for (int i = 0; i < 2; ++i) {
            fragments.add(RandomStringUtils.getRandomLetters(3 + RandomUtils.nextInt((int)10)));
        }
        return StringUtils.join(fragments, (String)".");
    }

    private static void doWsImport(String outputDir, String wsdlUrl, String packageName, boolean isDebug) throws WsdlImportException {
        File jaxbFile = Wsdl2ByteCodes.copyDefaultJaxbFile(outputDir);
        ArrayList<String> argList = new ArrayList<String>();
        argList.add("-B-XautoNameResolution");
        argList.add("-b");
        argList.add(jaxbFile.getAbsolutePath());
        argList.add("-s");
        argList.add(outputDir);
        argList.add("-d");
        argList.add(outputDir);
        argList.add("-Xnocompile");
        if (packageName != null) {
            argList.add("-p");
            argList.add(packageName);
        }
        if (isDebug) {
            argList.add("-Xdebug");
        }
        argList.add("-verbose");
        argList.add("-extension");
        argList.add(wsdlUrl);
        Object[] argArray = new String[argList.size()];
        argList.toArray(argArray);
        System.out.println(StringUtils.join((Object[])argArray, (String)" "));
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        boolean result = new WsimportTool((OutputStream)outputStream).run((String[])argArray);
        String output = new String(outputStream.toByteArray());
        if (!result) {
            throw new WsdlImportException(output);
        }
        if (output.contains("Two declarations cause a collision in the ObjectFactory class")) {
            throw new DeclarationCollisionException(output);
        }
    }

    private static File copyDefaultJaxbFile(String outputDir) {
        File generatedJaxbFile = new File(outputDir, "jaxb.xml");
        InputStream inputStream = null;
        FileOutputStream outputStream = null;
        try {
            String defaultJaxbClasspath = "/default-jaxb.xml";
            inputStream = Wsdl2ByteCodes.class.getResourceAsStream(defaultJaxbClasspath);
            outputStream = new FileOutputStream(generatedJaxbFile);
            IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
        }
        catch (IOException e) {
            try {
                throw new IllegalStateException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream);
                IOUtils.closeQuietly(outputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        IOUtils.closeQuietly((OutputStream)outputStream);
        return generatedJaxbFile;
    }

    static String formatDate(Date date, String pattern) {
        SimpleDateFormat format = new SimpleDateFormat(pattern);
        return format.format(date);
    }

    public static final class DeclarationCollisionException
    extends WsdlImportException {
        private static final long serialVersionUID = 7625306326132684237L;

        public DeclarationCollisionException(String readableReason) {
            super(readableReason);
        }
    }
}

