/*
 * Decompiled with CFR 0.152.
 */
package org.jaxws.stub2html.view.freemarker;

import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateMethodModelEx;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.utility.DeepUnwrap;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.jaxws.stub2html.model.Stub;
import org.jaxws.stub2html.model.WebServiceStubSet;

public class FreemarkerWebServiceDisplayer {
    private final Template template;
    private final WebServiceStubSet serviceStubSet;

    FreemarkerWebServiceDisplayer(Template template, WebServiceStubSet serviceStubSet) {
        this.template = template;
        this.serviceStubSet = serviceStubSet;
    }

    public String displayWebSerivce() {
        try {
            HashMap<String, Object> rootMap = new HashMap<String, Object>();
            rootMap.put("service", this.serviceStubSet);
            rootMap.put("stubName", new DisplayStubNameMethodModel());
            rootMap.put("stubOgnl", new DisplayStubOgnlPathMethodModel());
            rootMap.put("stubType", new DisplayStubTypeMethodModel());
            rootMap.put("className", new DisplayClassNameMethodModel());
            StringWriter out = new StringWriter();
            this.template.process(rootMap, (Writer)out);
            return out.toString();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        catch (TemplateException e) {
            throw new IllegalStateException(e);
        }
    }

    private static String getStubNameConsideringMultiple(Stub stub) {
        if (StringUtils.isEmpty((String)stub.getStubName())) {
            return "";
        }
        if (stub.isMultiOccurs()) {
            return stub.getStubName() + "[]";
        }
        return stub.getStubName();
    }

    private final class DisplayStubTypeMethodModel
    implements TemplateMethodModelEx {
        private DisplayStubTypeMethodModel() {
        }

        public Object exec(List arguments) throws TemplateModelException {
            Stub stub = (Stub)DeepUnwrap.unwrap((TemplateModel)((TemplateModel)arguments.get(0)));
            String typeText = stub.getType().getSimpleName();
            if (stub.isMultiOccurs()) {
                typeText = typeText + "[]";
            }
            return typeText;
        }
    }

    private final class DisplayClassNameMethodModel
    implements TemplateMethodModelEx {
        private DisplayClassNameMethodModel() {
        }

        public Object exec(List arguments) throws TemplateModelException {
            Class clazz = (Class)DeepUnwrap.unwrap((TemplateModel)((TemplateModel)arguments.get(0)));
            return clazz.getSimpleName();
        }
    }

    private final class DisplayStubNameMethodModel
    implements TemplateMethodModelEx {
        private DisplayStubNameMethodModel() {
        }

        public Object exec(List arguments) throws TemplateModelException {
            Stub stub = (Stub)DeepUnwrap.unwrap((TemplateModel)((TemplateModel)arguments.get(0)));
            return FreemarkerWebServiceDisplayer.getStubNameConsideringMultiple(stub);
        }
    }

    private final class DisplayStubOgnlPathMethodModel
    implements TemplateMethodModelEx {
        private DisplayStubOgnlPathMethodModel() {
        }

        public Object exec(List arguments) throws TemplateModelException {
            Stub stub = (Stub)DeepUnwrap.unwrap((TemplateModel)((TemplateModel)arguments.get(0)));
            String parentPath = (String)DeepUnwrap.unwrap((TemplateModel)((TemplateModel)arguments.get(1)));
            if (parentPath == null || StringUtils.isEmpty((String)parentPath)) {
                return FreemarkerWebServiceDisplayer.getStubNameConsideringMultiple(stub);
            }
            return parentPath + "." + FreemarkerWebServiceDisplayer.getStubNameConsideringMultiple(stub);
        }
    }
}

