/*
 * Decompiled with CFR 0.152.
 */
package org.jaxws.stub2html.view.freemarker;

import freemarker.template.Template;
import java.io.File;
import java.io.IOException;
import org.jaxws.stub2html.view.freemarker.FreemarkerWebServiceDisplayEngine;

public class FilePathFreemarkerWebServiceDisplayEngine
extends FreemarkerWebServiceDisplayEngine {
    private File templateFile;

    private FilePathFreemarkerWebServiceDisplayEngine(File templateFile) {
        if (!templateFile.exists() || !templateFile.isFile()) {
            throw new IllegalArgumentException(templateFile + " doesn't exist or is not a file");
        }
        this.setTemplateLoadingDir(templateFile.getParentFile());
        this.templateFile = templateFile;
    }

    private void setTemplateLoadingDir(File parentFile) {
        try {
            this.configuration.setDirectoryForTemplateLoading(parentFile);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static FilePathFreemarkerWebServiceDisplayEngine createEngine(File templateFile) {
        return new FilePathFreemarkerWebServiceDisplayEngine(templateFile);
    }

    @Override
    protected Template getTemplate() {
        try {
            return this.configuration.getTemplate(this.templateFile.getName());
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }
}

