/*
 * Decompiled with CFR 0.152.
 */
package org.jaxws.stub2html.service;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;
import org.jaxws.stub2html.model.JavaLanguageVariable;
import org.jaxws.stub2html.model.Stub;
import org.jaxws.stub2html.model.StubTypeTree;
import org.jaxws.stub2html.service.JavaLanguageVariableFactory;
import org.jaxws.stub2html.service.StubTypeTreeRepository;

public class Variable2Stub {
    public static Stub convertToStub(JavaLanguageVariable variable, Stub parentStub, StubTypeTreeRepository typeTreeRepository) {
        Stub stub = new Stub();
        stub.setParentStubRelation(parentStub);
        stub.setStubName(variable.getVariableName());
        stub.setRequired(variable.isRequired());
        stub.setHeader(variable.isHeader());
        stub.setMultiOccurs(variable.isMultiOccurs());
        stub.setType(variable.getType());
        if (variable.getType().isAnnotationPresent(XmlType.class) && !variable.getType().isEnum() && !stub.isSameTypeWithSomeAncestor()) {
            Variable2Stub.convertFieldsToChildStubs(stub, variable.getType(), typeTreeRepository);
        }
        return stub;
    }

    private static void convertFieldsToChildStubs(Stub stub, Class<?> stubType, StubTypeTreeRepository typeTreeRepository) {
        List<Field> fields = Variable2Stub.getFieldsIncludingAncestorTypes(stubType);
        for (Field childField : fields) {
            Stub stub2 = Variable2Stub.convertToStub(JavaLanguageVariableFactory.createVariableFromField(childField), stub, typeTreeRepository);
        }
        LinkedList<FieldsOfSubType> fieldsOfSubTypes = Variable2Stub.getFieldsOfSubTypes(stubType, typeTreeRepository);
        for (FieldsOfSubType fieldsOfSubType : fieldsOfSubTypes) {
            for (Field field : fieldsOfSubType.fields) {
                Stub childStub = Variable2Stub.convertToStub(JavaLanguageVariableFactory.createVariableFromField(field), stub, typeTreeRepository);
                childStub.setSubTypeOfParentStub(fieldsOfSubType.subType);
            }
        }
    }

    private static List<Field> getFieldsIncludingAncestorTypes(Class<?> type) {
        ArrayList<Field> allFields = new ArrayList<Field>();
        do {
            Field[] fieldsArray = type.getDeclaredFields();
            ArrayList<Field> fields = new ArrayList<Field>();
            if (fieldsArray != null) {
                for (Field f : fieldsArray) {
                    fields.add(f);
                }
            }
            allFields.addAll(0, fields);
        } while ((type = type.getSuperclass()) != null && type.isAnnotationPresent(XmlType.class));
        return allFields;
    }

    private static LinkedList<FieldsOfSubType> getFieldsOfSubTypes(Class<?> thisType, StubTypeTreeRepository typeTreeRepository) {
        LinkedList<FieldsOfSubType> fieldsOfAllSubTypes = new LinkedList<FieldsOfSubType>();
        if (!thisType.isAnnotationPresent(XmlSeeAlso.class)) {
            return fieldsOfAllSubTypes;
        }
        List<Class<?>> subTypes = Variable2Stub.getSubTypes(thisType);
        Variable2Stub.registerToStubTypeTree(thisType, typeTreeRepository, subTypes);
        for (Class<?> subType : subTypes) {
            FieldsOfSubType fieldsOfSubType = new FieldsOfSubType(subType);
            fieldsOfSubType.addAll(Arrays.asList(subType.getDeclaredFields()));
            LinkedList<FieldsOfSubType> fieldsOfGrandSonType = Variable2Stub.getFieldsOfSubTypes(subType, typeTreeRepository);
            fieldsOfAllSubTypes.add(fieldsOfSubType);
            fieldsOfAllSubTypes.addAll(fieldsOfGrandSonType);
        }
        return fieldsOfAllSubTypes;
    }

    private static void registerToStubTypeTree(Class<?> thisType, StubTypeTreeRepository typeTreeRepository, List<Class<?>> subTypes) {
        StubTypeTree thisTypeTree = typeTreeRepository.getStubTypeTree(thisType);
        for (Class<?> subType : subTypes) {
            StubTypeTree subTypeTree = typeTreeRepository.getStubTypeTree(subType);
            subTypeTree.setParent(thisTypeTree);
        }
    }

    private static List<Class<?>> getSubTypes(Class<?> thisType) {
        ArrayList subTypes = new ArrayList();
        for (Class subType : thisType.getAnnotation(XmlSeeAlso.class).value()) {
            if (!thisType.isAssignableFrom(subType)) continue;
            subTypes.add(subType);
        }
        return subTypes;
    }

    private static final class FieldsOfSubType {
        private Class<?> subType;
        private List<Field> fields = new ArrayList<Field>();

        private FieldsOfSubType(Class<?> subType) {
            this.subType = subType;
        }

        public void addAll(List<Field> fields) {
            this.fields.addAll(fields);
        }
    }
}

