/*
 * Decompiled with CFR 0.152.
 */
package org.jaxws.bytecodes2stub.service;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.jaxws.util.lang.ClassNameUtils;
import org.jaxws.wsdl2bytecodes.model.ByteCodePackage;

public class ByteCodePackageClassLoader
extends ClassLoader {
    private ByteCodePackage byteCodePackage;

    public ByteCodePackageClassLoader(ClassLoader parent, ByteCodePackage byteCodePackage) {
        super(parent);
        this.byteCodePackage = byteCodePackage;
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        Class<?> clazz = this.findLoadedClass(name);
        if (clazz != null) {
            return clazz;
        }
        clazz = this.letParentLoad(name);
        if (clazz != null) {
            return clazz;
        }
        clazz = this.loadFromFileSystem(name);
        return clazz;
    }

    private Class<?> loadFromFileSystem(String name) throws ClassFormatError {
        File classDir = ByteCodePackageClassLoader.appendDir(this.byteCodePackage.getDir(), ClassNameUtils.getRelativeDir(name));
        String fileName = ClassNameUtils.toSimpleFileName(name);
        byte[] classData = this.readFileToBytes(new File(classDir, fileName));
        Class<?> clazz = this.defineClass(name, classData, 0, classData.length);
        return clazz;
    }

    private Class<?> letParentLoad(String name) {
        try {
            return this.getParent().loadClass(name);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    static File appendDir(File rootDir, String relativePath) {
        return new File(rootDir.getAbsolutePath() + "/" + relativePath);
    }

    private byte[] readFileToBytes(File classFile) {
        try {
            return FileUtils.readFileToByteArray((File)classFile);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

