/*
 * Decompiled with CFR 0.152.
 */
package com.checkout.validation.validator;

import com.checkout.validation.error.ValidationError;
import com.checkout.validation.model.CvvValidationRequest;
import com.checkout.validation.model.ValidationResult;
import com.checkout.validation.validator.contract.Validator;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\u0010\b\n\u0000\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u001e\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002\u00a8\u0006\u000e"}, d2={"Lcom/checkout/validation/validator/CvvValidator;", "Lcom/checkout/validation/validator/contract/Validator;", "Lcom/checkout/validation/model/CvvValidationRequest;", "", "()V", "validate", "Lcom/checkout/validation/model/ValidationResult;", "data", "validateCvv", "cvv", "", "cvvLength", "", "", "checkout_release"})
@SourceDebugExtension(value={"SMAP\nCvvValidator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CvvValidator.kt\ncom/checkout/validation/validator/CvvValidator\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,54:1\n1083#2,2:55\n1747#3,3:57\n*S KotlinDebug\n*F\n+ 1 CvvValidator.kt\ncom/checkout/validation/validator/CvvValidator\n*L\n35#1:55,2\n40#1:57,3\n*E\n"})
public final class CvvValidator
implements Validator<CvvValidationRequest, Unit> {
    @Override
    @NotNull
    public ValidationResult<Unit> validate(@NotNull CvvValidationRequest data) {
        ValidationResult validationResult;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        try {
            this.validateCvv(data.getCvv(), data.getCardScheme().getCvvLength());
            validationResult = new ValidationResult.Success<Unit>(Unit.INSTANCE);
        }
        catch (ValidationError e) {
            validationResult = new ValidationResult.Failure(e);
        }
        return validationResult;
    }

    private final void validateCvv(String cvv, Set<Integer> cvvLength) throws ValidationError {
        boolean bl;
        block8: {
            boolean bl2;
            int it;
            boolean $i$f$any;
            Object $this$any$iv;
            block7: {
                $this$any$iv = cvv;
                $i$f$any = false;
                for (int i = 0; i < $this$any$iv.length(); ++i) {
                    int element$iv;
                    it = element$iv = $this$any$iv.charAt(i);
                    boolean bl3 = false;
                    boolean bl4 = !Character.isDigit((char)it);
                    if (!bl4) continue;
                    bl2 = true;
                    break block7;
                }
                bl2 = false;
            }
            if (bl2) {
                throw new ValidationError("ValidationError:1002", "CVV should contain only digits", null, 4, null);
            }
            $this$any$iv = cvvLength;
            $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                Iterator iterator = $this$any$iv.iterator();
                while (iterator.hasNext()) {
                    Object element$iv = iterator.next();
                    it = ((Number)element$iv).intValue();
                    boolean bl5 = false;
                    if (!(it == cvv.length())) continue;
                    bl = true;
                    break block8;
                }
                bl = false;
            }
        }
        if (bl) {
            return;
        }
        if (cvv.length() < ((Number)((Object)CollectionsKt.minOrThrow((Iterable)cvvLength))).intValue() || cvv.length() < ((Number)((Object)CollectionsKt.maxOrThrow((Iterable)cvvLength))).intValue()) {
            throw new ValidationError("ValidationError:1022", "Incomplete CVV length, it should be " + cvvLength, null, 4, null);
        }
        throw new ValidationError("ValidationError:1003", "Invalid CVV length, it should be " + cvvLength, null, 4, null);
    }
}

