/*
 * Decompiled with CFR 0.152.
 */
package com.checkout.tokenization.logging;

import com.checkout.eventlogger.domain.model.MonitoringLevel;
import com.checkout.logging.Logger;
import com.checkout.logging.model.LoggingEvent;
import com.checkout.logging.utils.HashMapExtensionKt;
import com.checkout.network.response.ErrorResponse;
import com.checkout.tokenization.logging.TokenizationEventType;
import com.checkout.tokenization.logging.TokenizationLogger;
import com.checkout.tokenization.response.CVVTokenDetailsResponse;
import com.checkout.tokenization.response.TokenDetailsResponse;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\"\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016Ja\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u00112\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u00132\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u00152\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002\u00a2\u0006\u0002\u0010\u0018J\u0018\u0010\u0019\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016JE\u0010\u001a\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016\u00a2\u0006\u0002\u0010\u001bJW\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u001d\u001a\u0004\u0018\u00010\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002\u00a2\u0006\u0002\u0010\u001eJ\b\u0010\u001f\u001a\u00020\u0007H\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/checkout/tokenization/logging/TokenizationEventLogger;", "Lcom/checkout/tokenization/logging/TokenizationLogger;", "logger", "Lcom/checkout/logging/Logger;", "Lcom/checkout/logging/model/LoggingEvent;", "(Lcom/checkout/logging/Logger;)V", "logErrorOnTokenRequestedEvent", "", "tokenType", "", "publicKey", "error", "", "logEvent", "tokenizationEventType", "Lcom/checkout/tokenization/logging/TokenizationEventType;", "tokenDetails", "Lcom/checkout/tokenization/response/TokenDetailsResponse;", "cvvTokenDetailsResponse", "Lcom/checkout/tokenization/response/CVVTokenDetailsResponse;", "code", "", "errorResponse", "Lcom/checkout/network/response/ErrorResponse;", "(Lcom/checkout/tokenization/logging/TokenizationEventType;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Throwable;Lcom/checkout/tokenization/response/TokenDetailsResponse;Lcom/checkout/tokenization/response/CVVTokenDetailsResponse;Ljava/lang/Integer;Lcom/checkout/network/response/ErrorResponse;)V", "logTokenRequestEvent", "logTokenResponseEvent", "(Ljava/lang/String;Ljava/lang/String;Lcom/checkout/tokenization/response/TokenDetailsResponse;Lcom/checkout/tokenization/response/CVVTokenDetailsResponse;Ljava/lang/Integer;Lcom/checkout/network/response/ErrorResponse;)V", "provideLoggingEvent", "cvvTokenDetails", "(Lcom/checkout/tokenization/logging/TokenizationEventType;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Throwable;Lcom/checkout/tokenization/response/TokenDetailsResponse;Lcom/checkout/tokenization/response/CVVTokenDetailsResponse;Ljava/lang/Integer;Lcom/checkout/network/response/ErrorResponse;)Lcom/checkout/logging/model/LoggingEvent;", "resetSession", "checkout_release"})
@SourceDebugExtension(value={"SMAP\nTokenizationEventLogger.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TokenizationEventLogger.kt\ncom/checkout/tokenization/logging/TokenizationEventLogger\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,115:1\n1#2:116\n*E\n"})
public final class TokenizationEventLogger
implements TokenizationLogger {
    @NotNull
    private final Logger<LoggingEvent> logger;

    public TokenizationEventLogger(@NotNull Logger<LoggingEvent> logger) {
        Intrinsics.checkNotNullParameter(logger, (String)"logger");
        this.logger = logger;
    }

    @Override
    public void logErrorOnTokenRequestedEvent(@NotNull String tokenType, @NotNull String publicKey, @Nullable Throwable error) {
        Intrinsics.checkNotNullParameter((Object)tokenType, (String)"tokenType");
        Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
        TokenizationEventLogger.logEvent$default(this, TokenizationEventType.TOKEN_REQUESTED, tokenType, publicKey, error, null, null, null, null, 240, null);
    }

    @Override
    public void logTokenRequestEvent(@NotNull String tokenType, @NotNull String publicKey) {
        Intrinsics.checkNotNullParameter((Object)tokenType, (String)"tokenType");
        Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
        TokenizationEventLogger.logEvent$default(this, TokenizationEventType.TOKEN_REQUESTED, tokenType, publicKey, null, null, null, null, null, 248, null);
    }

    @Override
    public void logTokenResponseEvent(@NotNull String tokenType, @NotNull String publicKey, @Nullable TokenDetailsResponse tokenDetails, @Nullable CVVTokenDetailsResponse cvvTokenDetailsResponse, @Nullable Integer code, @Nullable ErrorResponse errorResponse) {
        Intrinsics.checkNotNullParameter((Object)tokenType, (String)"tokenType");
        Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
        this.logEvent(TokenizationEventType.TOKEN_RESPONSE, tokenType, publicKey, null, tokenDetails, cvvTokenDetailsResponse, code, errorResponse);
    }

    @Override
    public void resetSession() {
        this.logger.resetSession();
    }

    private final void logEvent(TokenizationEventType tokenizationEventType, String tokenType, String publicKey, Throwable error, TokenDetailsResponse tokenDetails, CVVTokenDetailsResponse cvvTokenDetailsResponse, Integer code, ErrorResponse errorResponse) {
        this.logger.log(this.provideLoggingEvent(tokenizationEventType, tokenType, publicKey, error, tokenDetails, cvvTokenDetailsResponse, code, errorResponse));
    }

    static /* synthetic */ void logEvent$default(TokenizationEventLogger tokenizationEventLogger, TokenizationEventType tokenizationEventType, String string, String string2, Throwable throwable, TokenDetailsResponse tokenDetailsResponse, CVVTokenDetailsResponse cVVTokenDetailsResponse, Integer n, ErrorResponse errorResponse, int n2, Object object) {
        if ((n2 & 8) != 0) {
            throwable = null;
        }
        if ((n2 & 0x10) != 0) {
            tokenDetailsResponse = null;
        }
        if ((n2 & 0x20) != 0) {
            cVVTokenDetailsResponse = null;
        }
        if ((n2 & 0x40) != 0) {
            n = null;
        }
        if ((n2 & 0x80) != 0) {
            errorResponse = null;
        }
        tokenizationEventLogger.logEvent(tokenizationEventType, string, string2, throwable, tokenDetailsResponse, cVVTokenDetailsResponse, n, errorResponse);
    }

    private final LoggingEvent provideLoggingEvent(TokenizationEventType tokenizationEventType, String tokenType, String publicKey, Throwable error, TokenDetailsResponse tokenDetails, CVVTokenDetailsResponse cvvTokenDetails, Integer code, ErrorResponse errorResponse) {
        HashMap<String, Object> properties;
        block5: {
            Object object;
            String string;
            Object object2;
            Object it;
            properties = new HashMap<String, Object>();
            ((Map)properties).put("tokenType", tokenType);
            ((Map)properties).put("publicKey", publicKey);
            Throwable throwable = error;
            if (throwable != null) {
                it = throwable;
                boolean bl = false;
                HashMapExtensionKt.putErrorAttributes(properties, (Throwable)it);
            }
            TokenDetailsResponse tokenDetailsResponse = tokenDetails;
            if (tokenDetailsResponse != null) {
                it = tokenDetailsResponse;
                boolean bl = false;
                ((Map)properties).put("tokenID", ((TokenDetailsResponse)it).getToken());
                object2 = properties;
                string = "scheme";
                Pair[] pairArray = ((TokenDetailsResponse)it).getScheme();
                if (pairArray == null) {
                    pairArray = "";
                }
                object = pairArray;
                object2.put(string, object);
            }
            CVVTokenDetailsResponse cVVTokenDetailsResponse = cvvTokenDetails;
            if (cVVTokenDetailsResponse != null) {
                it = cVVTokenDetailsResponse;
                boolean bl = false;
                ((Map)properties).put("tokenID", ((CVVTokenDetailsResponse)it).getToken());
            }
            Integer n = code;
            if (n != null) {
                int it2 = ((Number)n).intValue();
                boolean bl = false;
                object2 = it2;
                ((Map)properties).put("httpStatusCode", object2);
            }
            ErrorResponse errorResponse2 = errorResponse;
            if (errorResponse2 == null) break block5;
            ErrorResponse it3 = errorResponse2;
            boolean bl = false;
            object2 = properties;
            string = "serverError";
            object = new Pair[]{TuplesKt.to((Object)"requestID", (Object)it3.getRequestId()), TuplesKt.to((Object)"errorType", (Object)it3.getErrorType()), TuplesKt.to((Object)"errorCodes", it3.getErrorCodes())};
            object = MapsKt.mapOf((Pair[])object);
            object2.put(string, object);
        }
        return new LoggingEvent(tokenizationEventType, error == null ? MonitoringLevel.INFO : MonitoringLevel.ERROR, (Map<String, ? extends Object>)properties);
    }
}

