/*
 * Decompiled with CFR 0.152.
 */
package com.checkout.threedsecure.webview;

import android.graphics.Bitmap;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebResourceResponse;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.checkout.threedsecure.error.ThreeDSError;
import com.checkout.threedsecure.logging.ThreeDSLogger;
import com.checkout.threedsecure.utils.WebResourcesExtensionKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001BU\u0012#\u0010\u0002\u001a\u001f\u0012\u0015\u0012\u0013\u0018\u00010\u0004\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\u0004\u0012\u00020\b0\u0003\u0012!\u0010\t\u001a\u001d\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u000b\u0012\u0004\u0012\u00020\f0\u0003\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\u001c\u0010\u0012\u001a\u00020\f2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0007\u001a\u0004\u0018\u00010\u0004H\u0016J&\u0010\u0015\u001a\u00020\f2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0007\u001a\u0004\u0018\u00010\u00042\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J&\u0010\u0018\u001a\u00020\f2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\b\u0010\u000b\u001a\u0004\u0018\u00010\u001bH\u0016J&\u0010\u001c\u001a\u00020\f2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0016J\u001c\u0010\u001f\u001a\u00020\b2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016R\u000e\u0010\u0010\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R)\u0010\t\u001a\u001d\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u000b\u0012\u0004\u0012\u00020\f0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R+\u0010\u0002\u001a\u001f\u0012\u0015\u0012\u0013\u0018\u00010\u0004\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\u0004\u0012\u00020\b0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/checkout/threedsecure/webview/ThreeDSWebViewClient;", "Landroid/webkit/WebViewClient;", "onResult", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "url", "", "onError", "Lcom/checkout/threedsecure/error/ThreeDSError;", "error", "", "logger", "Lcom/checkout/threedsecure/logging/ThreeDSLogger;", "(Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;Lcom/checkout/threedsecure/logging/ThreeDSLogger;)V", "loadedFirstTime", "presentedFirstTime", "onPageCommitVisible", "view", "Landroid/webkit/WebView;", "onPageStarted", "favicon", "Landroid/graphics/Bitmap;", "onReceivedError", "request", "Landroid/webkit/WebResourceRequest;", "Landroid/webkit/WebResourceError;", "onReceivedHttpError", "errorResponse", "Landroid/webkit/WebResourceResponse;", "shouldOverrideUrlLoading", "checkout_release"})
public final class ThreeDSWebViewClient
extends WebViewClient {
    @NotNull
    private final Function1<String, Boolean> onResult;
    @NotNull
    private final Function1<ThreeDSError, Unit> onError;
    @NotNull
    private final ThreeDSLogger logger;
    private boolean presentedFirstTime;
    private boolean loadedFirstTime;

    public ThreeDSWebViewClient(@NotNull Function1<? super String, Boolean> onResult, @NotNull Function1<? super ThreeDSError, Unit> onError, @NotNull ThreeDSLogger logger) {
        Intrinsics.checkNotNullParameter(onResult, (String)"onResult");
        Intrinsics.checkNotNullParameter(onError, (String)"onError");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.onResult = onResult;
        this.onError = onError;
        this.logger = logger;
        this.presentedFirstTime = true;
        this.loadedFirstTime = true;
    }

    public void onPageStarted(@Nullable WebView view, @Nullable String url, @Nullable Bitmap favicon) {
        super.onPageStarted(view, url, favicon);
        if (this.presentedFirstTime) {
            this.logger.logPresentedEvent();
            this.presentedFirstTime = false;
        }
    }

    public boolean shouldOverrideUrlLoading(@Nullable WebView view, @Nullable WebResourceRequest request) {
        boolean bl;
        WebResourceRequest webResourceRequest = request;
        if (webResourceRequest != null && (webResourceRequest = webResourceRequest.getUrl()) != null) {
            WebResourceRequest it = webResourceRequest;
            boolean bl2 = false;
            bl = (Boolean)this.onResult.invoke((Object)it.toString());
        } else {
            bl = super.shouldOverrideUrlLoading(view, request);
        }
        return bl;
    }

    public void onPageCommitVisible(@Nullable WebView view, @Nullable String url) {
        super.onPageCommitVisible(view, url);
        if (this.loadedFirstTime) {
            ThreeDSLogger.DefaultImpls.logLoadedEvent$default(this.logger, true, null, 2, null);
            this.loadedFirstTime = false;
        }
    }

    public void onReceivedError(@Nullable WebView view, @Nullable WebResourceRequest request, @Nullable WebResourceError error) {
        block0: {
            super.onReceivedError(view, request, error);
            Object object = error;
            if (object == null || (object = WebResourcesExtensionKt.toThreeDSError(object)) == null) break block0;
            Object object2 = object;
            this.onError.invoke(object2);
        }
    }

    public void onReceivedHttpError(@Nullable WebView view, @Nullable WebResourceRequest request, @Nullable WebResourceResponse errorResponse) {
        block0: {
            super.onReceivedHttpError(view, request, errorResponse);
            Object object = errorResponse;
            if (object == null || (object = WebResourcesExtensionKt.toThreeDSError(object)) == null) break block0;
            Object object2 = object;
            this.onError.invoke(object2);
        }
    }
}

