/*
 * Decompiled with CFR 0.152.
 */
package com.checkout.risk;

import android.content.Context;
import com.checkout.eventlogger.CheckoutEventLogger;
import com.checkout.eventlogger.Environment;
import com.checkout.eventlogger.domain.model.Event;
import com.checkout.eventlogger.domain.model.MonitoringLevel;
import com.checkout.eventlogger.domain.model.RemoteProcessorMetadata;
import com.checkout.risk.BuildConfig;
import com.checkout.risk.FramesOptions;
import com.checkout.risk.LoggerServiceProtocol;
import com.checkout.risk.RiskEnvironment;
import com.checkout.risk.RiskEvent;
import com.checkout.risk.RiskLogError;
import com.checkout.risk.RiskSDKInternalConfig;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u0001:\u0001*B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006Jc\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0011\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0012\u001a\u00020\u000e2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00142\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002\u00a2\u0006\u0002\u0010\u0018J\u0010\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u0014H\u0002J\u0010\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u0014H\u0002J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J[\u0010\u001f\u001a\u00020\u001e2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0011\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00142\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016\u00a2\u0006\u0002\u0010 J(\u0010!\u001a\u00020\"2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020#2\u0006\u0010$\u001a\u00020\u00142\u0006\u0010%\u001a\u00020\u0014H\u0002J\u0011\u0010&\u001a\u00020#*\u00020#H\u0000\u00a2\u0006\u0002\b'J\u0011\u0010(\u001a\u00020\u0014*\u00020#H\u0000\u00a2\u0006\u0002\b)R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/checkout/risk/LoggerService;", "Lcom/checkout/risk/LoggerServiceProtocol;", "internalConfig", "Lcom/checkout/risk/RiskSDKInternalConfig;", "context", "Landroid/content/Context;", "(Lcom/checkout/risk/RiskSDKInternalConfig;Landroid/content/Context;)V", "logger", "Lcom/checkout/eventlogger/CheckoutEventLogger;", "formatEvent", "Lcom/checkout/eventlogger/domain/model/Event;", "riskEvent", "Lcom/checkout/risk/RiskEvent;", "blockTime", "", "deviceDataPersistTime", "fpLoadTime", "fpPublishTime", "totalLatency", "deviceSessionID", "", "requestID", "error", "Lcom/checkout/risk/RiskLogError;", "(Lcom/checkout/risk/RiskEvent;Ljava/lang/Double;Ljava/lang/Double;Ljava/lang/Double;Ljava/lang/Double;DLjava/lang/String;Ljava/lang/String;Lcom/checkout/risk/RiskLogError;)Lcom/checkout/eventlogger/domain/model/Event;", "getDDTags", "environment", "getMaskedPublicKey", "publicKey", "initialise", "", "log", "(Lcom/checkout/risk/RiskEvent;Ljava/lang/Double;Ljava/lang/Double;Ljava/lang/Double;Ljava/lang/Double;Ljava/lang/String;Ljava/lang/String;Lcom/checkout/risk/RiskLogError;)V", "provideProcessorMetadata", "Lcom/checkout/eventlogger/domain/model/RemoteProcessorMetadata;", "Lcom/checkout/eventlogger/Environment;", "identifier", "version", "toLoggingEnvironment", "toLoggingEnvironment$Risk_release", "toLoggingName", "toLoggingName$Risk_release", "LoggingEvent", "Risk_release"})
@SourceDebugExtension(value={"SMAP\nLoggerService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LoggerService.kt\ncom/checkout/risk/LoggerService\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,239:1\n13309#2,2:240\n494#3,7:242\n453#3:249\n403#3:250\n494#3,7:255\n453#3:262\n403#3:263\n1238#4,4:251\n1238#4,4:264\n*S KotlinDebug\n*F\n+ 1 LoggerService.kt\ncom/checkout/risk/LoggerService\n*L\n137#1:240,2\n202#1:242,7\n202#1:249\n202#1:250\n221#1:255,7\n221#1:262\n221#1:263\n202#1:251,4\n221#1:264,4\n*E\n"})
public final class LoggerService
implements LoggerServiceProtocol {
    @NotNull
    private final RiskSDKInternalConfig internalConfig;
    @NotNull
    private final CheckoutEventLogger logger;

    /*
     * WARNING - void declaration
     */
    public LoggerService(@NotNull RiskSDKInternalConfig internalConfig, @NotNull Context context) {
        CheckoutEventLogger checkoutEventLogger;
        Intrinsics.checkNotNullParameter((Object)internalConfig, (String)"internalConfig");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.internalConfig = internalConfig;
        CheckoutEventLogger checkoutEventLogger2 = checkoutEventLogger = new CheckoutEventLogger("risk-android-sdk");
        LoggerService loggerService = this;
        boolean bl = false;
        Boolean bl2 = BuildConfig.DEFAULT_LOGCAT_MONITORING_ENABLED;
        Intrinsics.checkNotNullExpressionValue((Object)bl2, (String)"DEFAULT_LOGCAT_MONITORING_ENABLED");
        if (bl2.booleanValue()) {
            void it;
            it.enableLocalProcessor(MonitoringLevel.DEBUG);
        }
        loggerService.logger = checkoutEventLogger;
        this.initialise(context, this.internalConfig);
    }

    private final void initialise(Context context, RiskSDKInternalConfig internalConfig) {
        Environment environment;
        Object object;
        Object identifier;
        Object object2 = internalConfig.getFramesOptions();
        if (object2 == null || (object2 = ((FramesOptions)object2).getProductIdentifier()) == null) {
            object2 = identifier = "com.checkout.risk";
        }
        if ((object = internalConfig.getFramesOptions()) == null || (object = ((FramesOptions)object).getVersion()) == null) {
            object = "1.0.1";
        }
        Object version = object;
        FramesOptions framesOptions = internalConfig.getFramesOptions();
        String correlationId = framesOptions != null ? framesOptions.getCorrelationId() : null;
        switch (WhenMappings.$EnumSwitchMapping$0[internalConfig.getEnvironment().ordinal()]) {
            case 1: 
            case 2: {
                environment = (Environment)Environment.SANDBOX.INSTANCE;
                break;
            }
            case 3: {
                environment = (Environment)Environment.PRODUCTION.INSTANCE;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Environment environment2 = environment;
        this.logger.enableRemoteProcessor(this.toLoggingEnvironment$Risk_release(environment2), this.provideProcessorMetadata(context, environment2, (String)identifier, (String)version));
        if (correlationId != null) {
            this.logger.addMetadata("CORRELATION_ID", correlationId);
        }
    }

    private final RemoteProcessorMetadata provideProcessorMetadata(Context context, Environment environment, String identifier, String version) {
        return RemoteProcessorMetadata.Companion.from(context, this.toLoggingName$Risk_release(environment), identifier, version);
    }

    @NotNull
    public final Environment toLoggingEnvironment$Risk_release(@NotNull Environment $this$toLoggingEnvironment) {
        Environment environment;
        Intrinsics.checkNotNullParameter((Object)$this$toLoggingEnvironment, (String)"<this>");
        Environment environment2 = $this$toLoggingEnvironment;
        if (Intrinsics.areEqual((Object)environment2, (Object)Environment.PRODUCTION.INSTANCE)) {
            environment = (Environment)Environment.PRODUCTION.INSTANCE;
        } else if (Intrinsics.areEqual((Object)environment2, (Object)Environment.SANDBOX.INSTANCE)) {
            environment = (Environment)Environment.SANDBOX.INSTANCE;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return environment;
    }

    @NotNull
    public final String toLoggingName$Risk_release(@NotNull Environment $this$toLoggingName) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$toLoggingName, (String)"<this>");
        Environment environment = $this$toLoggingName;
        if (Intrinsics.areEqual((Object)environment, (Object)Environment.PRODUCTION.INSTANCE)) {
            string = "production";
        } else if (Intrinsics.areEqual((Object)environment, (Object)Environment.SANDBOX.INSTANCE)) {
            string = "sandbox";
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    @Override
    public void log(@NotNull RiskEvent riskEvent, @Nullable Double blockTime, @Nullable Double deviceDataPersistTime, @Nullable Double fpLoadTime, @Nullable Double fpPublishTime, @Nullable String deviceSessionID, @Nullable String requestID, @Nullable RiskLogError error) {
        Intrinsics.checkNotNullParameter((Object)((Object)riskEvent), (String)"riskEvent");
        double totalLatency = 0.0;
        Double[] doubleArray = new Double[]{blockTime, deviceDataPersistTime, fpLoadTime, fpPublishTime};
        Double[] $this$forEach$iv = doubleArray;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            Double element$iv;
            Double item = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            Double d = item;
            totalLatency += d != null ? d : 0.0;
        }
        Event event = this.formatEvent(riskEvent, blockTime, deviceDataPersistTime, fpLoadTime, fpPublishTime, totalLatency, deviceSessionID, requestID, error);
        Event[] eventArray = new Event[]{event};
        this.logger.logEvent(eventArray);
    }

    /*
     * WARNING - void declaration
     */
    private final Event formatEvent(RiskEvent riskEvent, Double blockTime, Double deviceDataPersistTime, Double fpLoadTime, Double fpPublishTime, double totalLatency, String deviceSessionID, String requestID, RiskLogError error) {
        Object object;
        MonitoringLevel monitoringLevel;
        String timeZoneLog = TimeZone.getDefault().getID();
        String maskedPublicKey = this.getMaskedPublicKey(this.internalConfig.getMerchantPublicKey());
        String string = this.internalConfig.getEnvironment().name();
        Locale locale = Locale.ROOT;
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ROOT");
        String string2 = string.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(locale)");
        String ddTags = this.getDDTags(string2);
        boolean framesMode = this.internalConfig.getFramesOptions() != null;
        switch (WhenMappings.$EnumSwitchMapping$1[riskEvent.ordinal()]) {
            case 1: 
            case 2: {
                monitoringLevel = MonitoringLevel.INFO;
                break;
            }
            case 3: 
            case 4: {
                monitoringLevel = MonitoringLevel.ERROR;
                break;
            }
            case 5: {
                monitoringLevel = MonitoringLevel.WARN;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        MonitoringLevel monitoringLevel2 = monitoringLevel;
        switch (WhenMappings.$EnumSwitchMapping$1[riskEvent.ordinal()]) {
            case 1: 
            case 2: {
                Object v;
                Map.Entry it;
                Object object2;
                Object k;
                Map.Entry it$iv$iv;
                Object object3;
                void $this$mapValuesTo$iv$iv;
                Object $this$mapValues$iv;
                Map $this$filterValues$iv;
                Object object4 = new Pair[]{TuplesKt.to((Object)"Block", (Object)blockTime), TuplesKt.to((Object)"DeviceDataPersist", (Object)deviceDataPersistTime), TuplesKt.to((Object)"FpLoad", (Object)fpLoadTime), TuplesKt.to((Object)"FpPublish", (Object)fpPublishTime), TuplesKt.to((Object)"Total", (Object)totalLatency), TuplesKt.to((Object)"EventType", (Object)riskEvent.getRawValue()), TuplesKt.to((Object)"FramesMode", (Object)framesMode), TuplesKt.to((Object)"MaskedPublicKey", (Object)maskedPublicKey), TuplesKt.to((Object)"ddTags", (Object)ddTags), TuplesKt.to((Object)"RiskSDKVersion", (Object)"2.0.0"), TuplesKt.to((Object)"Timezone", (Object)timeZoneLog), TuplesKt.to((Object)"FpRequestId", (Object)requestID), TuplesKt.to((Object)"DeviceSessionId", (Object)deviceSessionID)};
                object4 = MapsKt.mapOf((Pair[])object4);
                boolean $i$f$filterValues = false;
                Object result$iv = new LinkedHashMap();
                for (Map.Entry entry : $this$filterValues$iv.entrySet()) {
                    Object it2 = entry.getValue();
                    boolean bl2 = false;
                    if (!(it2 != null)) continue;
                    ((HashMap)result$iv).put(entry.getKey(), entry.getValue());
                }
                $this$filterValues$iv = (Map)result$iv;
                boolean $i$f$mapValues = false;
                result$iv = $this$mapValues$iv;
                Object destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
                boolean bl = false;
                Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
                boolean $i$f$associateByTo = false;
                for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                    Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                    object3 = destination$iv$iv;
                    boolean bl2 = false;
                    Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                    k = it$iv$iv.getKey();
                    object2 = object3;
                    boolean bl3 = false;
                    Intrinsics.checkNotNull(it.getValue());
                    object2.put(k, v);
                }
                object = destination$iv$iv;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                Object v;
                Map.Entry it;
                Object object2;
                Object k;
                Map.Entry it$iv$iv;
                Object object3;
                void $this$mapValuesTo$iv$iv;
                Map $this$filterValues$iv;
                Object $this$mapValues$iv = new Pair[15];
                $this$mapValues$iv[0] = TuplesKt.to((Object)"Block", (Object)blockTime);
                $this$mapValues$iv[1] = TuplesKt.to((Object)"DeviceDataPersist", (Object)deviceDataPersistTime);
                $this$mapValues$iv[2] = TuplesKt.to((Object)"FpLoad", (Object)fpLoadTime);
                $this$mapValues$iv[3] = TuplesKt.to((Object)"FpPublish", (Object)fpPublishTime);
                $this$mapValues$iv[4] = TuplesKt.to((Object)"Total", (Object)totalLatency);
                $this$mapValues$iv[5] = TuplesKt.to((Object)"EventType", (Object)riskEvent.getRawValue());
                $this$mapValues$iv[6] = TuplesKt.to((Object)"FramesMode", (Object)framesMode);
                $this$mapValues$iv[7] = TuplesKt.to((Object)"MaskedPublicKey", (Object)maskedPublicKey);
                $this$mapValues$iv[8] = TuplesKt.to((Object)"ddTags", (Object)ddTags);
                $this$mapValues$iv[9] = TuplesKt.to((Object)"RiskSDKVersion", (Object)"2.0.0");
                $this$mapValues$iv[10] = TuplesKt.to((Object)"Timezone", (Object)timeZoneLog);
                RiskLogError riskLogError = error;
                $this$mapValues$iv[11] = TuplesKt.to((Object)"ErrorMessage", (Object)(riskLogError != null ? riskLogError.getMessage() : null));
                RiskLogError riskLogError2 = error;
                $this$mapValues$iv[12] = TuplesKt.to((Object)"ErrorType", (Object)(riskLogError2 != null ? riskLogError2.getType() : null));
                RiskLogError riskLogError3 = error;
                $this$mapValues$iv[13] = TuplesKt.to((Object)"ErrorReason", (Object)(riskLogError3 != null ? riskLogError3.getReason() : null));
                RiskLogError riskLogError4 = error;
                $this$mapValues$iv[14] = TuplesKt.to((Object)"InnerExceptionType", (Object)(riskLogError4 != null ? riskLogError4.getInnerExceptionType() : null));
                $this$mapValues$iv = MapsKt.mapOf((Pair[])$this$mapValues$iv);
                boolean $i$f$filterValues = false;
                Object result$iv = new LinkedHashMap();
                for (Map.Entry entry : $this$filterValues$iv.entrySet()) {
                    Object it2 = entry.getValue();
                    boolean bl4 = false;
                    if (!(it2 != null)) continue;
                    ((HashMap)result$iv).put(entry.getKey(), entry.getValue());
                }
                $this$filterValues$iv = (Map)result$iv;
                boolean $i$f$mapValues = false;
                result$iv = $this$mapValues$iv;
                Object destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
                boolean bl = false;
                Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
                boolean $i$f$associateByTo = false;
                for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                    it$iv$iv = (Map.Entry)element$iv$iv$iv;
                    object3 = destination$iv$iv;
                    boolean bl3 = false;
                    it = (Map.Entry)element$iv$iv$iv;
                    k = it$iv$iv.getKey();
                    object2 = object3;
                    boolean bl5 = false;
                    Intrinsics.checkNotNull(it.getValue());
                    object2.put(k, v);
                }
                object = destination$iv$iv;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Object properties = object;
        return new LoggingEvent(monitoringLevel2, (Map)properties, null, riskEvent.getRawValue(), 4, null);
    }

    private final String getMaskedPublicKey(String publicKey) {
        return StringsKt.take((String)publicKey, (int)8) + "********" + StringsKt.takeLast((String)publicKey, (int)6);
    }

    private final String getDDTags(String environment) {
        return "team:prism,service:prism.risk.android,version:2.0.0,env:" + environment;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\u0015\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\tH\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0006H\u00c6\u0003J=\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00052\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0007H\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u0006H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR \u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\n\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001f"}, d2={"Lcom/checkout/risk/LoggerService$LoggingEvent;", "Lcom/checkout/eventlogger/domain/model/Event;", "monitoringLevel", "Lcom/checkout/eventlogger/domain/model/MonitoringLevel;", "properties", "", "", "", "time", "Ljava/util/Date;", "typeIdentifier", "(Lcom/checkout/eventlogger/domain/model/MonitoringLevel;Ljava/util/Map;Ljava/util/Date;Ljava/lang/String;)V", "getMonitoringLevel", "()Lcom/checkout/eventlogger/domain/model/MonitoringLevel;", "getProperties", "()Ljava/util/Map;", "getTime", "()Ljava/util/Date;", "getTypeIdentifier", "()Ljava/lang/String;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "Risk_release"})
    private static final class LoggingEvent
    implements Event {
        @NotNull
        private final MonitoringLevel monitoringLevel;
        @NotNull
        private final Map<String, Object> properties;
        @NotNull
        private final Date time;
        @NotNull
        private final String typeIdentifier;

        public LoggingEvent(@NotNull MonitoringLevel monitoringLevel, @NotNull Map<String, ? extends Object> properties, @NotNull Date time, @NotNull String typeIdentifier) {
            Intrinsics.checkNotNullParameter((Object)monitoringLevel, (String)"monitoringLevel");
            Intrinsics.checkNotNullParameter(properties, (String)"properties");
            Intrinsics.checkNotNullParameter((Object)time, (String)"time");
            Intrinsics.checkNotNullParameter((Object)typeIdentifier, (String)"typeIdentifier");
            this.monitoringLevel = monitoringLevel;
            this.properties = properties;
            this.time = time;
            this.typeIdentifier = typeIdentifier;
        }

        public /* synthetic */ LoggingEvent(MonitoringLevel monitoringLevel, Map map, Date date, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                map = MapsKt.emptyMap();
            }
            if ((n & 4) != 0) {
                date = new Date();
            }
            this(monitoringLevel, map, date, string);
        }

        @NotNull
        public MonitoringLevel getMonitoringLevel() {
            return this.monitoringLevel;
        }

        @NotNull
        public Map<String, Object> getProperties() {
            return this.properties;
        }

        @NotNull
        public Date getTime() {
            return this.time;
        }

        @NotNull
        public String getTypeIdentifier() {
            return this.typeIdentifier;
        }

        @NotNull
        public final MonitoringLevel component1() {
            return this.monitoringLevel;
        }

        @NotNull
        public final Map<String, Object> component2() {
            return this.properties;
        }

        @NotNull
        public final Date component3() {
            return this.time;
        }

        @NotNull
        public final String component4() {
            return this.typeIdentifier;
        }

        @NotNull
        public final LoggingEvent copy(@NotNull MonitoringLevel monitoringLevel, @NotNull Map<String, ? extends Object> properties, @NotNull Date time, @NotNull String typeIdentifier) {
            Intrinsics.checkNotNullParameter((Object)monitoringLevel, (String)"monitoringLevel");
            Intrinsics.checkNotNullParameter(properties, (String)"properties");
            Intrinsics.checkNotNullParameter((Object)time, (String)"time");
            Intrinsics.checkNotNullParameter((Object)typeIdentifier, (String)"typeIdentifier");
            return new LoggingEvent(monitoringLevel, properties, time, typeIdentifier);
        }

        public static /* synthetic */ LoggingEvent copy$default(LoggingEvent loggingEvent, MonitoringLevel monitoringLevel, Map map, Date date, String string, int n, Object object) {
            if ((n & 1) != 0) {
                monitoringLevel = loggingEvent.monitoringLevel;
            }
            if ((n & 2) != 0) {
                map = loggingEvent.properties;
            }
            if ((n & 4) != 0) {
                date = loggingEvent.time;
            }
            if ((n & 8) != 0) {
                string = loggingEvent.typeIdentifier;
            }
            return loggingEvent.copy(monitoringLevel, map, date, string);
        }

        @NotNull
        public String toString() {
            return "LoggingEvent(monitoringLevel=" + this.monitoringLevel + ", properties=" + this.properties + ", time=" + this.time + ", typeIdentifier=" + this.typeIdentifier + ')';
        }

        public int hashCode() {
            int result = this.monitoringLevel.hashCode();
            result = result * 31 + ((Object)this.properties).hashCode();
            result = result * 31 + this.time.hashCode();
            result = result * 31 + this.typeIdentifier.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof LoggingEvent)) {
                return false;
            }
            LoggingEvent loggingEvent = (LoggingEvent)other;
            if (this.monitoringLevel != loggingEvent.monitoringLevel) {
                return false;
            }
            if (!Intrinsics.areEqual(this.properties, loggingEvent.properties)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.time, (Object)loggingEvent.time)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.typeIdentifier, (Object)loggingEvent.typeIdentifier);
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[RiskEnvironment.values().length];
            try {
                nArray[RiskEnvironment.QA.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RiskEnvironment.SANDBOX.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RiskEnvironment.PRODUCTION.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[RiskEvent.values().length];
            try {
                nArray[RiskEvent.PUBLISHED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RiskEvent.COLLECTED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RiskEvent.PUBLISH_FAILURE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RiskEvent.LOAD_FAILURE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RiskEvent.PUBLISH_DISABLED.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

