/*
 * Decompiled with CFR 0.152.
 */
package com.cx.restclient;

import com.checkmarx.sdk.dto.Filter;
import com.checkmarx.sdk.dto.ast.ASTResultsWrapper;
import com.checkmarx.sdk.dto.ast.ScanParams;
import com.checkmarx.sdk.exception.ASTRuntimeException;
import com.checkmarx.sdk.service.AstClient;
import com.cx.restclient.CxClientDelegator;
import com.cx.restclient.ast.dto.common.ASTConfig;
import com.cx.restclient.ast.dto.common.RemoteRepositoryInfo;
import com.cx.restclient.ast.dto.common.SummaryResults;
import com.cx.restclient.configuration.CxScanConfig;
import com.cx.restclient.dto.ScanResults;
import com.cx.restclient.dto.SourceLocationType;
import java.io.File;
import java.net.MalformedURLException;
import java.util.EnumMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAstClient
implements AstClient {
    private static final Logger log = LoggerFactory.getLogger(AbstractAstClient.class);
    private static final int SCA_SCAN_INTERVAL_IN_SECONDS = 5;
    protected static final String ERROR_PREFIX = "Scan cannot be initiated.";

    @Override
    public ASTResultsWrapper scan(ScanParams scanParams) {
        this.validate(scanParams);
        CxScanConfig scanConfig = this.getScanConfig(scanParams);
        scanConfig.setOsaProgressInterval(Integer.valueOf(5));
        ScanResults scanResults = this.executeScan(scanConfig);
        ASTResultsWrapper scaResults = this.toResults(scanResults);
        this.applyFilterToResults(scaResults, scanParams);
        return scaResults;
    }

    protected abstract void applyFilterToResults(ASTResultsWrapper var1, ScanParams var2);

    protected abstract ASTResultsWrapper toResults(ScanResults var1);

    protected ScanResults executeScan(CxScanConfig cxScanConfig) {
        CxClientDelegator client;
        try {
            client = new CxClientDelegator(cxScanConfig, log);
        }
        catch (MalformedURLException e) {
            String message = String.format("Error creating %s instance.", CxClientDelegator.class.getSimpleName());
            throw new ASTRuntimeException(message, e);
        }
        client.init();
        client.initiateScan();
        return client.waitForScanResults();
    }

    protected Map<Filter.Severity, Integer> getFindingCountMap(SummaryResults summary) {
        EnumMap<Filter.Severity, Integer> result = new EnumMap<Filter.Severity, Integer>(Filter.Severity.class);
        result.put(Filter.Severity.HIGH, summary.getHighVulnerabilityCount());
        result.put(Filter.Severity.MEDIUM, summary.getMediumVulnerabilityCount());
        result.put(Filter.Severity.LOW, summary.getLowVulnerabilityCount());
        return result;
    }

    protected void validateNotEmpty(String parameter, String parameterDescr) {
        if (StringUtils.isEmpty((CharSequence)parameter)) {
            String message = String.format("%s %s wasn't provided", ERROR_PREFIX, parameterDescr);
            throw new ASTRuntimeException(message);
        }
    }

    protected static void setSourceLocation(ScanParams scanParams, CxScanConfig scanConfig, ASTConfig astConfig) {
        if (AbstractAstClient.localSourcesAreSpecified(scanParams)) {
            astConfig.setSourceLocationType(SourceLocationType.LOCAL_DIRECTORY);
            if (StringUtils.isNotEmpty((CharSequence)scanParams.getZipPath())) {
                log.debug("Using a local zip file for scanning.");
                scanConfig.setZipFile(new File(scanParams.getZipPath()));
            } else {
                log.debug("Using a local directory for scanning.");
                scanConfig.setSourceDir(scanParams.getSourceDir());
            }
        } else {
            astConfig.setSourceLocationType(SourceLocationType.REMOTE_REPOSITORY);
            RemoteRepositoryInfo remoteRepoInfo = new RemoteRepositoryInfo();
            remoteRepoInfo.setUrl(scanParams.getRemoteRepoUrl());
            astConfig.setRemoteRepositoryInfo(remoteRepoInfo);
        }
    }

    protected static boolean localSourcesAreSpecified(ScanParams scanParams) {
        return !StringUtils.isAllEmpty((CharSequence[])new CharSequence[]{scanParams.getZipPath(), scanParams.getSourceDir()});
    }

    protected abstract CxScanConfig getScanConfig(ScanParams var1);

    protected abstract void validate(ScanParams var1);
}

