/*
 * Decompiled with CFR 0.152.
 */
package com.checkmarx.sdk.ShardManager;

import com.checkmarx.sdk.ShardManager.ShardManagerHTTPInterceptor;
import com.checkmarx.sdk.ShardManager.ShardSessionTracker;
import com.checkmarx.sdk.config.CxProperties;
import com.checkmarx.sdk.config.ShardProperties;
import groovy.lang.Binding;
import groovy.lang.GroovyRuntimeException;
import groovy.util.GroovyScriptEngine;
import groovy.util.ResourceException;
import groovy.util.ScriptException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.client.RestTemplate;

@Configuration
public class ShardManagerInterceptorConfig {
    private static final Logger log = LoggerFactory.getLogger(ShardManagerHTTPInterceptor.class);
    private CxProperties cxProperties;
    private ShardProperties shardProperties;
    private ShardSessionTracker sessionTracker;

    public ShardManagerInterceptorConfig(ShardProperties shardProperties, CxProperties cxProperties, ShardSessionTracker sessionTracker) {
        this.shardProperties = shardProperties;
        this.cxProperties = cxProperties;
        this.sessionTracker = sessionTracker;
    }

    @Bean
    public RestTemplate restTemplate(@Qualifier(value="cxRestTemplate") RestTemplate restTemplate, ShardProperties shardProperties) {
        if (this.cxProperties.getEnableShardManager()) {
            this.loadShardSettings();
            ArrayList<ShardManagerHTTPInterceptor> interceptors = restTemplate.getInterceptors();
            if (CollectionUtils.isEmpty((Collection)interceptors)) {
                interceptors = new ArrayList<ShardManagerHTTPInterceptor>();
            }
            interceptors.add(new ShardManagerHTTPInterceptor(shardProperties, this.sessionTracker));
            restTemplate.setInterceptors(interceptors);
        }
        return restTemplate;
    }

    public String loadShardSettings() {
        Binding binding = new Binding();
        binding.setProperty("shardProperties", (Object)this.shardProperties);
        binding.setProperty("cxFlowLog", (Object)log);
        try {
            String scriptName = this.shardProperties.getScriptSetup();
            String scriptDir = this.shardProperties.getScriptPath();
            String[] roots = new String[]{scriptDir};
            GroovyScriptEngine gse = new GroovyScriptEngine(roots);
            gse.run(scriptName, binding);
            return (String)binding.getVariable("output");
        }
        catch (GroovyRuntimeException | ResourceException | ScriptException | IOException e) {
            log.error("Error occurred while executing Shard Manager Setup, returning null - {}", (Object)ExceptionUtils.getMessage((Throwable)e), (Object)e);
            return null;
        }
    }
}

