package com.chartbeat.androidsdk;

import android.content.Context;
import android.graphics.Point;

/**
 * Created by Mike Dai Wang on 2016-02-04.
 */
final class AppInfo {
    private static final String TAG = AppInfo.class.getSimpleName();
    private static final int ANDROID_SDK_VERSION_BASE = 2000;

    private static String packageName;
    private static int deviceScreenWidth = -1;

    private String accountID;
    private String domain;

    AppInfo(Context context, String accountID, String domain) {
        if (accountID == null) {
            throw new NullPointerException("Account ID cannot be null");
        }

        this.accountID = accountID;

        try {
            if (packageName == null) {
                packageName = context.getPackageName();
            }
        } catch (Exception e) {
            AwsLogger.getInstance().logError(e);
        }

        if (domain == null) {
            throw new NullPointerException("Domain cannot be null");
        } else {
            this.domain = domain;
        }

        try {
            if (deviceScreenWidth == -1) {
                Point size = SystemUtils.getScreenSize(context);
                deviceScreenWidth = size.x;
            }
        } catch (Exception e) {
            AwsLogger.getInstance().logError(e);
        }
    }

    public String toString() {
        return "Chartbeat tracking SDK (" + getSdkVersion() + "): " + getAccountID() + "|" + getPackageName() + "|" + getDomain();
    }

    String getDomain() {
        return domain;
    }

    String getPackageName() {
        return packageName;
    }

    String getAccountID() {
        return accountID;
    }

    String getSdkVersion() {
        return String.valueOf(ANDROID_SDK_VERSION_BASE + BuildConfig.VERSION_CODE);
    }

    String getDeviceScreenWidth() {
        return String.valueOf(deviceScreenWidth);
    }
}
