/*
 * Decompiled with CFR 0.152.
 */
package mmcalendar;

import mmcalendar.CalendarType;
import mmcalendar.Config;
import mmcalendar.WesternDate;

public final class WesternDateKernel {
    public static WesternDate j2w(double juliandate, CalendarType calendarType) {
        return WesternDateKernel.j2w(juliandate, calendarType.getNumber(), 0.0);
    }

    public static WesternDate j2w(double jd, int calType, double SG) {
        double y;
        double d;
        double m;
        double jf;
        calType = calType < 0 ? 0 : calType;
        double d2 = SG = SG <= 0.0 ? 2361222.0 : SG;
        if (calType == 2 || calType == 0 && jd < SG) {
            double j = Math.floor(jd + 0.5);
            jf = jd + 0.5 - j;
            double b = j + 1524.0;
            double c = Math.floor((b - 122.1) / 365.25);
            double f = Math.floor(365.25 * c);
            double e = Math.floor((b - f) / 30.6001);
            m = e > 13.0 ? e - 13.0 : e - 1.0;
            d = b - f - Math.floor(30.6001 * e);
            y = m < 3.0 ? c - 4715.0 : c - 4716.0;
        } else {
            double j = Math.floor(jd + 0.5);
            jf = jd + 0.5 - j;
            y = Math.floor((4.0 * (j -= 1721119.0) - 1.0) / 146097.0);
            j = 4.0 * j - 1.0 - 146097.0 * y;
            d = Math.floor(j / 4.0);
            j = Math.floor((4.0 * d + 3.0) / 1461.0);
            d = 4.0 * d + 3.0 - 1461.0 * j;
            d = Math.floor((d + 4.0) / 4.0);
            m = Math.floor((5.0 * d - 3.0) / 153.0);
            d = 5.0 * d - 3.0 - 153.0 * m;
            d = Math.floor((d + 5.0) / 5.0);
            y = 100.0 * y + j;
            if (m < 10.0) {
                m += 3.0;
            } else {
                m -= 9.0;
                y += 1.0;
            }
        }
        double h = Math.floor(jf *= 24.0);
        jf = (jf - h) * 60.0;
        double n = Math.floor(jf);
        double s = Math.round((jf - n) * 60.0);
        return new WesternDate((int)y, (int)m, (int)d, (int)h, (int)n, (int)s);
    }

    public static double w2j(int year, int month, int day, int calType, double SG) {
        calType = calType < 0 ? 0 : calType;
        SG = SG <= 0.0 ? 2361222.0 : SG;
        int a = (int)Math.floor((double)(14 - month) / 12.0);
        year = year + 4800 - a;
        month = month + 12 * a - 3;
        double jd = (double)day + Math.floor((double)(153 * month + 2) / 5.0) + (double)(365 * year) + Math.floor((double)year / 4.0);
        if (calType == 1) {
            jd = jd - Math.floor(year / 100) + Math.floor(year / 400) - 32045.0;
        } else if (calType == 2) {
            jd -= 32083.0;
        } else if ((jd = jd - Math.floor(year / 100) + Math.floor(year / 400) - 32045.0) < SG && (jd = (double)day + Math.floor((153 * month + 2) / 5) + (double)(365 * year) + Math.floor(year / 4) - 32083.0) > SG) {
            jd = SG;
        }
        return jd;
    }

    public static double w2j(int year, int month, int day, CalendarType calendarType, double SG) {
        return WesternDateKernel.w2j(year, month, day, calendarType.getNumber(), SG);
    }

    public static double w2j(int year, int month, int day, int hour, int minute, int second, CalendarType calendarType, double SG) {
        double fractionOfDay = WesternDateKernel.t2d(hour, minute, second);
        return WesternDateKernel.w2j(year, month, day, calendarType.getNumber(), SG) + fractionOfDay;
    }

    public static double t2d(double h, double n, double s) {
        return (h - 12.0) / 24.0 + n / 1440.0 + s / 86400.0;
    }

    public static double w2j(WesternDate westernDate, CalendarType calendarType, double SG) {
        return WesternDateKernel.w2j(westernDate.getYear(), westernDate.getMonth(), westernDate.getDay(), westernDate.getHour(), westernDate.getMinute(), westernDate.getSecond(), calendarType, SG);
    }

    public static int getJulianDayNumbeOstartOfMonth(int year, int month) {
        return (int)WesternDateKernel.w2j(year, month, 1, Config.get().getCalendarType().getNumber(), 0.0);
    }

    public static int getLengthOfMonth(int year, int month, int calenderType) {
        int leap = 0;
        int mLen = (int)(30.0 + ((double)month + Math.floor((double)month / 8.0)) % 2.0);
        if (month == 2) {
            if (calenderType == 1 || calenderType == 0 && year > 1752) {
                if (year % 4 == 0 && year % 100 != 0 || year % 400 == 0) {
                    leap = 1;
                }
            } else if (year % 4 == 0) {
                leap = 1;
            }
            mLen += leap - 2;
        }
        if (year == 1752 && month == 9 && calenderType == 0) {
            mLen = 19;
        }
        return mLen;
    }

    public static int getJulianDayNumberOfEndOfMonth(int year, int month) {
        int js = WesternDateKernel.getJulianDayNumbeOstartOfMonth(year, month);
        int eml = WesternDateKernel.getLengthOfMonth(year, month, Config.get().getCalendarType().getNumber());
        return js + eml - 1;
    }
}

