/*
 * Decompiled with CFR 0.152.
 */
package mmcalendar;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import mmcalendar.BinarySearchUtil;
import mmcalendar.Era;
import mmcalendar.MyanmarDate;
import mmcalendar.MyanmarMonths;

public final class MyanmarDateKernel {
    static final String[] EMA = new String[]{"First Waso", "Tagu", "Kason", "Nayon", "Waso", "Wagaung", "Tawthalin", "Thadingyut", "Tazaungmon", "Nadaw", "Pyatho", "Tabodwe", "Tabaung", "Late Tagu", "Late Kason"};

    private MyanmarDateKernel() {
    }

    public static MyanmarDate j2m(double jd) {
        double jdn = Math.round(jd);
        double myear = Math.floor((jdn - 0.5 - 1954168.050623) / 365.2587564814815);
        Map<String, Double> yo = MyanmarDateKernel.chk_my(myear);
        double dd = jdn - yo.get("tg1") + 1.0;
        double b = Math.floor(yo.get("myt") / 2.0);
        double c = Math.floor(1.0 / (yo.get("myt") + 1.0));
        double yearLength = 354.0 + (1.0 - c) * 30.0 + b;
        double monthType = Math.floor((dd - 1.0) / yearLength);
        double a = Math.floor(((dd -= monthType * yearLength) + 423.0) / 512.0);
        double mmonth = Math.floor((dd - b * a + c * a * 30.0 + 29.26) / 29.544);
        double e = Math.floor((mmonth + 12.0) / 16.0);
        double f = Math.floor((mmonth + 11.0) / 16.0);
        double monthDay = dd - Math.floor(29.544 * mmonth - 29.26) - b * e + c * f * 30.0;
        double monthLength = 30.0 - (mmonth += f * 3.0 - e * 4.0) % 2.0;
        if (mmonth == 3.0) {
            monthLength += b;
        }
        double moonPhase = Math.floor((monthDay + 1.0) / 16.0) + Math.floor(monthDay / 16.0) + Math.floor(monthDay / monthLength);
        double fortnightDay = monthDay - 15.0 * Math.floor(monthDay / 16.0);
        double weekDay = (jdn + 2.0) % 7.0;
        MyanmarDate myanmarDate = new MyanmarDate();
        myanmarDate.myear = (int)myear;
        myanmarDate.yearType = yo.get("myt").intValue();
        myanmarDate.yearLength = (int)yearLength;
        myanmarDate.mmonth = (int)mmonth;
        myanmarDate.monthType = (int)monthType;
        myanmarDate.monthLength = (int)monthLength;
        myanmarDate.monthDay = (int)monthDay;
        myanmarDate.moonPhase = (int)moonPhase;
        myanmarDate.fortnightDay = (int)fortnightDay;
        myanmarDate.weekDay = (int)weekDay;
        myanmarDate.jd = jd;
        return myanmarDate;
    }

    public static Map<String, Double> chk_my(double myear) {
        Map<String, Double> y1;
        int yd = 0;
        double nd = 0.0;
        double werr = 0.0;
        double fm = 0.0;
        Map<String, Double> y2 = MyanmarDateKernel.chk_watat(myear);
        double myt = y2.get("watat");
        while ((y1 = MyanmarDateKernel.chk_watat(myear - (double)(++yd))).get("watat") == 0.0 && yd < 3) {
        }
        if (myt > 0.0) {
            nd = (y2.get("fm") - y1.get("fm")) % 354.0;
            myt = Math.floor(nd / 31.0) + 1.0;
            fm = y2.get("fm");
            if (nd != 30.0 && nd != 31.0) {
                werr = 1.0;
            }
        } else {
            fm = y1.get("fm") + (double)(354 * yd);
        }
        double tg1 = y1.get("fm") + (double)(354 * yd) - 102.0;
        HashMap<String, Double> map = new HashMap<String, Double>();
        map.put("myt", myt);
        map.put("tg1", tg1);
        map.put("fm", fm);
        map.put("werr", werr);
        return map;
    }

    private static Map<String, Double> chk_watat(double myear) {
        int i = Era.G_ERAS.size() - 1;
        while (i > 0) {
            if (myear > (double)Era.G_ERAS.get((int)i).begin) break;
            --i;
        }
        Era era = Era.G_ERAS.get(i);
        int NM = era.NM;
        double WO = era.WO;
        double TA = 0.9076417607184055 * (double)(12 - NM);
        double ed = 365.2587564814815 * (myear + 3739.0) % 29.53058794607172;
        if (ed < TA) {
            ed += 29.53058794607172;
        }
        double fm = Math.round(365.2587564814815 * myear + 1954168.050623 - ed + 132.88764575732273 + WO);
        double TW = 0.0;
        double watat = 0.0;
        if (era.eid >= 2.0) {
            TW = 29.53058794607172 - 0.9076417607184055 * (double)NM;
            if (ed >= TW) {
                watat = 1.0;
            }
        } else {
            watat = (myear * 7.0 + 2.0) % 19.0;
            if (watat < 0.0) {
                watat += 19.0;
            }
            watat = Math.floor(watat / 12.0);
        }
        if ((i = BinarySearchUtil.search(myear, era.wte)) >= 0) {
            watat = era.wte[i][1];
        }
        if (watat > 0.0 && (i = BinarySearchUtil.search(myear, era.fme)) >= 0) {
            fm += (double)era.fme[i][1];
        }
        HashMap<String, Double> map = new HashMap<String, Double>();
        map.put("fm", fm);
        map.put("watat", watat);
        return map;
    }

    public static double m2j(MyanmarDate myanmarDate) {
        return MyanmarDateKernel.m2j(myanmarDate.myear, myanmarDate.mmonth, myanmarDate.monthType, myanmarDate.moonPhase, myanmarDate.fortnightDay);
    }

    public static double m2j(double myear, double mmonth, double monthType, double moonPhase, double fortnightDay) {
        Map<String, Double> yo = MyanmarDateKernel.chk_my(myear);
        double b = Math.floor(yo.get("myt") / 2.0);
        double c = yo.get("myt") == 0.0 ? 1 : 0;
        double mml = 30.0 - mmonth % 2.0;
        if (mmonth == 3.0) {
            mml += b;
        }
        double m1 = moonPhase % 2.0;
        double m2 = Math.floor(moonPhase / 2.0);
        double md = m1 * (15.0 + m2 * (mml - 15.0)) + (1.0 - m1) * (fortnightDay + 15.0 * m2);
        mmonth += 4.0 - Math.floor((mmonth + 15.0) / 16.0) * 4.0 + Math.floor((mmonth + 12.0) / 16.0);
        double dd = md + Math.floor(29.544 * mmonth - 29.26) - c * Math.floor((mmonth + 11.0) / 16.0) * 30.0 + b * Math.floor((mmonth + 12.0) / 16.0);
        double myl = 354.0 + (1.0 - c) * 30.0 + b;
        return (dd += monthType * myl) + yo.get("tg1") - 1.0;
    }

    public static double m2j(double myear, double mmonth, double mmday) {
        double monthType = Math.floor(mmonth / 13.0);
        double month = mmonth > 12.0 ? mmonth - 12.0 : mmonth;
        return MyanmarDateKernel.m2j(myear, month, monthType, 0.0, mmday);
    }

    static double time2DayFraction(double hour, double minute, double second) {
        return (hour - 12.0) / 24.0 + minute / 1440.0 + second / 86400.0;
    }

    public static MyanmarMonths getMyanmarMonth(int myear, int mmonth) {
        double j1 = Math.round(365.2587564814815 * (double)myear + 1954168.050623) + 1L;
        double j2 = Math.round(365.2587564814815 * (double)(myear + 1) + 1954168.050623);
        MyanmarDate M1 = MyanmarDateKernel.j2m(j1);
        MyanmarDate M2 = MyanmarDateKernel.j2m(j2);
        int si = M1.mmonth + 12 * M1.monthType;
        int ei = M2.mmonth + 12 * M2.monthType;
        if (si == 0) {
            si = 4;
        }
        if (mmonth == 0 && M1.yearType == 0) {
            mmonth = 4;
        }
        if (mmonth != 0 && mmonth < si) {
            mmonth = si;
        }
        if (mmonth > ei) {
            mmonth = ei;
        }
        ArrayList<Integer> index = new ArrayList<Integer>();
        ArrayList<String> monthNameList = new ArrayList<String>();
        int currentIndex = 0;
        int i = si;
        while (i <= ei) {
            if (i == 4 && M1.yearType != 0) {
                index.add(0);
                monthNameList.add(EMA[0]);
                if (mmonth == 0) {
                    currentIndex = 0;
                }
            }
            index.add(i);
            monthNameList.add(String.valueOf(i == 4 && M1.yearType != 0 ? "Second " : "") + EMA[i]);
            if (i == mmonth) {
                currentIndex = i;
            }
            ++i;
        }
        return new MyanmarMonths(index, monthNameList, currentIndex);
    }
}

