/*
 * Decompiled with CFR 0.152.
 */
package mmcalendar;

import java.util.Calendar;
import mmcalendar.CalendarType;
import mmcalendar.Config;
import mmcalendar.MyanmarDate;
import mmcalendar.MyanmarDateKernel;
import mmcalendar.WesternDateKernel;

public class MyanmarDateConverter {
    public static MyanmarDate convert(Calendar calendar) {
        return MyanmarDateConverter.convert(calendar.get(1), calendar.get(2) + 1, calendar.get(5), Config.get().getCalendarType(), 0.0);
    }

    public static MyanmarDate convert(int year, int month, int day) {
        return MyanmarDateConverter.convert(year, month, day, Config.get().getCalendarType(), 0.0);
    }

    public static MyanmarDate convert(int year, int month, int day, CalendarType calendarType, double SG) {
        double julianDayNumber = WesternDateKernel.w2j(year, month, day, calendarType, SG);
        return MyanmarDateConverter.convert(julianDayNumber);
    }

    public static MyanmarDate convert(int year, int month, int day, int hour, int minute, int second) {
        return MyanmarDateConverter.convert(year, month, day, hour, minute, second, Config.get().getCalendarType(), 0.0);
    }

    public static MyanmarDate convert(int year, int month, int day, int hour, int minute, int second, CalendarType calendarType, double SG) {
        double julianDayNumber = WesternDateKernel.w2j(year, month, day, hour, minute, second, calendarType, SG);
        return MyanmarDateConverter.convert(julianDayNumber);
    }

    public static MyanmarDate convert(double julianDayNumber) {
        return MyanmarDateKernel.j2m(julianDayNumber);
    }
}

