/*
 * Decompiled with CFR 0.152.
 */
package mmcalendar;

import java.io.Serializable;
import mmcalendar.LanguageCatalog;
import mmcalendar.NumberToStringUtil;

public class MyanmarDate
implements Serializable,
Cloneable,
Comparable<MyanmarDate> {
    private static final long serialVersionUID = 1L;
    static final String[] MMA = new String[]{"First Waso", "Tagu", "Kason", "Nayon", "Waso", "Wagaung", "Tawthalin", "Thadingyut", "Tazaungmon", "Nadaw", "Pyatho", "Tabodwe", "Tabaung"};
    static final String[] MSA = new String[]{"waxing", "full moon", "waning", "new moon"};
    static final String[] WDA = new String[]{"Saturday", "Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday"};
    int myear;
    int yearType;
    int yearLength;
    int mmonth;
    int monthType;
    int monthLength;
    int monthDay;
    int fortnightDay;
    int moonPhase;
    int weekDay;
    double jd;

    protected MyanmarDate() {
    }

    public MyanmarDate(int myear, int mmonth, int mmt, int fd, int moonPhase) {
        if (myear < 0) {
            throw new IllegalArgumentException("Myanmar year must be positive number");
        }
        if (mmonth < 0 || mmonth > 13) {
            throw new IllegalArgumentException("Month must be 0 to 12");
        }
        if (mmt < 0 || mmt > 1) {
            throw new IllegalArgumentException("Month type must be 0 to 1");
        }
        if (fd < 1 || fd > 15) {
            throw new IllegalArgumentException("Fortnight day must be 0 to 15");
        }
        if (moonPhase < 0 || moonPhase > 3) {
            throw new IllegalArgumentException("Moon phase must be 0 to 3");
        }
        this.myear = myear;
        this.mmonth = mmonth;
        this.monthType = mmt;
        this.fortnightDay = fd;
        this.moonPhase = moonPhase;
    }

    public String getBuddhistEra(LanguageCatalog languageCatalog) {
        return NumberToStringUtil.convert(this.myear + 1182, languageCatalog);
    }

    public String getBuddhistEra() {
        return this.getBuddhistEra(new LanguageCatalog());
    }

    public String getYear(LanguageCatalog languageCatalog) {
        return NumberToStringUtil.convert(this.myear, languageCatalog);
    }

    public String getYear() {
        return this.getYear(new LanguageCatalog());
    }

    public int getYearInt() {
        return this.myear;
    }

    public int getYearType() {
        return this.yearType;
    }

    public String getMnt() {
        return this.getMnt(LanguageCatalog.getInstance());
    }

    public String getMnt(LanguageCatalog languageCatalog) {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.monthType > 0) {
            stringBuilder.append(languageCatalog.translate("Late"));
        }
        if (this.yearType > 0 && this.mmonth == 4) {
            stringBuilder.append(languageCatalog.translate("Second"));
        }
        return stringBuilder.toString();
    }

    public int getYearLength() {
        return this.yearLength;
    }

    public String getMonthName() {
        return this.getMonthName(LanguageCatalog.getInstance());
    }

    public String getMonthName(LanguageCatalog languageCatalog) {
        return String.valueOf(this.getMnt()) + languageCatalog.translate(MMA[this.mmonth]);
    }

    public int getMonth() {
        return this.mmonth;
    }

    public int getMoonPhraseInt() {
        return this.moonPhase;
    }

    public String getMoonPhase() {
        return this.getMoonPhase(LanguageCatalog.getInstance());
    }

    public String getMoonPhase(LanguageCatalog languageCatalog) {
        return languageCatalog.translate(MSA[this.moonPhase]);
    }

    public int getMonthLength() {
        return this.monthLength;
    }

    public int getMonthDay() {
        return this.monthDay;
    }

    public int getMonthType() {
        return this.monthType;
    }

    public int getFortnightDayInt() {
        return this.fortnightDay;
    }

    public String getFortnightDay() {
        return this.getFortnightDay(LanguageCatalog.getInstance());
    }

    public String getFortnightDay(LanguageCatalog languageCatalog) {
        return this.moonPhase % 2 == 0 ? NumberToStringUtil.convert(this.fortnightDay, languageCatalog) : "";
    }

    public int getWeekDayInt() {
        return this.weekDay;
    }

    public String getWeekDay() {
        return this.getWeekDay(LanguageCatalog.getInstance());
    }

    public String getWeekDay(LanguageCatalog languageCatalog) {
        return languageCatalog.translate(WDA[this.weekDay]);
    }

    public double getJulianDayNumber() {
        return this.jd;
    }

    public int getMoonPhrase() {
        return this.moonPhase;
    }

    public boolean isWeekend() {
        return this.weekDay == 0 || this.weekDay == 1;
    }

    public String format(String pattern) {
        return this.format(pattern, LanguageCatalog.getInstance());
    }

    public String format(String pattern, LanguageCatalog languageCatalog) {
        if (pattern == null || languageCatalog == null) {
            throw new NullPointerException();
        }
        char[] charArray = pattern.toCharArray();
        StringBuilder stringBuilder = new StringBuilder();
        int index = 0;
        while (index < charArray.length) {
            switch (charArray[index]) {
                case 'S': {
                    stringBuilder.append(languageCatalog.translate("Sasana Year"));
                    break;
                }
                case 's': {
                    stringBuilder.append(this.getBuddhistEra(languageCatalog));
                    break;
                }
                case 'B': {
                    stringBuilder.append(languageCatalog.translate("Myanmar Year"));
                    break;
                }
                case 'y': {
                    stringBuilder.append(this.getYear(languageCatalog));
                    break;
                }
                case 'k': {
                    stringBuilder.append(languageCatalog.translate("Ku"));
                    break;
                }
                case 'M': {
                    stringBuilder.append(this.getMonthName(languageCatalog));
                    break;
                }
                case 'p': {
                    stringBuilder.append(this.getMoonPhase(languageCatalog));
                    break;
                }
                case 'f': {
                    stringBuilder.append(this.getFortnightDay(languageCatalog));
                    break;
                }
                case 'E': {
                    stringBuilder.append(this.getWeekDay(languageCatalog));
                    break;
                }
                case 'n': {
                    stringBuilder.append(languageCatalog.translate("Nay"));
                    break;
                }
                case 'r': {
                    stringBuilder.append(languageCatalog.translate("Yat"));
                    break;
                }
                default: {
                    stringBuilder.append(charArray[index]);
                }
            }
            ++index;
        }
        return stringBuilder.toString();
    }

    public String toString() {
        LanguageCatalog languageCatalog = LanguageCatalog.getInstance();
        return this.toString(languageCatalog);
    }

    public String toString(LanguageCatalog languageCatalog) {
        return this.format("S s k, B y k, M p f r En", languageCatalog);
    }

    @Override
    public int compareTo(MyanmarDate anotherMyanmarDate) {
        return Double.compare(this.jd, anotherMyanmarDate.jd);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.fortnightDay;
        long temp = Double.doubleToLongBits(this.jd);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + this.mmonth;
        result = 31 * result + this.monthDay;
        result = 31 * result + this.monthLength;
        result = 31 * result + this.monthType;
        result = 31 * result + this.moonPhase;
        result = 31 * result + this.myear;
        result = 31 * result + this.weekDay;
        result = 31 * result + this.yearLength;
        result = 31 * result + this.yearType;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MyanmarDate other = (MyanmarDate)obj;
        if (this.fortnightDay != other.fortnightDay) {
            return false;
        }
        if (Double.doubleToLongBits(this.jd) != Double.doubleToLongBits(other.jd)) {
            return false;
        }
        if (this.mmonth != other.mmonth) {
            return false;
        }
        if (this.monthDay != other.monthDay) {
            return false;
        }
        if (this.monthLength != other.monthLength) {
            return false;
        }
        if (this.monthType != other.monthType) {
            return false;
        }
        if (this.moonPhase != other.moonPhase) {
            return false;
        }
        if (this.myear != other.myear) {
            return false;
        }
        if (this.weekDay != other.weekDay) {
            return false;
        }
        if (this.yearLength != other.yearLength) {
            return false;
        }
        return this.yearType == other.yearType;
    }
}

