/*
 * Decompiled with CFR 0.152.
 */
package mmcalendar;

import java.util.ArrayList;
import java.util.List;
import mmcalendar.BinarySearchUtil;
import mmcalendar.CalendarType;
import mmcalendar.Config;
import mmcalendar.MyanmarDate;
import mmcalendar.WesternDate;
import mmcalendar.WesternDateConverter;
import mmcalendar.WesternDateKernel;

public final class HolidayCalculator {
    private static final int[] ghEid2 = new int[]{2456936, 2457290, 2457644, 2457998, 2458353};
    private static final int[] ghCNY = new int[]{2456689, 2456690, 2457073, 2457074, 2457427, 2457428, 2457782, 2457783, 2458166, 2458167};
    private static final int[] ghDiwali = new int[]{2456599, 2456953, 2457337, 2457691, 2458045, 2458429};
    private static final int[] ghEid = new int[]{2456513, 2456867, 2457221, 2457576, 2457930, 2458285};

    private HolidayCalculator() {
    }

    static List<String> englishHoliday(int gy, int gm, int gd) {
        ArrayList<String> holiday = new ArrayList<String>();
        if (gy >= 2018 && gm == 1 && gd == 1) {
            holiday.add("New Year Day");
        } else if (gy >= 1948 && gm == 1 && gd == 4) {
            holiday.add("Independence Day");
        } else if (gy >= 1947 && gm == 2 && gd == 12) {
            holiday.add("Union Day");
        } else if (gy >= 1958 && gm == 3 && gd == 2) {
            holiday.add("Peasants Day");
        } else if (gy >= 1945 && gm == 3 && gd == 27) {
            holiday.add("Resistance Day");
        } else if (gy >= 1923 && gm == 5 && gd == 1) {
            holiday.add("Labour Day");
        } else if (gy >= 1947 && gm == 7 && gd == 19) {
            holiday.add("Martyrs Day");
        } else if (gm == 12 && gd == 25) {
            holiday.add("Christmas Day");
        } else if (gy == 2017 && gm == 12 && gd == 30) {
            holiday.add("Holiday");
        } else if (gy >= 2017 && gm == 12 && gd == 31) {
            holiday.add("Holiday");
        }
        return holiday;
    }

    static List<String> myanmarHoliday(double myear, int mmonth, int monthDay, int moonPhase) {
        ArrayList<String> holiday = new ArrayList<String>();
        if (mmonth == 2 && moonPhase == 1) {
            holiday.add("Buddha Day");
        } else if (mmonth == 4 && moonPhase == 1) {
            holiday.add("Start of Buddhist Lent");
        } else if (mmonth == 7 && moonPhase == 1) {
            holiday.add("End of Buddhist Lent");
        } else if (myear >= 1379.0 && mmonth == 7 && (monthDay == 14 || monthDay == 16)) {
            holiday.add("Holiday");
        } else if (mmonth == 8 && moonPhase == 1) {
            holiday.add("Tazaungdaing");
        } else if (myear >= 1379.0 && mmonth == 8 && monthDay == 14) {
            holiday.add("Holiday");
        } else if (myear >= 1282.0 && mmonth == 8 && monthDay == 25) {
            holiday.add("National Day");
        } else if (mmonth == 10 && monthDay == 1) {
            holiday.add("Karen New Year Day");
        } else if (mmonth == 12 && moonPhase == 1) {
            holiday.add("Tabaung Pwe");
        }
        return holiday;
    }

    public static List<String> thingyan(double jdn, double myear, int monthType) {
        int BGNTG = 1100;
        ArrayList<String> holiday = new ArrayList<String>();
        int SE3 = 1312;
        double ja = 365.2587564814815 * (myear + (double)monthType) + 1954168.050623;
        double jk = myear >= (double)SE3 ? ja - 2.169918982 : ja - 2.1675;
        double akn = Math.round(jk);
        double atn = Math.round(ja);
        if (Math.abs(jdn - (atn + 1.0)) < 1.0E-7) {
            holiday.add("Myanmar New Year Day");
        }
        if (myear + (double)monthType >= (double)BGNTG) {
            if (jdn == atn) {
                holiday.add("Thingyan Atat");
            } else if (jdn > akn && jdn < atn) {
                holiday.add("Thingyan Akyat");
            } else if (jdn == akn) {
                holiday.add("Thingyan Akya");
            } else if (jdn == akn - 1.0) {
                holiday.add("Thingyan Akyo");
            } else if (myear + (double)monthType >= 1369.0 && myear + (double)monthType < 1379.0 && (jdn == akn - 2.0 || jdn >= atn + 2.0 && jdn <= akn + 7.0)) {
                holiday.add("Holiday");
            }
        }
        return holiday;
    }

    public static List<String> otherHolidays(double jd) {
        ArrayList<String> holiday = new ArrayList<String>();
        if (BinarySearchUtil.search(jd, ghDiwali) >= 0) {
            holiday.add("Diwali");
        }
        if (BinarySearchUtil.search(jd, ghEid) >= 0) {
            holiday.add("Eid");
        }
        return holiday;
    }

    public static List<String> ecd(double jd, CalendarType calendarType) {
        if (calendarType == null) {
            calendarType = CalendarType.ENGLISH;
        }
        ArrayList<String> holiday = new ArrayList<String>();
        WesternDate wd = WesternDateConverter.convert(jd, calendarType);
        double doe = HolidayCalculator.DoE(wd.getYear());
        if (wd.getYear() <= 2017 && wd.getMonth() == 1 && wd.getDay() == 1) {
            holiday.add("New Year Day");
        } else if (wd.getYear() >= 1915 && wd.getMonth() == 2 && wd.getDay() == 13) {
            holiday.add("G. Aung San BD");
        } else if (wd.getYear() >= 1969 && wd.getMonth() == 2 && wd.getDay() == 14) {
            holiday.add("Valentines Day");
        } else if (wd.getYear() >= 1970 && wd.getMonth() == 4 && wd.getDay() == 22) {
            holiday.add("Earth Day");
        } else if (wd.getYear() >= 1392 && wd.getMonth() == 4 && wd.getDay() == 1) {
            holiday.add("April Fools Day");
        } else if (wd.getYear() >= 1948 && wd.getMonth() == 5 && wd.getDay() == 8) {
            holiday.add("Red Cross Day");
        } else if (wd.getYear() >= 1994 && wd.getMonth() == 10 && wd.getDay() == 5) {
            holiday.add("World Teachers Day");
        } else if (wd.getYear() >= 1947 && wd.getMonth() == 10 && wd.getDay() == 24) {
            holiday.add("United Nations Day");
        } else if (wd.getYear() >= 1753 && wd.getMonth() == 10 && wd.getDay() == 31) {
            holiday.add("Halloween");
        }
        if (wd.getYear() >= 1876 && jd == doe) {
            holiday.add("Easter");
        } else if (wd.getYear() >= 1876 && jd == doe - 2.0) {
            holiday.add("Good Friday");
        } else if (BinarySearchUtil.search(jd, ghEid2) >= 0) {
            holiday.add("Eid");
        }
        if (BinarySearchUtil.search(jd, ghCNY) >= 0) {
            holiday.add("Chinese New Year");
        }
        return holiday;
    }

    private static double DoE(int year) {
        double a = year % 19;
        double b = Math.floor(year / 100);
        double c = year % 100;
        double d = Math.floor(b / 4.0);
        double e = b % 4.0;
        double f = Math.floor((b + 8.0) / 25.0);
        double g = Math.floor((b - f + 1.0) / 3.0);
        double h = (19.0 * a + b - d - g + 15.0) % 30.0;
        double i = Math.floor(c / 4.0);
        double k = c % 4.0;
        double l = (32.0 + 2.0 * e + 2.0 * i - h - k) % 7.0;
        double m = Math.floor((a + 11.0 * h + 22.0 * l) / 451.0);
        double q = h + l - 7.0 * m + 114.0;
        int day = (int)(q % 31.0 + 1.0);
        int month = (int)Math.floor(q / 31.0);
        return WesternDateKernel.w2j(year, month, day, 1, 0.0);
    }

    public static List<String> mcd(double myear, int mmonth, int monthDay, int moonPhase) {
        ArrayList<String> holiday = new ArrayList<String>();
        if (myear >= 1309.0 && mmonth == 11 && monthDay == 16) {
            holiday.add("Mon National Day");
        } else if (mmonth == 9 && monthDay == 1) {
            holiday.add("Shan New Year Day");
            if (myear >= 1306.0) {
                holiday.add("Authors Day");
            }
        } else if (mmonth == 3 && moonPhase == 1) {
            holiday.add("Mahathamaya Day");
        } else if (mmonth == 6 && moonPhase == 1) {
            holiday.add("Garudhamma Day");
        } else if (myear >= 1356.0 && mmonth == 10 && moonPhase == 1) {
            holiday.add("Mothers Day");
        } else if (myear >= 1370.0 && mmonth == 12 && moonPhase == 1) {
            holiday.add("Fathers Day");
        } else if (mmonth == 5 && moonPhase == 1) {
            holiday.add("Metta Day");
        } else if (mmonth == 5 && monthDay == 10) {
            holiday.add("Taungpyone Pwe");
        } else if (mmonth == 5 && monthDay == 23) {
            holiday.add("Yadanagu Pwe");
        }
        return holiday;
    }

    public static List<String> getHoliday(MyanmarDate myanmarDate) {
        return HolidayCalculator.getHoliday(myanmarDate, Config.get().getCalendarType());
    }

    public static List<String> getHoliday(MyanmarDate myanmarDate, CalendarType calendarType) {
        WesternDate westernDate = WesternDateConverter.convert(myanmarDate.jd, calendarType);
        List<String> hde = HolidayCalculator.englishHoliday(westernDate.getYear(), westernDate.getMonth(), westernDate.getDay());
        List<String> hdm = HolidayCalculator.myanmarHoliday(myanmarDate.myear, myanmarDate.mmonth, myanmarDate.monthDay, myanmarDate.moonPhase);
        List<String> hdt = HolidayCalculator.thingyan(myanmarDate.jd, myanmarDate.myear, myanmarDate.monthType);
        List<String> hdo = HolidayCalculator.otherHolidays(myanmarDate.jd);
        ArrayList<String> holiday = new ArrayList<String>();
        holiday.addAll(hde);
        holiday.addAll(hdm);
        holiday.addAll(hdt);
        holiday.addAll(hdo);
        return holiday;
    }

    public static boolean isHoliday(MyanmarDate myanmarDate) {
        return HolidayCalculator.getHoliday(myanmarDate).size() > 0;
    }

    public static boolean isHoliday(List<String> holidayList) {
        return holidayList.size() > 0;
    }

    public static List<String> getAnniversary(MyanmarDate myanmarDate) {
        return HolidayCalculator.getAnniversary(myanmarDate, Config.get().getCalendarType());
    }

    public static List<String> getAnniversary(MyanmarDate myanmarDate, CalendarType calendarType) {
        List<String> ecd = HolidayCalculator.ecd(myanmarDate.jd, calendarType);
        List<String> mcd = HolidayCalculator.mcd(myanmarDate.myear, myanmarDate.mmonth, myanmarDate.monthDay, myanmarDate.moonPhase);
        ArrayList<String> holiday = new ArrayList<String>();
        holiday.addAll(ecd);
        holiday.addAll(mcd);
        return holiday;
    }
}

