/*
 * Decompiled with CFR 0.152.
 */
package mmcalendar;

import java.util.Calendar;
import java.util.Date;
import mmcalendar.CalendarType;
import mmcalendar.Config;
import mmcalendar.MyanmarDate;
import mmcalendar.WesternDate;
import mmcalendar.WesternDateKernel;

public final class ConverterUtils {
    public static Calendar myanmarDateToCalendar(MyanmarDate myanmarDate) {
        return ConverterUtils.julianDateToCalendar(myanmarDate.getJulianDayNumber());
    }

    public static Calendar julianDateToCalendar(double juliandate) {
        return ConverterUtils.julianDateToCalendar(juliandate, Config.get().getCalendarType());
    }

    public static Calendar julianDateToCalendar(double juliandate, CalendarType calendarType) {
        WesternDate westernDate = WesternDateKernel.j2w(juliandate, calendarType.getNumber(), 0.0);
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(1, westernDate.getYear());
        calendar.set(2, westernDate.getMonth() - 1);
        calendar.set(5, westernDate.getDay());
        calendar.set(10, westernDate.getHour());
        calendar.set(12, westernDate.getMinute());
        calendar.set(13, westernDate.getSecond());
        return calendar;
    }

    public static Date myanmarDateToDate(MyanmarDate myanmarDate) {
        return ConverterUtils.julianDateToCalendar(myanmarDate.getJulianDayNumber()).getTime();
    }
}

