/*
 * Decompiled with CFR 0.152.
 */
package mmcalendar;

import mmcalendar.CalendarType;
import mmcalendar.Language;

public final class Config {
    public static final int BY = 640;
    public static final int EY = 2140;
    public static final int MBY = 2;
    public static final int MEY = 1500;
    public static final int LT = 1700;
    public static final int UT = 2018;
    public static final int MLT = 1062;
    public static final int MUT = 1379;
    public static final double SG = 2361222.0;
    public static final String SIMPLE_MYANMAR_DATE_FORMAT_PATTERN = "S s k, B y k, M p f r En";
    private CalendarType CALENDARTYPE = CalendarType.ENGLISH;
    private Language lANGUAGE = Language.MYANMAR;
    private static Config instance;

    public static void initDefault(Config config) {
        instance = config;
    }

    public static Config get() {
        if (instance == null) {
            instance = new Config(new Builder());
        }
        return instance;
    }

    private Config(Builder builder) {
        this.CALENDARTYPE = builder.getCalendarType();
        this.lANGUAGE = builder.getLanguage();
    }

    public CalendarType getCalendarType() {
        return this.CALENDARTYPE;
    }

    public Language getLanguage() {
        return this.lANGUAGE;
    }

    /* synthetic */ Config(Builder builder, Config config) {
        this(builder);
    }

    public static class Builder {
        private CalendarType calendarType = CalendarType.ENGLISH;
        private Language language = Language.MYANMAR;

        public CalendarType getCalendarType() {
            return this.calendarType;
        }

        public Builder setCalendarType(CalendarType calendarType) {
            this.calendarType = calendarType;
            return this;
        }

        public Language getLanguage() {
            return this.language;
        }

        public Builder setLanguage(Language language) {
            this.language = language;
            return this;
        }

        public Config build() {
            if (this.calendarType == null || this.language == null) {
                throw new IllegalArgumentException("CalendarType or Language cannot be null");
            }
            return new Config(this, null);
        }
    }
}

