/*
 * Decompiled with CFR 0.152.
 */
package cfml.parsing.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RuleContext;
import org.antlr.v4.runtime.misc.Utils;
import org.antlr.v4.runtime.tree.ErrorNode;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.antlr.v4.runtime.tree.Tree;
import org.antlr.v4.runtime.tree.Trees;

public class TreePrinterListener
implements ParseTreeListener {
    private final List<String> ruleNames;
    private final StringBuilder builder = new StringBuilder();
    Map<RuleContext, ArrayList<String>> stack = new HashMap<RuleContext, ArrayList<String>>();

    public TreePrinterListener(Parser parser) {
        this.ruleNames = Arrays.asList(parser.getRuleNames());
    }

    public TreePrinterListener(List<String> ruleNames) {
        this.ruleNames = ruleNames;
    }

    public void visitTerminal(TerminalNode node) {
        String text = Utils.escapeWhitespace((String)Trees.getNodeText((Tree)node, this.ruleNames), (boolean)false);
        if (text.startsWith(" ") || text.endsWith(" ")) {
            text = "'" + text + "'";
        }
        this.stack.get(node.getParent()).add(text);
    }

    public void visitErrorNode(ErrorNode node) {
        this.stack.get(node.getParent()).add(Utils.escapeWhitespace((String)Trees.getNodeText((Tree)node, this.ruleNames), (boolean)false));
    }

    public void enterEveryRule(ParserRuleContext ctx) {
        if (!this.stack.containsKey(ctx.parent)) {
            this.stack.put(ctx.parent, new ArrayList());
        }
        if (!this.stack.containsKey(ctx)) {
            this.stack.put((RuleContext)ctx, new ArrayList());
        }
        StringBuilder sb = new StringBuilder();
        int ruleIndex = ctx.getRuleIndex();
        String ruleName = ruleIndex >= 0 && ruleIndex < this.ruleNames.size() ? this.ruleNames.get(ruleIndex) : Integer.toString(ruleIndex);
        sb.append(ruleName);
        this.stack.get(ctx).add(sb.toString());
    }

    public void exitEveryRule(ParserRuleContext ctx) {
        boolean brackit;
        ArrayList<String> ruleStack = this.stack.remove(ctx);
        StringBuilder sb = new StringBuilder();
        boolean bl = brackit = ruleStack.size() > 1;
        if (brackit) {
            sb.append("(");
        }
        sb.append(ruleStack.get(0));
        for (int i = 1; i < ruleStack.size(); ++i) {
            sb.append(" ");
            sb.append(ruleStack.get(i));
        }
        if (brackit) {
            sb.append(")");
        }
        if (sb.length() < 80) {
            this.stack.get(ctx.parent).add(sb.toString());
        } else {
            sb.setLength(0);
            if (brackit) {
                sb.append("(");
            }
            if (!ruleStack.isEmpty()) {
                sb.append(ruleStack.remove(0)).append("\r\n");
            }
            while (!ruleStack.isEmpty()) {
                sb.append(TreePrinterListener.indent(ruleStack.remove(0))).append("\r\n");
            }
            if (brackit) {
                sb.append(")");
            }
            this.stack.get(ctx.parent).add(sb.toString());
        }
        if (ctx.parent == null) {
            this.builder.append(sb.toString());
        }
    }

    static String indent(String input) {
        return "  " + input.replaceAll("\r\n(.)", "\r\n  $1");
    }

    public String toString() {
        return this.builder.toString();
    }
}

