/*
 * Decompiled with CFR 0.152.
 */
package cfml.parsing.util;

import cfml.parsing.util.PoundSignFilterStreamException;
import java.io.CharArrayWriter;
import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;

public class PoundSignFilterStream
extends FilterReader {
    char[] buffer = null;
    int bufferAt;
    int nextChar;
    boolean temp = false;
    int added = 0;
    private boolean isClosed;

    public PoundSignFilterStream(Reader _in) throws IOException {
        super(_in);
        this.readChar();
    }

    @Override
    public synchronized int read() throws IOException {
        if (this.buffer == null) {
            int returnChar;
            if (this.nextChar == 47) {
                this.readChar();
                if (this.nextChar == 42) {
                    this.buffer = this.readComment();
                    this.bufferAt = 0;
                } else if (this.nextChar == 47) {
                    this.buffer = this.readLineComment();
                    this.bufferAt = 0;
                }
                returnChar = 47;
            } else if (this.nextChar == 34 || this.nextChar == 39) {
                this.buffer = this.readString(true);
                this.bufferAt = 1;
                returnChar = this.buffer[0];
                if (this.buffer.length == 1) {
                    this.buffer = null;
                }
            } else {
                returnChar = this.nextChar;
                this.readChar();
            }
            return returnChar;
        }
        char bufferChar = this.buffer[this.bufferAt];
        ++this.bufferAt;
        if (this.bufferAt >= this.buffer.length) {
            this.buffer = null;
        }
        return bufferChar;
    }

    @Override
    public synchronized int read(char[] cbuf, int off, int len) throws IOException {
        int offset = off;
        int actualLen = 0;
        int nextChar = -1;
        while (actualLen < len && (nextChar = this.read()) != -1) {
            cbuf[offset] = (char)nextChar;
            ++actualLen;
            ++offset;
        }
        if (nextChar == -1 && actualLen == 0) {
            return -1;
        }
        return actualLen;
    }

    private char[] readString(boolean _withinExpression) throws IOException {
        CharArrayWriter cout = new CharArrayWriter();
        int endMarker = this.nextChar;
        cout.write(endMarker);
        this.readChar();
        while (this.nextChar != -1) {
            if (this.nextChar == 35) {
                this.readChar();
                if (this.nextChar == 35) {
                    --this.added;
                    cout.write(35);
                    this.readChar();
                    continue;
                }
                cout.write(endMarker);
                cout.write(38);
                CharArrayWriter expression = new CharArrayWriter();
                while (this.nextChar != 35 && this.nextChar != -1) {
                    if (this.nextChar == 39 || this.nextChar == 34) {
                        expression.write(this.readString(true));
                        continue;
                    }
                    expression.write(this.nextChar);
                    this.readChar();
                }
                if (this.nextChar == 35) {
                    this.readChar();
                    if (this.nextChar != endMarker) {
                        expression.writeTo(cout);
                        cout.write(38);
                        cout.write(endMarker);
                        this.added += 2;
                        continue;
                    }
                    this.readChar();
                    if (this.nextChar != endMarker) {
                        if (cout.size() == 3) {
                            if (!_withinExpression) {
                                cout.reset();
                                cout.write(35);
                                expression.writeTo(cout);
                                cout.write(35);
                                ++this.added;
                                return cout.toCharArray();
                            }
                            cout.reset();
                            expression.writeTo(cout);
                            this.added -= 4;
                            return cout.toCharArray();
                        }
                        --this.added;
                        expression.writeTo(cout);
                        return cout.toCharArray();
                    }
                    expression.writeTo(cout);
                    cout.write(38);
                    cout.write(endMarker);
                    cout.write(endMarker);
                    cout.write(endMarker);
                    this.added += 2;
                    this.readChar();
                    continue;
                }
                throw new PoundSignFilterStreamException("Invalid string expression - unclosed '#' expression");
            }
            if (this.nextChar == endMarker) {
                this.readChar();
                if (this.nextChar == endMarker) {
                    cout.write(endMarker);
                    cout.write(endMarker);
                    this.readChar();
                    continue;
                }
                cout.write(endMarker);
                return cout.toCharArray();
            }
            cout.write(this.nextChar);
            this.readChar();
        }
        throw new IOException("Unclosed string expression - missing " + endMarker + ".");
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.isClosed = true;
    }

    private int readChar() throws IOException {
        if (this.isClosed) {
            return -1;
        }
        this.nextChar = this.in.read();
        return this.nextChar;
    }

    private char[] readComment() throws IOException {
        CharArrayWriter cout = new CharArrayWriter();
        boolean endComment = false;
        cout.write(42);
        this.readChar();
        while (!endComment && this.nextChar != -1) {
            cout.write(this.nextChar);
            if (this.nextChar == 42) {
                this.readChar();
                if (this.nextChar != 47) continue;
                cout.write(47);
                this.readChar();
                endComment = true;
                continue;
            }
            this.readChar();
        }
        return cout.toCharArray();
    }

    private char[] readLineComment() throws IOException {
        CharArrayWriter cout = new CharArrayWriter();
        while (this.nextChar != 13 && this.nextChar != 10 && this.nextChar != -1) {
            cout.write(this.nextChar);
            this.readChar();
        }
        return cout.toCharArray();
    }

    public int getAdded() {
        return this.added;
    }

    public static void main(String[] args) {
        int i;
        ArrayList<String> inputList = new ArrayList<String>();
        inputList.add("writeoutput( \"##\" );");
        inputList.add("writeoutput( \"#a##b#\" );");
        inputList.add("writeoutput( \"#a#\" );");
        inputList.add("writeoutput( \"#a#more text\" );");
        inputList.add("writeoutput( \"more text#a#\" );");
        inputList.add("writeoutput( \"more text#a#more text\" );");
        inputList.add("writeoutput( \"more#a#text#a#more#a#text\" );");
        inputList.add("x = 1;\nwriteoutput( \"#x#\" );");
        inputList.add("/* this is a comment line */\na = 1;\nwriteoutput( a );");
        inputList.add("/* this is a comment line */\na = 1;\nwriteoutput( a );");
        StringBuffer lastTest = new StringBuffer();
        for (i = 0; i < inputList.size(); ++i) {
            lastTest.append((String)inputList.get(i));
            lastTest.append("\r\n");
        }
        inputList.add(lastTest.toString());
        inputList.add("/*aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa\r\n  aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa\r\n  aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa\r\n  aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa\r\n  aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa*/");
        for (i = 0; i < inputList.size(); ++i) {
            String input = (String)inputList.get(i);
            try {
                PoundSignFilterStream psf = new PoundSignFilterStream(new StringReader(input));
                char[] buffer = new char[1024];
                int n = psf.read(buffer);
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

