/*
 * Decompiled with CFR 0.152.
 */
package cfml.parsing.cfscript.script;

import cfml.parsing.cfscript.CFExpression;
import cfml.parsing.cfscript.script.CFCase;
import cfml.parsing.cfscript.script.CFParsedStatement;
import cfml.parsing.cfscript.script.CFScriptStatement;
import cfml.parsing.util.ArrayBuilder;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.antlr.v4.runtime.Token;

public class CFSwitchStatement
extends CFParsedStatement
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List<CFCase> cases;
    private CFExpression variable;

    public List<CFCase> getCases() {
        return this.cases;
    }

    public CFExpression getVariable() {
        return this.variable;
    }

    public CFSwitchStatement(Token _token, CFExpression _variable, List<CFCase> _cases) {
        super(_token);
        this.cases = _cases;
        this.variable = _variable;
    }

    @Override
    public void checkIndirectAssignments(String[] scriptSource) {
        for (int i = 0; i < this.cases.size(); ++i) {
            this.cases.get(i).checkIndirectAssignments(scriptSource);
        }
    }

    @Override
    public String Decompile(int _indent) {
        StringBuilder sb = new StringBuilder();
        sb.append("switch (");
        sb.append(this.variable.Decompile(0));
        sb.append("){\n");
        for (int i = 0; i < this.cases.size(); ++i) {
            sb.append(this.cases.get(i).Decompile(0));
        }
        sb.append("\n}");
        return sb.toString();
    }

    @Override
    public List<CFExpression> decomposeExpression() {
        return ArrayBuilder.createCFExpression((CFExpression[])new CFExpression[]{this.variable});
    }

    @Override
    public List<CFScriptStatement> decomposeScript() {
        ArrayList<CFScriptStatement> retval = new ArrayList<CFScriptStatement>();
        retval.addAll(retval);
        return retval;
    }
}

