/*
 * Decompiled with CFR 0.152.
 */
package cfml.parsing.cfscript.script;

import cfml.parsing.cfscript.CFContext;
import cfml.parsing.cfscript.CFExpression;
import cfml.parsing.cfscript.CFIdentifier;
import cfml.parsing.cfscript.script.CFParsedStatement;
import cfml.parsing.cfscript.script.CFScriptStatement;
import cfml.parsing.reporting.ParseException;
import cfml.parsing.util.ArrayBuilder;
import cfml.parsing.util.CFException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.antlr.v4.runtime.Token;

public abstract class CFParsedAttributeStatement
extends CFParsedStatement
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Map<CFIdentifier, CFExpression> attributes;

    protected CFParsedAttributeStatement(Token _t, Map<CFIdentifier, CFExpression> _a) {
        super(_t);
        this.attributes = _a;
    }

    public Map<CFIdentifier, CFExpression> getAttributes() {
        return this.attributes;
    }

    protected void DecompileAttributes(StringBuilder sb) {
        ArrayList<CFIdentifier> sorted = new ArrayList<CFIdentifier>(this.attributes.keySet());
        Collections.sort(sorted, new Comparator<CFIdentifier>(){

            @Override
            public int compare(CFIdentifier o1, CFIdentifier o2) {
                return o1.toString().compareTo(o2.toString());
            }
        });
        Iterator attrIt = sorted.iterator();
        while (attrIt.hasNext()) {
            sb.append(" ");
            CFIdentifier nextKey = (CFIdentifier)attrIt.next();
            sb.append(nextKey.Decompile(0));
            sb.append("=");
            sb.append(this.attributes.get(nextKey).Decompile(0));
        }
    }

    protected boolean containsAttribute(String _k) {
        for (CFIdentifier key : this.attributes.keySet()) {
            if (!key.toString().equalsIgnoreCase(_k)) continue;
            return true;
        }
        return false;
    }

    protected void validateAttributes(Token _t, HashSet<String> _allowedKeys) {
        Iterator<CFIdentifier> it = this.attributes.keySet().iterator();
        while (it.hasNext()) {
            String nextKey = it.next().Decompile(0);
            if (_allowedKeys.contains(nextKey)) continue;
            throw new ParseException(_t, "Invalid attribute " + nextKey);
        }
    }

    protected void validateAttributesRuntime(CFContext _context, HashSet<String> _allowedKeys, String _msg) throws CFException {
        Iterator<CFIdentifier> it = this.attributes.keySet().iterator();
        while (it.hasNext()) {
            String nextKey = it.next().Decompile(0);
            if (_allowedKeys.contains(nextKey)) continue;
            throw new CFException(_msg, _context);
        }
    }

    protected Iterator<CFIdentifier> getAttributeKeyIterator() {
        return this.attributes.keySet().iterator();
    }

    @Override
    public List<CFExpression> decomposeExpression() {
        ArrayList<CFExpression> retval = new ArrayList<CFExpression>();
        for (Map.Entry<CFIdentifier, CFExpression> key : this.attributes.entrySet()) {
            retval.add(key.getKey());
            retval.add(key.getValue());
        }
        return retval;
    }

    @Override
    public List<CFScriptStatement> decomposeScript() {
        return ArrayBuilder.createCFScriptStatement((CFScriptStatement[])new CFScriptStatement[0]);
    }
}

