/*
 * Decompiled with CFR 0.152.
 */
package cfml.parsing.cfscript.script;

import cfml.parsing.cfscript.CFExpression;
import cfml.parsing.cfscript.script.CFParsedStatement;
import cfml.parsing.cfscript.script.CFScriptStatement;
import cfml.parsing.util.ArrayBuilder;
import java.io.Serializable;
import java.util.List;
import org.antlr.v4.runtime.Token;

public class CFIfStatement
extends CFParsedStatement
implements Serializable {
    private static final long serialVersionUID = 1L;
    private CFExpression cond;
    private CFScriptStatement thenStatement;
    private CFScriptStatement elseStatement;

    public CFIfStatement(Token _t, CFExpression _cond, CFScriptStatement _then, CFScriptStatement _else) {
        super(_t);
        this.cond = _cond;
        this.thenStatement = _then;
        this.elseStatement = _else;
    }

    @Override
    public void checkIndirectAssignments(String[] scriptSource) {
        this.thenStatement.checkIndirectAssignments(scriptSource);
        if (this.elseStatement != null) {
            this.elseStatement.checkIndirectAssignments(scriptSource);
        }
    }

    @Override
    public String Decompile(int indent) {
        StringBuilder s = new StringBuilder();
        s.append(this.Indent(indent));
        s.append("if(");
        s.append(this.cond.Decompile(indent));
        s.append(" ) ");
        if (this.thenStatement != null) {
            s.append(this.thenStatement.Decompile(indent + 2));
        }
        if (this.elseStatement != null) {
            s.append("\n");
            s.append(this.Indent(indent));
            s.append("else ");
            s.append(this.elseStatement.Decompile(indent + 2));
        }
        return s.toString();
    }

    public CFExpression getCond() {
        return this.cond;
    }

    public CFScriptStatement getThenStatement() {
        return this.thenStatement;
    }

    public CFScriptStatement getElseStatement() {
        return this.elseStatement;
    }

    @Override
    public List<CFExpression> decomposeExpression() {
        return ArrayBuilder.createCFExpression((CFExpression[])new CFExpression[]{this.cond});
    }

    @Override
    public List<CFScriptStatement> decomposeScript() {
        return ArrayBuilder.createCFScriptStatement((CFScriptStatement[])new CFScriptStatement[]{this.thenStatement, this.elseStatement});
    }
}

