/*
 * Decompiled with CFR 0.152.
 */
package cfml.parsing.cfscript.script;

import cfml.parsing.cfscript.CFExpression;
import cfml.parsing.cfscript.script.CFParsedStatement;
import cfml.parsing.cfscript.script.CFScriptStatement;
import cfml.parsing.util.ArrayBuilder;
import java.io.Serializable;
import java.util.List;
import org.antlr.v4.runtime.Token;

public class CFForInStatement
extends CFParsedStatement
implements Serializable {
    private static final long serialVersionUID = 1L;
    private CFExpression variable;
    private CFExpression structure;
    private CFScriptStatement body;

    public CFForInStatement(Token _t, CFExpression _key, CFExpression _structure, CFScriptStatement _body) {
        super(_t);
        this.variable = _key;
        this.structure = _structure;
        this.body = _body;
    }

    @Override
    public void checkIndirectAssignments(String[] scriptSource) {
        this.body.checkIndirectAssignments(scriptSource);
    }

    @Override
    public String Decompile(int indent) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.Indent(indent));
        sb.append("for( ");
        sb.append(this.variable.Decompile(0));
        sb.append(" in ");
        sb.append(this.structure.Decompile(indent));
        sb.append(" ) ");
        sb.append(this.body.Decompile(indent + 2));
        return sb.toString();
    }

    public CFExpression getVariable() {
        return this.variable;
    }

    public CFExpression getStructure() {
        return this.structure;
    }

    public CFScriptStatement getBody() {
        return this.body;
    }

    @Override
    public List<CFExpression> decomposeExpression() {
        return ArrayBuilder.createCFExpression((CFExpression[])new CFExpression[]{this.variable, this.structure});
    }

    @Override
    public List<CFScriptStatement> decomposeScript() {
        return ArrayBuilder.createCFScriptStatement((CFScriptStatement[])new CFScriptStatement[]{this.body});
    }
}

