/*
 * Decompiled with CFR 0.152.
 */
package cfml.parsing.cfscript.script;

import cfml.parsing.cfscript.CFExpression;
import cfml.parsing.cfscript.script.CFParsedStatement;
import cfml.parsing.cfscript.script.CFScriptStatement;
import cfml.parsing.util.ArrayBuilder;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.antlr.v4.runtime.Token;

public class CFCompoundStatement
extends CFParsedStatement
implements CFScriptStatement,
Serializable {
    private static final long serialVersionUID = 1L;
    private ArrayList<CFScriptStatement> statements = new ArrayList();

    public CFCompoundStatement() {
        super(1, 1);
    }

    public CFCompoundStatement(Token t) {
        super(t);
    }

    public void add(CFScriptStatement s) {
        this.statements.add(s);
    }

    public void addFunction(CFScriptStatement s) {
        this.statements.add(0, s);
    }

    public ArrayList<CFScriptStatement> getStatements() {
        return this.statements;
    }

    public int numOfStatements() {
        return this.statements.size();
    }

    @Override
    public void checkIndirectAssignments(String[] scriptSource) {
        for (int i = 0; i < this.statements.size(); ++i) {
            this.statements.get(i).checkIndirectAssignments(scriptSource);
        }
    }

    @Override
    public String Decompile(int indent) {
        StringBuilder s = new StringBuilder();
        s.append(this.Indent(indent));
        s.append("{\n");
        for (int i = 0; i < this.numOfStatements(); ++i) {
            CFScriptStatement statement = this.statements.get(i);
            if (statement == this) continue;
            s.append(statement.Decompile(indent + 2)).append(";\n");
        }
        s.append("\n");
        s.append(this.Indent(indent));
        s.append("}");
        return s.toString();
    }

    @Override
    public List<CFExpression> decomposeExpression() {
        return ArrayBuilder.createCFExpression((CFExpression[])new CFExpression[0]);
    }

    @Override
    public List<CFScriptStatement> decomposeScript() {
        return this.statements;
    }
}

