/*
 * Decompiled with CFR 0.152.
 */
package cfml.parsing.cfscript.script;

import cfml.parsing.cfscript.CFExpression;
import cfml.parsing.cfscript.script.CFScriptStatement;
import cfml.parsing.util.ArrayBuilder;
import java.io.Serializable;
import java.util.List;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.Token;

public class CFCase
implements CFScriptStatement,
Serializable {
    private static final long serialVersionUID = 1L;
    private List<CFScriptStatement> statements;
    private boolean isDefault = true;
    private CFExpression constant;
    CommonTokenStream tokens;

    public CFCase(CFExpression _constant, List<CFScriptStatement> _statement) {
        this(_statement);
        this.isDefault = false;
        this.constant = _constant;
    }

    public CFExpression getConstant() {
        return this.constant;
    }

    public List<CFScriptStatement> getStatements() {
        return this.statements;
    }

    public CFCase(List<CFScriptStatement> _statement) {
        this.statements = _statement;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    @Override
    public void checkIndirectAssignments(String[] scriptSource) {
        for (CFScriptStatement statement : this.statements) {
            statement.checkIndirectAssignments(scriptSource);
        }
    }

    public String toString() {
        return this.Decompile(0);
    }

    @Override
    public String Decompile(int indent) {
        StringBuilder sb = new StringBuilder();
        if (this.isDefault) {
            sb.append("default:");
        } else if (this.constant != null) {
            sb.append("case ");
            sb.append(this.constant.Decompile(0));
            sb.append(":");
        }
        for (CFScriptStatement statement : this.statements) {
            sb.append(statement.Decompile(0)).append(";");
        }
        return sb.toString();
    }

    @Override
    public CommonTokenStream getTokens() {
        return this.tokens;
    }

    @Override
    public void setTokens(CommonTokenStream tokens) {
        this.tokens = tokens;
    }

    @Override
    public Token getToken() {
        if (this.constant != null) {
            return this.constant.getToken();
        }
        if (this.statements.size() > 0) {
            return this.statements.get(0).getToken();
        }
        return null;
    }

    @Override
    public List<CFExpression> decomposeExpression() {
        return ArrayBuilder.createCFExpression((CFExpression[])new CFExpression[]{this.constant});
    }

    @Override
    public List<CFScriptStatement> decomposeScript() {
        return this.statements;
    }
}

